--
--- control.lua

local function OnPlayerSelectedArea(event, destroy)
	if event.item ~= "Ore Eraser"
	or not destroy
	then return end

	local player = event.player_index ~= nil and game.get_player(event.player_index) or nil
	if not player
	or not player.valid
	then return end

	for _, entity in ipairs(event.entities)
	do
		if entity.valid
		and entity.type == "resource"
		then
			if (settings.get_player_settings(player)["oe-all-selected"].value == true)
			-- Vanilla
			or (entity.name == "coal" and settings.get_player_settings(player)["oe-coal-selected"].value == true)
			or (entity.name == "copper-ore" and settings.get_player_settings(player)["oe-copper-ore-selected"].value == true)
			or (entity.name == "crude-oil" and settings.get_player_settings(player)["oe-crude-oil-selected"].value == true)
			or (entity.name == "iron-ore" and settings.get_player_settings(player)["oe-iron-ore-selected"].value == true)
			or (entity.name == "stone" and settings.get_player_settings(player)["oe-stone-selected"].value == true)
			or (entity.name == "uranium-ore" and settings.get_player_settings(player)["oe-uranium-ore-selected"].value == true)
			-- Krastorio 2
			or (entity.name == "imersite" and settings.get_player_settings(player)["oe-imersite-selected"].value == true)
			or (entity.name == "rare-metals" and settings.get_player_settings(player)["oe-rare-metals-selected"].value == true)
			or (entity.name == "mineral-water" and settings.get_player_settings(player)["oe-mineral-water-selected"].value == true)
			then
				entity.destroy()
			end
		end
	end
end

local function OnPlayerDroppedItem(event)
	local entity = event.entity
	if entity
	and entity.valid
	and entity.stack
	and entity.stack.name == "Ore Eraser"
	then
		entity.stack.clear()
	end
end

--

script.on_event(defines.events.on_player_selected_area, function(event) OnPlayerSelectedArea(event, true) end)
script.on_event(defines.events.on_player_alt_selected_area, function(event) OnPlayerSelectedArea(event, false) end)
script.on_event(defines.events.on_player_dropped_item, function(event) OnPlayerDroppedItem(event) end)
