-- Only one of these presets can be used.
-- Add milestones for a mod here if the mod is a major mod that changes the game a lot and would not work well combined with another major mod.
-- If the mod is small and could be combined with any major mod, add the milestones in preset_addons.lua instead.

-- The preset with the highest number of "required mods" matches will be selected. (e.g. Bob's and Angel's will be selected over just Bob's)
-- If the mod is compatible with a limited amount of other major mods, you can have a preset for combinations (e.g. There is an SE preset, a K2 preset, and a SE+K2 preset)

-- If you would rather do things yourself, you can add your preset in your own mod:
-- Have your mod implement a "milestones_presets" interface, which the Milestones mod will call (in presets_loader.lua).
-- Example: 
-- remote.add_interface("my-cool-mod", {
--     milestones_presets = function()
--         return {
--             ["My Cool Mod"] = {
--                 required_mods = {"my-cool-mod"},
--                 milestones = {
--                     {type="group", name="Science"},
--                     {type="item",  name="my-cool-mod-science-pack", quantity=1},
--                 }
--             },
--             ["My Cool Mod (with Weapons extras)"] = {
--                 required_mods = {"my-cool-mod", "my-cool-mod-weapons"},
--                 milestones = {
--                     {type="group", name="Science"},
--                     {type="item",  name="my-cool-mod-science-pack", quantity=1},
--                     {type="group", name="Weapons"},
--                     {type="item",  name="my-cool-mod-thermonuclear-antimatter-atomic-plasma-multibarrel-automatic-rocket-rifle", quantity=1},
--                 }
--             }
--         }
--     end
-- })


presets = {
    ["Vanilla"] = {
        required_mods = {},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack", quantity=1},
            {type="item",       name="logistic-science-pack",   quantity=1},
            {type="item",       name="military-science-pack",   quantity=1},
            {type="item",       name="chemical-science-pack",   quantity=1},
            {type="item",       name="production-science-pack", quantity=1},
            {type="item",       name="utility-science-pack",    quantity=1},
            {type="item",       name="space-science-pack",      quantity=1},
            {type="item",       name="automation-science-pack", quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="production-science-pack", quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",    quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",      quantity=10000, next="x10"},

            {type="group",      name="Progress"},
            {type="item",       name="locomotive",              quantity=1},
            {type="fluid",      name="petroleum-gas",           quantity=1},
            {type="item",       name="construction-robot",      quantity=1},
            {type="technology", name="rocket-silo",             quantity=1},
            {type="item",       name="rocket-part",             quantity=100},
            {type="item",       name="spidertron",              quantity=1},

            {type="group",      name="Power"},
            {type="item",       name="solar-panel",             quantity=1},
            {type="item",       name="solar-panel",             quantity=1000, next="x10"},
            {type="item",       name="nuclear-reactor",         quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",            quantity=1},
            {type="kill",       name="big-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1000, next="x10"},
            {type="kill",       name="character",               quantity=1, next="x5", hidden=true},
        }
    },


    ["Space Exploration"] = {
        required_mods = {"space-exploration"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack",      quantity=1},
            {type="item",       name="logistic-science-pack",        quantity=1},
            {type="item",       name="military-science-pack",        quantity=1},
            {type="item",       name="chemical-science-pack",        quantity=1},
            {type="item",       name="se-rocket-science-pack",       quantity=1},
            {type="item",       name="space-science-pack",           quantity=1},
            {type="item",       name="production-science-pack",      quantity=1},
            {type="item",       name="utility-science-pack",         quantity=1},
            {type="item",       name="se-significant-data",          quantity=1},
            {type="item",       name="se-astronomic-science-pack-1", quantity=1},
            {type="item",       name="se-astronomic-science-pack-2", quantity=1},
            {type="item",       name="se-astronomic-science-pack-3", quantity=1},
            {type="item",       name="se-astronomic-science-pack-4", quantity=1},
            {type="item",       name="se-biological-science-pack-1", quantity=1},
            {type="item",       name="se-biological-science-pack-2", quantity=1},
            {type="item",       name="se-biological-science-pack-3", quantity=1},
            {type="item",       name="se-biological-science-pack-4", quantity=1},
            {type="item",       name="se-energy-science-pack-1",     quantity=1},
            {type="item",       name="se-energy-science-pack-2",     quantity=1},
            {type="item",       name="se-energy-science-pack-3",     quantity=1},
            {type="item",       name="se-energy-science-pack-4",     quantity=1},
            {type="item",       name="se-material-science-pack-1",   quantity=1},
            {type="item",       name="se-material-science-pack-2",   quantity=1},
            {type="item",       name="se-material-science-pack-3",   quantity=1},
            {type="item",       name="se-material-science-pack-4",   quantity=1},
            {type="item",       name="se-deep-space-science-pack-1", quantity=1},
            {type="item",       name="se-deep-space-science-pack-2", quantity=1},
            {type="item",       name="se-deep-space-science-pack-3", quantity=1},
            {type="item",       name="se-deep-space-science-pack-4", quantity=1},
            {type="item",       name="se-significant-data",          quantity=1000, next="x10"},

            {type="group",      name="Resources"},
            {type="fluid",      name="petroleum-gas",                quantity=1},
            {type="item",       name="se-core-fragment-omni",        quantity=1},
            {type="item",       name="se-vulcanite-block",           quantity=1},
            {type="item",       name="se-cryonite-rod",              quantity=1},
            {type="item",       name="se-vitamelange-spice",         quantity=1},
            {type="item",       name="se-beryllium-ingot",           quantity=1},
            {type="item",       name="se-holmium-ingot",             quantity=1},
            {type="item",       name="se-iridium-ingot",             quantity=1},
            {type="item",       name="se-naquium-ingot",             quantity=1},
            {type="item",       name="se-arcosphere",                quantity=1},

            {type="group",      name="Progress"},
            {type="item",       name="locomotive",                   quantity=1},
            {type="item",       name="construction-robot",           quantity=1},
            {type="item",       name="se-rocket-launch-pad-silo-dummy-result-item", quantity=1, next="x10"},
            {type="item",       name="logistic-chest-requester",     quantity=1},
            {type="technology", name="se-spaceship",                 quantity=1},
            {type="item",       name="se-space-elevator",            quantity=1},
            {type="item",       name="se-dimensional-anchor",        quantity=8, hidden=true},
            {type="technology", name="se-long-range-star-mapping",   quantity=1, hidden=true},
            {type="technology", name="se-spaceship-victory",         quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",                 quantity=1},
            {type="kill",       name="big-biter",                    quantity=1},
            {type="kill",       name="behemoth-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",               quantity=1000, next="x10"},
            {type="item",       name="se-plague-bomb",               quantity=1},
            {type="kill",       name="character",                    quantity=1, next="x5", hidden=true},
        }
    },


    ["Krastorio 2"] = {
        required_mods = {"Krastorio2"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="basic-tech-card",              quantity=1},
            {type="item",       name="automation-science-pack",      quantity=1},
            {type="item",       name="logistic-science-pack",        quantity=1},
            {type="item",       name="military-science-pack",        quantity=1},
            {type="item",       name="chemical-science-pack",        quantity=1},
            {type="item",       name="production-science-pack",      quantity=1},
            {type="item",       name="utility-science-pack",         quantity=1},
            {type="item",       name="space-science-pack",           quantity=1},
            {type="item",       name="matter-tech-card",             quantity=1},
            {type="item",       name="advanced-tech-card",           quantity=1},
            {type="item",       name="singularity-tech-card",        quantity=1},
            {type="item",       name="basic-tech-card",              quantity=1000, next="x10"},
            {type="item",       name="automation-science-pack",      quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="production-science-pack",      quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",         quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",           quantity=10000, next="x10"},
            {type="item",       name="matter-tech-card",             quantity=1000, next="x10"},
            {type="item",       name="advanced-tech-card",           quantity=1000, next="x10"},
            {type="item",       name="singularity-tech-card",        quantity=1000, next="x10"},

            {type="group",      name="Resources"},
            {type="fluid",      name="petroleum-gas",                quantity=1},
            {type="fluid",      name="mineral-water",                quantity=1},
            {type="item",       name="silicon",                      quantity=1},
            {type="item",       name="rare-metals",                  quantity=1},
            {type="item",       name="imersite-powder",              quantity=1},

            {type="group",      name="Progress"},
            {type="item",       name="locomotive",                   quantity=1},
            {type="item",       name="construction-robot",           quantity=1},
            {type="item",       name="ai-core",                      quantity=1},
            {type="fluid",      name="matter",                       quantity=1},
            {type="technology", name="kr-advanced-pickaxe",          quantity=1},
            {type="item",       name="kr-intergalactic-transceiver", quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",                 quantity=1},
            {type="kill",       name="big-biter",                    quantity=1},
            {type="kill",       name="behemoth-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",               quantity=1000, next="x10"},
            {type="kill",       name="character",                    quantity=1, next="x5", hidden=true},
        }
    },


    ["Space Exploration + Krastorio 2"] = {
        required_mods = {"space-exploration", "Krastorio2"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="basic-tech-card",              quantity=1},
            {type="item",       name="automation-science-pack",      quantity=1},
            {type="item",       name="logistic-science-pack",        quantity=1},
            {type="item",       name="military-science-pack",        quantity=1},
            {type="item",       name="chemical-science-pack",        quantity=1},
            {type="item",       name="se-rocket-science-pack",       quantity=1},
            {type="item",       name="space-science-pack",           quantity=1},
            {type="item",       name="kr-optimization-tech-card",    quantity=1},
            {type="item",       name="production-science-pack",      quantity=1},
            {type="item",       name="utility-science-pack",         quantity=1},
            {type="item",       name="se-significant-data",          quantity=1},
            {type="item",       name="se-astronomic-science-pack-1", quantity=1},
            {type="item",       name="se-astronomic-science-pack-2", quantity=1},
            {type="item",       name="se-astronomic-science-pack-3", quantity=1},
            {type="item",       name="se-astronomic-science-pack-4", quantity=1},
            {type="item",       name="se-biological-science-pack-1", quantity=1},
            {type="item",       name="se-biological-science-pack-2", quantity=1},
            {type="item",       name="se-biological-science-pack-3", quantity=1},
            {type="item",       name="se-biological-science-pack-4", quantity=1},
            {type="item",       name="se-energy-science-pack-1",     quantity=1},
            {type="item",       name="se-energy-science-pack-2",     quantity=1},
            {type="item",       name="se-energy-science-pack-3",     quantity=1},
            {type="item",       name="se-energy-science-pack-4",     quantity=1},
            {type="item",       name="se-material-science-pack-1",   quantity=1},
            {type="item",       name="se-material-science-pack-2",   quantity=1},
            {type="item",       name="se-material-science-pack-3",   quantity=1},
            {type="item",       name="se-material-science-pack-4",   quantity=1},
            {type="item",       name="matter-tech-card",             quantity=1},
            {type="item",       name="se-kr-matter-science-pack-2",  quantity=1},
            {type="item",       name="advanced-tech-card",           quantity=1},
            {type="item",       name="singularity-tech-card",        quantity=1},
            {type="item",       name="se-deep-space-science-pack-1", quantity=1},
            {type="item",       name="se-deep-space-science-pack-2", quantity=1},
            {type="item",       name="se-deep-space-science-pack-3", quantity=1},
            {type="item",       name="se-deep-space-science-pack-4", quantity=1},
            {type="item",       name="se-significant-data",          quantity=1000, next="x10"},

            {type="group",      name="Resources"},
            {type="fluid",      name="petroleum-gas",                quantity=1},
            {type="item",       name="silicon",                      quantity=1},
            {type="item",       name="se-core-fragment-omni",        quantity=1},
            {type="item",       name="se-vulcanite-block",           quantity=1},
            {type="item",       name="se-cryonite-rod",              quantity=1},
            {type="item",       name="se-vitamelange-spice",         quantity=1},
            {type="item",       name="se-beryllium-ingot",           quantity=1},
            {type="item",       name="se-holmium-ingot",             quantity=1},
            {type="item",       name="se-iridium-ingot",             quantity=1},
            {type="fluid",      name="mineral-water",                quantity=1},
            {type="item",       name="rare-metals",                  quantity=1},
            {type="item",       name="imersite-powder",              quantity=1},
            {type="item",       name="se-naquium-ingot",             quantity=1},
            {type="item",       name="se-arcosphere",                quantity=1},

            {type="group",      name="Progress"},
            {type="item",       name="locomotive",                   quantity=1},
            {type="item",       name="construction-robot",           quantity=1},
            {type="item",       name="se-rocket-launch-pad-silo-dummy-result-item", quantity=1, next="x10"},
            {type="item",       name="logistic-chest-requester",     quantity=1},
            {type="technology", name="se-spaceship",                 quantity=1},
            {type="item",       name="se-space-elevator",            quantity=1},
            {type="technology", name="kr-advanced-pickaxe",          quantity=1},
            {type="item",       name="ai-core",                      quantity=1},
            {type="fluid",      name="matter",                       quantity=1},
            {type="item",       name="se-dimensional-anchor",        quantity=8, hidden=true},
            {type="technology", name="se-long-range-star-mapping",   quantity=1, hidden=true},
            {type="item",       name="kr-intergalactic-transceiver", quantity=1},
            {type="technology", name="se-spaceship-victory",         quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",                 quantity=1},
            {type="kill",       name="big-biter",                    quantity=1},
            {type="kill",       name="behemoth-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",               quantity=1000, next="x10"},
            {type="item",       name="se-plague-bomb",               quantity=1},
            {type="kill",       name="character",                    quantity=1, next="x5", hidden=true},
        }
    },


    ["248k Mod"] = {
        required_mods = {"248k"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack", quantity=1},
            {type="item",       name="logistic-science-pack",   quantity=1},
            {type="item",       name="military-science-pack",   quantity=1},
            {type="item",       name="chemical-science-pack",   quantity=1},
            {type="item",       name="production-science-pack", quantity=1},
            {type="item",       name="utility-science-pack",    quantity=1},
            {type="item",       name="space-science-pack",      quantity=1},
            {type="item",       name="automation-science-pack", quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="production-science-pack", quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",    quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",      quantity=10000, next="x10"},

            {type="group",      name="Stages"},
            {type="technology", name="el_stage_tech",  quantity=1},
            {type="technology", name="el_energy_tech", quantity=1},
            {type="technology", name="fi_stage_tech",  quantity=1},
            {type="technology", name="fi_energy_tech", quantity=1},
            {type="technology", name="fu_stage_tech",  quantity=1},
            {type="technology", name="fu_energy_tech", quantity=1},
            {type="technology", name="gr_stage_tech",  quantity=1},

            {type="group",      name="Vanilla"},
            {type="fluid",      name="petroleum-gas",      quantity=1},
            {type="item",       name="locomotive",         quantity=1},
            {type="item",       name="construction-robot", quantity=1},
            {type="item",       name="logistic-robot",     quantity=1},

            {type="group",      name="Electronics"},
            {type="item",       name="el_materials_ALK",       quantity=1},
            {type="item",       name="el_energy_crystal_item", quantity=1},
            {type="item",       name="el_diesel_train_item",   quantity=1},

            {type="group",      name="Fission"},
            {type="item",       name="fi_materials_glass",     quantity=1},
            {type="item",       name="fi_materials_gold",      quantity=1},
            {type="item",       name="fi_materials_neodym",    quantity=1},
            {type="item",       name="fi_materials_titan",     quantity=1},
            {type="item",       name="fi_materials_GFK",       quantity=1},
            {type="item",       name="fi_materials_NFK",       quantity=1},
            {type="item",       name="fi_energy_crystal_item", quantity=1},
            {type="item",       name="fi_solid_reactor_item",  quantity=1},

            {type="group",      name="Fusion"},
            {type="item",       name="fu_materials_KFK",          quantity=1},
            {type="item",       name="fu_materials_TIM",          quantity=1},
            {type="item",       name="fu_materials_fusion_card",  quantity=1},
            {type="item",       name="fu_materials_plasma_card",  quantity=1},
            {type="item",       name="fu_materials_laser_card",   quantity=1},
            {type="item",       name="fu_materials_magnet_card",  quantity=1},
            {type="item",       name="fu_tech_sign_item",         quantity=1},
            {type="item",       name="fu_robo_logistic_item",     quantity=1},
            {type="item",       name="fu_robo_construction_item", quantity=1},
            {type="item",       name="fu_stelar_reactor_item",    quantity=1},
            {type="item",       name="fu_tokamak_reactor_item",   quantity=1},
            {type="item",       name="fu_star_engine_core_item",  quantity=1},

            {type="group",      name="Exotics"},
            {type="item",       name="fu_space_probe_science_item", quantity=1},
            {type="item",       name="gr_materials_circuit",        quantity=1},
            {type="item",       name="gr_materials_magnet",         quantity=1},
            {type="item",       name="gr_magnet_train_pre_item",    quantity=1},
            {type="item",       name="gr_magnet_train_item",        quantity=1},
            {type="item",       name="gr_black_hole_item",          quantity=1},
            {type="item",       name="gr_white_hole_item",          quantity=1},

            {type="group",      name="Elements"},
            {type="item",       name="gr_materials_red_item",    quantity=1},
            {type="item",       name="gr_materials_green_item",  quantity=1},
            {type="item",       name="gr_materials_blue_item",   quantity=1},
            {type="item",       name="gr_materials_purple_item", quantity=1},
            {type="item",       name="gr_materials_yellow_item", quantity=1},
            {type="item",       name="gr_materials_grey_item",   quantity=1},
            {type="item",       name="gr_materials_white_item",  quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",            quantity=1},
            {type="kill",       name="big-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1000, next="x10"},
            {type="kill",       name="character",               quantity=1, next="x5", hidden=true},
        }
    },


    ["Krastorio2 + 248k"] = {
        required_mods = {"Krastorio2", "248k"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="basic-tech-card",              quantity=1},
            {type="item",       name="automation-science-pack",      quantity=1},
            {type="item",       name="logistic-science-pack",        quantity=1},
            {type="item",       name="military-science-pack",        quantity=1},
            {type="item",       name="chemical-science-pack",        quantity=1},
            {type="item",       name="production-science-pack",      quantity=1},
            {type="item",       name="utility-science-pack",         quantity=1},
            {type="item",       name="space-science-pack",           quantity=1},
            {type="item",       name="matter-tech-card",             quantity=1},
            {type="item",       name="advanced-tech-card",           quantity=1},
            {type="item",       name="singularity-tech-card",        quantity=1},
            {type="item",       name="basic-tech-card",              quantity=1000, next="x10"},
            {type="item",       name="automation-science-pack",      quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="production-science-pack",      quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",         quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",           quantity=10000, next="x10"},
            {type="item",       name="matter-tech-card",             quantity=1000, next="x10"},
            {type="item",       name="advanced-tech-card",           quantity=1000, next="x10"},
            {type="item",       name="singularity-tech-card",        quantity=1000, next="x10"},

            {type="group",      name="Stages"},
            {type="technology", name="el_stage_tech", quantity=1},
            {type="technology", name="el_energy_tech", quantity=1},
            {type="technology", name="fi_stage_tech", quantity=1},
            {type="technology", name="fi_energy_tech", quantity=1},
            {type="technology", name="fu_stage_tech", quantity=1},
            {type="technology", name="fu_energy_tech", quantity=1},
            {type="technology", name="gr_stage_tech", quantity=1},

            {type="group",      name="Vanilla"},
            {type="fluid",      name="petroleum-gas",      quantity=1},
            {type="item",       name="locomotive",         quantity=1},
            {type="item",       name="construction-robot", quantity=1},
            {type="item",       name="logistic-robot",     quantity=1},

            {type="group",      name="K2 Progress"},
            {type="item",       name="ai-core",                      quantity=1},
            {type="fluid",      name="matter",                       quantity=1},
            {type="technology", name="kr-advanced-pickaxe",          quantity=1},
            {type="item",       name="kr-intergalactic-transceiver", quantity=1},

            {type="group",      name="K2 Resources"},
            {type="fluid",      name="mineral-water",                quantity=1},
            {type="item",       name="silicon",                      quantity=1},
            {type="item",       name="rare-metals",                  quantity=1},
            {type="item",       name="imersite-powder",              quantity=1},

            {type="group",      name="Electronics"},
            {type="item",       name="el_materials_ALK",       quantity=1},
            {type="item",       name="el_energy_crystal_item", quantity=1},
            {type="item",       name="el_diesel_train_item",   quantity=1},

            {type="group",      name="Fission"},
            {type="item",       name="fi_materials_glass",     quantity=1},
            {type="item",       name="fi_materials_gold",      quantity=1},
            {type="item",       name="fi_materials_neodym",    quantity=1},
            {type="item",       name="fi_materials_titan",     quantity=1},
            {type="item",       name="fi_materials_GFK",       quantity=1},
            {type="item",       name="fi_materials_NFK",       quantity=1},
            {type="item",       name="fi_energy_crystal_item", quantity=1},
            {type="item",       name="fi_solid_reactor_item",  quantity=1},

            {type="group",      name="Fusion"},
            {type="item",       name="fu_materials_KFK", quantity=1},
            {type="item",       name="fu_materials_TIM", quantity=1},
            {type="item",       name="fu_materials_fusion_card", quantity=1},
            {type="item",       name="fu_materials_plasma_card", quantity=1},
            {type="item",       name="fu_materials_laser_card", quantity=1},
            {type="item",       name="fu_materials_magnet_card", quantity=1},
            {type="item",       name="fu_tech_sign_item", quantity=1},
            {type="item",       name="fu_robo_logistic_item", quantity=1},
            {type="item",       name="fu_robo_construction_item", quantity=1},
            {type="item",       name="fu_stelar_reactor_item", quantity=1},
            {type="item",       name="fu_tokamak_reactor_item", quantity=1},
            {type="item",       name="fu_star_engine_core_item", quantity=1},

            {type="group",      name="Exotics"},
            {type="item",       name="fu_space_probe_science_item", quantity=1},
            {type="item",       name="gr_materials_circuit",        quantity=1},
            {type="item",       name="gr_materials_magnet",         quantity=1},
            {type="item",       name="gr_magnet_train_pre_item",    quantity=1},
            {type="item",       name="gr_magnet_train_item",        quantity=1},
            {type="item",       name="gr_black_hole_item",          quantity=1},
            {type="item",       name="gr_white_hole_item",          quantity=1},

            {type="group",      name="Elements"},
            {type="item",       name="gr_materials_red_item",    quantity=1},
            {type="item",       name="gr_materials_green_item",  quantity=1},
            {type="item",       name="gr_materials_blue_item",   quantity=1},
            {type="item",       name="gr_materials_purple_item", quantity=1},
            {type="item",       name="gr_materials_yellow_item", quantity=1},
            {type="item",       name="gr_materials_grey_item",   quantity=1},
            {type="item",       name="gr_materials_white_item",  quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",            quantity=1},
            {type="kill",       name="big-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1000, next="x10"},
            {type="kill",       name="character",               quantity=1, next="x5", hidden=true},
        }
    },


    ["Space Exploration + Krastorio2 + 248k (No Spoilers)"] = {
        required_mods = {"space-exploration", "Krastorio2", "248k"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="basic-tech-card",              quantity=1},
            {type="item",       name="automation-science-pack",      quantity=1},
            {type="item",       name="logistic-science-pack",        quantity=1},
            {type="item",       name="military-science-pack",        quantity=1},
            {type="item",       name="chemical-science-pack",        quantity=1},
            {type="item",       name="se-rocket-science-pack",       quantity=1},
            {type="item",       name="space-science-pack",           quantity=1},
            {type="item",       name="kr-optimization-tech-card",    quantity=1},
            {type="item",       name="production-science-pack",      quantity=1},
            {type="item",       name="utility-science-pack",         quantity=1},
            {type="item",       name="se-significant-data",          quantity=1},
            {type="item",       name="se-astronomic-science-pack-1", quantity=1},
            {type="item",       name="se-astronomic-science-pack-2", quantity=1},
            {type="item",       name="se-astronomic-science-pack-3", quantity=1},
            {type="item",       name="se-astronomic-science-pack-4", quantity=1},
            {type="item",       name="se-biological-science-pack-1", quantity=1},
            {type="item",       name="se-biological-science-pack-2", quantity=1},
            {type="item",       name="se-biological-science-pack-3", quantity=1},
            {type="item",       name="se-biological-science-pack-4", quantity=1},
            {type="item",       name="se-energy-science-pack-1",     quantity=1},
            {type="item",       name="se-energy-science-pack-2",     quantity=1},
            {type="item",       name="se-energy-science-pack-3",     quantity=1},
            {type="item",       name="se-energy-science-pack-4",     quantity=1},
            {type="item",       name="se-material-science-pack-1",   quantity=1},
            {type="item",       name="se-material-science-pack-2",   quantity=1},
            {type="item",       name="se-material-science-pack-3",   quantity=1},
            {type="item",       name="se-material-science-pack-4",   quantity=1},
            {type="item",       name="matter-tech-card",             quantity=1},
            {type="item",       name="se-kr-matter-science-pack-2",  quantity=1},
            {type="item",       name="advanced-tech-card",           quantity=1},
            {type="item",       name="singularity-tech-card",        quantity=1},
            {type="item",       name="se-deep-space-science-pack-1", quantity=1},
            {type="item",       name="se-deep-space-science-pack-2", quantity=1},
            {type="item",       name="se-deep-space-science-pack-3", quantity=1},
            {type="item",       name="se-deep-space-science-pack-4", quantity=1},
            {type="item",       name="se-significant-data",          quantity=1000, next="x10"},

            {type="group",      name="Resources"},
            {type="fluid",      name="petroleum-gas",                quantity=1},
            {type="item",       name="silicon",                      quantity=1},
            {type="item",       name="se-core-fragment-omni",        quantity=1},
            {type="item",       name="se-vulcanite-block",           quantity=1},
            {type="item",       name="se-cryonite-rod",              quantity=1},
            {type="item",       name="se-vitamelange-spice",         quantity=1},
            {type="item",       name="se-beryllium-ingot",           quantity=1},
            {type="item",       name="se-holmium-ingot",             quantity=1},
            {type="item",       name="se-iridium-ingot",             quantity=1},
            {type="fluid",      name="mineral-water",                quantity=1},
            {type="item",       name="rare-metals",                  quantity=1},
            {type="item",       name="imersite-powder",              quantity=1},
            {type="item",       name="se-naquium-ingot",             quantity=1},
            {type="item",       name="se-arcosphere",                quantity=1},

            {type="group",      name="Progress"},
            {type="item",       name="locomotive",                   quantity=1},
            {type="item",       name="construction-robot",           quantity=1},
            {type="item",       name="el_diesel_train_item",         quantity=1},
            {type="item",       name="gr_magnet_train_pre_item",     quantity=1},
            {type="item",       name="gr_magnet_train_item",         quantity=1},
            {type="item",       name="logistic-robot",               quantity=1},
            {type="item",       name="fu_robo_logistic_item",        quantity=1},
            {type="item",       name="fu_robo_construction_item",    quantity=1},
            {type="item",       name="se-rocket-launch-pad-silo-dummy-result-item", quantity=1, next="x10"},
            {type="item",       name="logistic-chest-requester",     quantity=1},
            {type="technology", name="se-spaceship",                 quantity=1},
            {type="item",       name="se-space-elevator",            quantity=1},
            {type="technology", name="kr-advanced-pickaxe",          quantity=1},
            {type="item",       name="ai-core",                      quantity=1},
            {type="fluid",      name="matter",                       quantity=1},
            {type="item",       name="se-dimensional-anchor",        quantity=8, hidden=true},
            {type="technology", name="se-long-range-star-mapping",   quantity=1, hidden=true},
            {type="item",       name="kr-intergalactic-transceiver", quantity=1},
            {type="technology", name="se-spaceship-victory",         quantity=1},

            {type="group",      name="Stages"},
            {type="technology", name="el_stage_tech",                quantity=1},
            {type="technology", name="el_energy_tech",               quantity=1},
            {type="technology", name="fi_stage_tech",                quantity=1},
            {type="technology", name="fi_energy_tech",               quantity=1},
            {type="technology", name="fu_stage_tech",                quantity=1},
            {type="technology", name="fu_energy_tech",               quantity=1},
            {type="technology", name="gr_stage_tech",                quantity=1},

            {type="group",      name="Materials"},
            {type="item",       name="el_materials_ALK",             quantity=1},
            {type="item",       name="el_energy_crystal_item",       quantity=1},
            {type="item",       name="fi_materials_glass",           quantity=1},
            {type="item",       name="fi_materials_gold",            quantity=1},
            {type="item",       name="fi_materials_neodym",          quantity=1},
            {type="item",       name="fi_materials_titan",           quantity=1},
            {type="item",       name="fi_materials_GFK",             quantity=1},
            {type="item",       name="fi_materials_NFK",             quantity=1},
            {type="item",       name="fi_energy_crystal_item",       quantity=1},
            {type="item",       name="fi_solid_reactor_item",        quantity=1},
            {type="item",       name="fu_materials_KFK",             quantity=1},
            {type="item",       name="fu_materials_TIM",             quantity=1},
            {type="item",       name="fu_materials_fusion_card",     quantity=1},

            {type="item",       name="fu_materials_plasma_card",     quantity=1},
            {type="item",       name="fu_materials_laser_card",      quantity=1},
            {type="item",       name="fu_materials_magnet_card",     quantity=1},
            {type="item",       name="fu_tech_sign_item",            quantity=1},
            {type="item",       name="fu_stelar_reactor_item",       quantity=1},
            {type="item",       name="fu_tokamak_reactor_item",      quantity=1},
            {type="item",       name="fu_star_engine_core_item",     quantity=1},
            {type="item",       name="fu_space_probe_science_item",  quantity=1},
            {type="item",       name="gr_materials_circuit",         quantity=1},
            {type="item",       name="gr_materials_magnet",          quantity=1},
            {type="item",       name="gr_black_hole_item",           quantity=1},
            {type="item",       name="gr_white_hole_item",           quantity=1},

            {type="group",      name="Elements"},
            {type="item",       name="gr_materials_red_item",        quantity=1},
            {type="item",       name="gr_materials_green_item",      quantity=1},
            {type="item",       name="gr_materials_blue_item",       quantity=1},
            {type="item",       name="gr_materials_purple_item",     quantity=1},
            {type="item",       name="gr_materials_yellow_item",     quantity=1},
            {type="item",       name="gr_materials_grey_item",       quantity=1},
            {type="item",       name="gr_materials_white_item",      quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",                 quantity=1},
            {type="kill",       name="big-biter",                    quantity=1},
            {type="kill",       name="behemoth-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",               quantity=1000, next="x10"},
            {type="kill",       name="character",                    quantity=1, next="x5", hidden=true},
        }
    },


    ["Bob's Mods (Without Bob's Tech)"] = {
        required_mods = {"bobplates", "bobelectronics"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack",        quantity=1},
            {type="item",       name="logistic-science-pack",          quantity=1},
            {type="item",       name="military-science-pack",          quantity=1},
            {type="item",       name="chemical-science-pack",          quantity=1},
            {type="item",       name="production-science-pack",        quantity=1},
            {type="item",       name="utility-science-pack",           quantity=1},
            {type="item",       name="space-science-pack",             quantity=1},
            {type="item",       name="automation-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",          quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",          quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",          quantity=1000, next="x10"},
            {type="item",       name="production-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",           quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",             quantity=10000, next="x10"},

            {type="group",      name="Resources"},
            {type="item",       name="electronic-circuit",             quantity=1},
            {type="item",       name="advanced-circuit",               quantity=1},
            {type="item",       name="processing-unit",                quantity=1},
            {type="item",       name="advanced-processing-unit",       quantity=1},
            {type="item",       name="bronze-alloy",                   quantity=1},
            {type="item",       name="invar-alloy",                    quantity=1},
            {type="item",       name="brass-alloy",                    quantity=1},
            {type="item",       name="silver-plate",                   quantity=1},
            {type="item",       name="gold-plate",                     quantity=1},
            {type="item",       name="aluminium-plate",                quantity=1},
            {type="item",       name="cobalt-steel-alloy",             quantity=1},
            {type="item",       name="plastic-bar",                    quantity=1},
            {type="item",       name="silicon-nitride",                quantity=1},
            {type="item",       name="titanium-plate",                 quantity=1},
            {type="item",       name="tungsten-plate",                 quantity=1},
            {type="item",       name="copper-tungsten-alloy",          quantity=1},
            {type="item",       name="tungsten-carbide",               quantity=1},
            {type="item",       name="nitinol-alloy",                  quantity=1},

            {type="group",      name="Progress"},
            {type="item",       name="locomotive",                     quantity=1},
            {type="item",       name="antron",                         quantity=1},
            {type="item",       name="construction-robot",             quantity=1},
            {type="item",       name="uranium-fuel-cell",              quantity=1},
            {type="technology", name="rocket-silo",                    quantity=1},
            {type="item",       name="rocket-part",                    quantity=100},

            {type="group",      name="Kills"},
            {type="kill",       name="character",                      quantity=1, next="x5", hidden=true},
        }
    },


    ["Bob's Mods"] = {
        required_mods = {"bobplates", "bobelectronics", "bobtech"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack",        quantity=1},
            {type="item",       name="logistic-science-pack",          quantity=1},
            {type="item",       name="military-science-pack",          quantity=1},
            {type="item",       name="chemical-science-pack",          quantity=1},
            {type="item",       name="science-pack-gold",              quantity=1},
            {type="item",       name="advanced-logistic-science-pack", quantity=1},
            {type="item",       name="production-science-pack",        quantity=1},
            {type="item",       name="utility-science-pack",           quantity=1},
            {type="item",       name="space-science-pack",             quantity=1},
            {type="item",       name="automation-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",          quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",          quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",          quantity=1000, next="x10"},
            {type="item",       name="science-pack-gold",              quantity=1000, next="x10"},
            {type="item",       name="advanced-logistic-science-pack", quantity=1000, next="x10"},
            {type="item",       name="production-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",           quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",             quantity=10000, next="x10"},

            {type="group",      name="Resources"},
            {type="item",       name="electronic-circuit",             quantity=1},
            {type="item",       name="advanced-circuit",               quantity=1},
            {type="item",       name="processing-unit",                quantity=1},
            {type="item",       name="advanced-processing-unit",       quantity=1},
            {type="item",       name="bronze-alloy",                   quantity=1},
            {type="item",       name="invar-alloy",                    quantity=1},
            {type="item",       name="brass-alloy",                    quantity=1},
            {type="item",       name="silver-plate",                   quantity=1},
            {type="item",       name="gold-plate",                     quantity=1},
            {type="item",       name="aluminium-plate",                quantity=1},
            {type="item",       name="cobalt-steel-alloy",             quantity=1},
            {type="item",       name="plastic-bar",                    quantity=1},
            {type="item",       name="silicon-nitride",                quantity=1},
            {type="item",       name="titanium-plate",                 quantity=1},
            {type="item",       name="tungsten-plate",                 quantity=1},
            {type="item",       name="copper-tungsten-alloy",          quantity=1},
            {type="item",       name="tungsten-carbide",               quantity=1},
            {type="item",       name="nitinol-alloy",                  quantity=1},

            {type="group",      name="Progress"},
            {type="item",       name="locomotive",                     quantity=1},
            {type="item",       name="antron",                         quantity=1},
            {type="item",       name="construction-robot",             quantity=1},
            {type="item",       name="uranium-fuel-cell",              quantity=1},
            {type="technology", name="rocket-silo",                    quantity=1},
            {type="item",       name="rocket-part",                    quantity=100},

            {type="group",      name="Kills"},
            {type="kill",       name="character",                      quantity=1, next="x5", hidden=true},
        }
    },


    ["Angel's Industries"] = {
        required_mods = {"angelsindustries"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack",   quantity=1},
            {type="item",       name="logistic-science-pack",     quantity=1},
            {type="item",       name="military-science-pack",     quantity=1},
            {type="item",       name="chemical-science-pack",     quantity=1},
            {type="item",       name="production-science-pack",   quantity=1},
            {type="item",       name="utility-science-pack",      quantity=1},
            {type="item",       name="space-science-pack",        quantity=1},
            {type="item",       name="token-bio",                 quantity=1},
            {type="item",       name="automation-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",     quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",     quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",     quantity=1000, next="x10"},
            {type="item",       name="production-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",      quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",        quantity=10000, next="x10"},

            {type="group",      name="Resources"},
            {type="fluid",      name="gas-methane",               quantity=1},
            {type="item",       name="plastic-bar",               quantity=1},
            {type="item",       name="sulfur",                    quantity=1},
            {type="fluid",      name="liquid-sulfuric-acid",      quantity=1},
            {type="item",       name="electronic-circuit",        quantity=1},
            {type="item",       name="advanced-circuit",          quantity=1},
            {type="item",       name="processing-unit",           quantity=1},
            {type="item",       name="angels-plate-titanium",     quantity=1},
            {type="item",       name="angels-plate-tungsten",     quantity=1},

            {type="group",      name="Progress"},
            {type="item",       name="locomotive",                quantity=1},
            {type="item",       name="angels-construction-robot", quantity=1},
            {type="item",       name="construction-robot",        quantity=1},
            {type="item",       name="rocket-fuel",               quantity=1},
            {type="technology", name="rocket-silo",               quantity=1},
            {type="item",       name="rocket-part",               quantity=100},
            {type="item",       name="angels-crawler",            quantity=1},
            {type="item",       name="spidertron",                quantity=1},
            {type="item",       name="uranium-fuel-cell",         quantity=1},
            {type="item",       name="solar-panel",               quantity=1},
            {type="item",       name="crystal-full-harmonic",     quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="character",                 quantity=1, next="x5", hidden=true},
        }
    },


    ["Bob's and Angel's Mods"] = {
        required_mods = {"bobplates", "bobelectronics", "bobtech", "angelsindustries"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack",        quantity=1},
            {type="item",       name="logistic-science-pack",          quantity=1},
            {type="item",       name="military-science-pack",          quantity=1},
            {type="item",       name="chemical-science-pack",          quantity=1},
            {type="item",       name="science-pack-gold",              quantity=1},
            {type="item",       name="advanced-logistic-science-pack", quantity=1},
            {type="item",       name="production-science-pack",        quantity=1},
            {type="item",       name="utility-science-pack",           quantity=1},
            {type="item",       name="space-science-pack",             quantity=1},
            {type="item",       name="token-bio",                      quantity=1},
            {type="item",       name="automation-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",          quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",          quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",          quantity=1000, next="x10"},
            {type="item",       name="science-pack-gold",              quantity=1000, next="x10"},
            {type="item",       name="advanced-logistic-science-pack", quantity=1000, next="x10"},
            {type="item",       name="production-science-pack",        quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",           quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",             quantity=10000, next="x10"},

            {type="group",      name="Resources"},
            {type="item",       name="electronic-circuit",             quantity=1},
            {type="item",       name="advanced-circuit",               quantity=1},
            {type="item",       name="processing-unit",                quantity=1},
            {type="item",       name="advanced-processing-unit",       quantity=1},
            {type="item",       name="bronze-alloy",                   quantity=1},
            {type="item",       name="invar-alloy",                    quantity=1},
            {type="item",       name="brass-alloy",                    quantity=1},
            {type="item",       name="silver-plate",                   quantity=1},
            {type="item",       name="gold-plate",                     quantity=1},
            {type="item",       name="aluminium-plate",                quantity=1},
            {type="item",       name="cobalt-steel-alloy",             quantity=1},
            {type="item",       name="plastic-bar",                    quantity=1},
            {type="item",       name="silicon-nitride",                quantity=1},
            {type="item",       name="titanium-plate",                 quantity=1},
            {type="item",       name="tungsten-plate",                 quantity=1},
            {type="item",       name="copper-tungsten-alloy",          quantity=1},
            {type="item",       name="tungsten-carbide",               quantity=1},
            {type="item",       name="nitinol-alloy",                  quantity=1},
            {type="fluid",      name="gas-methane",                    quantity=1},
            {type="item",       name="plastic-bar",                    quantity=1},
            {type="item",       name="sulfur",                         quantity=1},
            {type="fluid",      name="liquid-sulfuric-acid",           quantity=1},
            {type="fluid",      name="liquid-resin",                   quantity=1},
            {type="item",       name="solid-paper",                    quantity=1},

            {type="group",      name="Progress"},
            {type="item",       name="locomotive",                     quantity=1},
            {type="item",       name="angels-construction-robot",      quantity=1},
            {type="item",       name="construction-robot",             quantity=1},
            {type="item",       name="angels-crawler",                 quantity=1},
            {type="item",       name="antron",                         quantity=1},
            {type="item",       name="rocket-fuel",                    quantity=1},
            {type="technology", name="rocket-silo",                    quantity=1},
            {type="item",       name="rocket-part",                    quantity=100},
            {type="item",       name="crystal-full-harmonic",          quantity=1},

            {type="group",      name="Power"},
            {type="item",       name="uranium-fuel-cell",              quantity=1},
            {type="item",       name="angels-thorium-fuel-cell",       quantity=1},
            {type="item",       name="angels-deuterium-fuel-cell",     quantity=1},
            {type="item",       name="solar-panel",                    quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="character",                      quantity=1, next="x5", hidden=true},
        }
    },


    ["Nullius"] = {
        required_mods = {"angelssmelting", "nullius"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="nullius-geology-pack",             quantity=1},
            {type="item",       name="nullius-climatology-pack",         quantity=1},
            {type="item",       name="nullius-mechanical-pack",          quantity=1},
            {type="item",       name="nullius-electrical-pack",          quantity=1},
            {type="item",       name="nullius-chemical-pack",            quantity=1},
            {type="item",       name="nullius-physics-pack",             quantity=1},
            {type="item",       name="nullius-astronomy-pack",           quantity=1},
            {type="item",       name="nullius-biochemistry-pack",        quantity=1},
            {type="item",       name="nullius-microbiology-pack",        quantity=1},
            {type="item",       name="nullius-botany-pack",              quantity=1},
            {type="item",       name="nullius-nematology-pack",          quantity=1},
            {type="item",       name="nullius-dendrology-pack",          quantity=1},
            {type="item",       name="nullius-ichthyology-pack",         quantity=1},
            {type="item",       name="nullius-zoology-pack",             quantity=1},
            {type="item",       name="nullius-geology-pack",             quantity=1000, next="x10"},
            {type="item",       name="nullius-climatology-pack",         quantity=1000, next="x10"},
            {type="item",       name="nullius-mechanical-pack",          quantity=1000, next="x10"},
            {type="item",       name="nullius-electrical-pack",          quantity=1000, next="x10"},
            {type="item",       name="nullius-chemical-pack",            quantity=1000, next="x10"},
            {type="item",       name="nullius-physics-pack",             quantity=1000, next="x10"},
            {type="item",       name="nullius-astronomy-pack",           quantity=1000, next="x10"},
            {type="item",       name="nullius-biochemistry-pack",        quantity=1000, next="x10"},
            {type="item",       name="nullius-microbiology-pack",        quantity=1000, next="x10"},
            {type="item",       name="nullius-botany-pack",              quantity=1000, next="x10"},
            {type="item",       name="nullius-nematology-pack",          quantity=1000, next="x10"},
            {type="item",       name="nullius-dendrology-pack",          quantity=1000, next="x10"},
            {type="item",       name="nullius-ichthyology-pack",         quantity=1000, next="x10"},
            {type="item",       name="nullius-zoology-pack",             quantity=1000, next="x10"},

            -- Science boxes, a box is 5 packs
            {type="alias",      name="nullius-box-geology-pack",     equals="nullius-geology-pack",     quantity=5},
            {type="alias",      name="nullius-box-climatology-pack", equals="nullius-climatology-pack", quantity=5},
            {type="alias",      name="nullius-box-mechanical-pack",  equals="nullius-mechanical-pack",  quantity=5},
            {type="alias",      name="nullius-box-electrical-pack",  equals="nullius-electrical-pack",  quantity=5},
            {type="alias",      name="nullius-box-chemical-pack",    equals="nullius-chemical-pack",    quantity=5},
            {type="alias",      name="nullius-box-physics-pack",     equals="nullius-physics-pack",     quantity=5},
            {type="alias",      name="nullius-box-astronomy-pack",   equals="nullius-astronomy-pack",   quantity=5},

            {type="group",      name="Resources"},
            {type="item",       name="nullius-iron-ingot",               quantity=1},
            {type="item",       name="nullius-plastic",                  quantity=1},
            {type="item",       name="nullius-glass",                    quantity=1},
            {type="item",       name="nullius-aluminum-ingot",           quantity=1},
            {type="item",       name="nullius-silicon-ingot",            quantity=1},
            {type="item",       name="nullius-steel-ingot",              quantity=1},
            {type="item",       name="nullius-fiberglass",               quantity=1},
            {type="item",       name="nullius-titanium-ingot",           quantity=1},
            {type="item",       name="nullius-copper-ingot",             quantity=1},
            {type="item",       name="nullius-processor-1",              quantity=1},
            {type="item",       name="nullius-processor-2",              quantity=1},
            {type="item",       name="nullius-processor-3",              quantity=1},

            -- Item boxes, a box is 5 items
            {type="alias",      name="nullius-box-iron-ingot",     equals="nullius-iron-ingot",     quantity=5},
            {type="alias",      name="nullius-box-plastic",        equals="nullius-plastic",        quantity=5},
            {type="alias",      name="nullius-box-glass",          equals="nullius-glass",          quantity=5},
            {type="alias",      name="nullius-box-aluminum-ingot", equals="nullius-aluminum-ingot", quantity=5},
            {type="alias",      name="nullius-box-silicon-ingot",  equals="nullius-silicon-ingot",  quantity=5},
            {type="alias",      name="nullius-box-steel-ingot",    equals="nullius-steel-ingot",    quantity=5},
            {type="alias",      name="nullius-box-fiberglass",     equals="nullius-fiberglass",     quantity=5},
            {type="alias",      name="nullius-box-titanium-ingot", equals="nullius-titanium-ingot", quantity=5},
            {type="alias",      name="nullius-box-copper-ingot",   equals="nullius-copper-ingot",   quantity=5},
            {type="alias",      name="nullius-box-processor-1",    equals="nullius-processor-1",    quantity=5},
            {type="alias",      name="nullius-box-processor-2",    equals="nullius-processor-2",    quantity=5},
            {type="alias",      name="nullius-box-processor-3",    equals="nullius-processor-3",    quantity=5},

            {type="group",      name="Terraforming"},
            {type="item",       name="nullius-terraforming-drone-brown", quantity=1},
            {type="item",       name="nullius-rocket",                   quantity=1},
            {type="item",       name="nullius-algaculture-drone",        quantity=1},
            {type="item",       name="nullius-horticulture-drone",       quantity=1},
            {type="item",       name="nullius-arboriculture-drone",      quantity=1},
            {type="item",       name="nullius-entomology-drone",         quantity=1},
            {type="item",       name="nullius-aquaculture-drone",        quantity=1},
            {type="item",       name="nullius-husbandry-drone",          quantity=1},
            {type="item",       name="nullius-guide-drone-copper-1",     quantity=1},
            {type="item",       name="nullius-guide-drone-uranium-1",    quantity=1},
            {type="item",       name="nullius-antimatter",               quantity=1},
            {type="item",       name="nullius-probe",                    quantity=1},
            {type="item",       name="nullius-probe",                    quantity=10},

            {type="group",      name="Progress"},
            {type="item",       name="nullius-locomotive-1",             quantity=1},
            {type="item",       name="nullius-logistic-bot-1",           quantity=1},
            {type="item",       name="cliff-explosives",                 quantity=1},
            {type="item",       name="nullius-android-1",                quantity=1},
            {type="item",       name="nullius-android-2",                quantity=1},
            {type="item",       name="nullius-mecha",                    quantity=1},

            {type="group",      name="Power"},
            {type="item",       name="nullius-wind-turbine-1",           quantity=1},
            {type="item",       name="nullius-solar-collector-1",        quantity=1},
            {type="item",       name="nullius-solar-panel-1",            quantity=16},
            {type="item",       name="nullius-geothermal-plant-1",       quantity=1},
            {type="item",       name="nullius-grid-battery-1",           quantity=11},
            {type="item",       name="nullius-fusion-cell",              quantity=1},
            {type="item",       name="nullius-breeder-cell",             quantity=1},
            {type="item",       name="nullius-fission-cell",             quantity=1},
            {type="item",       name="nullius-antimatter",               quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="character",                        quantity=1, hidden=true},
        }
    },


    ["Industrial Revolution 2"] = {
        required_mods = {"IndustrialRevolution"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack", quantity=1},
            {type="item",       name="logistic-science-pack",   quantity=1},
            {type="item",       name="military-science-pack",   quantity=1},
            {type="item",       name="chemical-science-pack",   quantity=1},
            {type="item",       name="production-science-pack", quantity=1},
            {type="item",       name="utility-science-pack",    quantity=1},
            {type="item",       name="space-science-pack",      quantity=1},
            {type="item",       name="automation-science-pack", quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="production-science-pack", quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",    quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",      quantity=10000, next="x10"},

            {type="group",      name="Milestones"},
            {type="technology", name="ir2-bronze-milestone",    quantity=1},
            {type="technology", name="ir2-glass-milestone",     quantity=1},
            {type="technology", name="ir2-iron-milestone",      quantity=1},
            {type="technology", name="ir2-gold-milestone",      quantity=1},
            {type="technology", name="ir2-lead-milestone",      quantity=1},
            {type="technology", name="ir2-nickel-milestone",    quantity=1},
            {type="technology", name="ir2-steel-milestone",     quantity=1},
            {type="technology", name="ir2-chromium-milestone",  quantity=1},
            {type="technology", name="ir2-stainless-milestone", quantity=1},
            {type="technology", name="ir2-tellurium-milestone", quantity=1},

            {type="group",      name="Resources"},
            {type="item",       name="copper-ingot",            quantity=1},
            {type="item",       name="tin-ingot",               quantity=1},
            {type="item",       name="bronze-ingot",            quantity=1},
            {type="item",       name="glass",                   quantity=1},
            {type="item",       name="iron-ingot",              quantity=1},
            {type="item",       name="gold-ingot",              quantity=1},
            {type="item",       name="nickel-ingot",            quantity=1},
            {type="item",       name="lead-ingot",              quantity=1},
            {type="item",       name="steel-ingot",             quantity=1},
            {type="item",       name="invar-ingot",             quantity=1},
            {type="item",       name="cupronickel-ingot",       quantity=1},
            {type="item",       name="chromium-ingot",          quantity=1},
            {type="item",       name="tellurium-ingot",         quantity=1},
            {type="item",       name="stainless-ingot",         quantity=1},
            {type="item",       name="plastiglass",             quantity=1},
            {type="item",       name="electronic-circuit",      quantity=1},
            {type="item",       name="advanced-circuit",        quantity=1},
            {type="item",       name="processing-unit",         quantity=1},

            {type="group",      name="Progress"},
            {type="item",       name="steambot",                quantity=1},
            {type="item",       name="construction-robot",      quantity=1},
            {type="item",       name="locomotive",              quantity=1},
            {type="item",       name="monowheel",               quantity=1},
            {type="item",       name="car",                     quantity=1},
            {type="item",       name="tank",                    quantity=1},
            {type="item",       name="spidertron",              quantity=1},
            {type="technology", name="rocket-silo",             quantity=1},
            {type="item",       name="rocket-part",             quantity=100},

            {type="group",      name="Power"},
            {type="item",       name="steam-engine",            quantity=1},
            {type="item",       name="solar-panel",             quantity=1},
            {type="item",       name="solar-array",             quantity=1},
            {type="item",       name="uranium-fuel-cell",       quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",            quantity=1},
            {type="kill",       name="big-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1000, next="x10"},
            {type="kill",       name="character",               quantity=1, next="x5", hidden=true},
        }
    },

    ["Industrial Revolution 3"] = {
        required_mods = {"IndustrialRevolution3"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack", quantity=1},
            {type="item",       name="logistic-science-pack",   quantity=1},
            {type="item",       name="military-science-pack",   quantity=1},
            {type="item",       name="chemical-science-pack",   quantity=1},
            {type="item",       name="production-science-pack", quantity=1},
            {type="item",       name="utility-science-pack",    quantity=1},
            {type="item",       name="space-science-pack",      quantity=1},
            {type="item",       name="automation-science-pack", quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="production-science-pack", quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",    quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",      quantity=10000, next="x10"},

            {type="group",      name="Resources"},
            {type="item",       name="copper-ingot",            quantity=1},
            {type="item",       name="tin-ingot",               quantity=1},
            {type="item",       name="glass",                   quantity=1},
            {type="item",       name="bronze-ingot",            quantity=1},
            {type="item",       name="iron-ingot",              quantity=1},
            {type="item",       name="concrete",                quantity=1},
            {type="item",       name="plastic-bar",             quantity=1},
            {type="item",       name="gold-ingot",              quantity=1},
            {type="item",       name="steel-ingot",             quantity=1},
            {type="item",       name="nickel-ingot",            quantity=1},
            {type="item",       name="lead-ingot",              quantity=1},
            {type="item",       name="chromium-ingot",          quantity=1},
            {type="item",       name="platinum-ingot",          quantity=1},
            {type="item",       name="brass-ingot",             quantity=1},
            {type="item",       name="carbon-foil",             quantity=1},
            {type="item",       name="electrum-gem",            quantity=1},
            {type="item",       name="electronic-circuit",      quantity=1},
            {type="item",       name="computer-mk1",            quantity=1},
            {type="item",       name="advanced-circuit",        quantity=1},
            {type="item",       name="computer-mk2",            quantity=1},
            {type="item",       name="processing-unit",         quantity=1},
            {type="item",       name="computer-mk3",            quantity=1},

            {type="group",      name="Progress"},
            {type="item",       name="steambot",                quantity=1},
            {type="item",       name="construction-robot",      quantity=1},
            {type="item",       name="monowheel",               quantity=1},
            {type="item",       name="heavy-roller",            quantity=1},
            {type="item",       name="heavy-picket",            quantity=1},
            {type="item",       name="car",                     quantity=1},
            {type="item",       name="tank",                    quantity=1},
            {type="item",       name="locomotive",              quantity=1},
            {type="item",       name="spidertron",              quantity=1},
            {type="item",       name="chrome-transmat",         quantity=1},
            {type="technology", name="rocket-silo",             quantity=1},
            {type="item",       name="rocket-part",             quantity=100},

            {type="group",      name="Power"},
            {type="item",       name="steam-engine",            quantity=1},
            {type="item",       name="petro-generator",         quantity=1},
            {type="item",       name="solar-panel",             quantity=1},
            {type="item",       name="solar-array",             quantity=1},
            {type="item",       name="uranium-fuel-cell",       quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",            quantity=1},
            {type="kill",       name="big-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1000, next="x10"},
            {type="kill",       name="character",               quantity=1, next="x5", hidden=true},
        }
    },

    ["Industrial Revolution 3 + Special Projects"] = {
        required_mods = {"IndustrialRevolution3", "IndustrialRevolution3Projects"},
        milestones = {
            {type="group",      name="Science"},
            {type="item",       name="automation-science-pack", quantity=1},
            {type="item",       name="logistic-science-pack",   quantity=1},
            {type="item",       name="military-science-pack",   quantity=1},
            {type="item",       name="chemical-science-pack",   quantity=1},
            {type="item",       name="production-science-pack", quantity=1},
            {type="item",       name="utility-science-pack",    quantity=1},
            {type="item",       name="space-science-pack",      quantity=1},
            {type="item",       name="automation-science-pack", quantity=1000, next="x10"},
            {type="item",       name="logistic-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="military-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="chemical-science-pack",   quantity=1000, next="x10"},
            {type="item",       name="production-science-pack", quantity=1000, next="x10"},
            {type="item",       name="utility-science-pack",    quantity=1000, next="x10"},
            {type="item",       name="space-science-pack",      quantity=10000, next="x10"},

            {type="group",      name="Special Projects"},
            {type="item",       name="carbon-special-analysis",   quantity=1},
            {type="technology", name="ir-gasification",           quantity=1},
            {type="item",       name="gold-special-analysis",     quantity=1},
            {type="technology", name="ir-electronics-2",          quantity=1},
            {type="item",       name="lead-special-analysis",     quantity=1},
            {type="technology", name="ir-advanced-batteries",     quantity=1},
            {type="item",       name="nickel-special-analysis",   quantity=1},
            {type="technology", name="ir-electroplating",         quantity=1},
            {type="item",       name="diamond-special-analysis",  quantity=1},
            {type="technology", name="ir-pressing",               quantity=1},
            {type="item",       name="ruby-special-analysis",     quantity=1},
            {type="technology", name="laser-2",                   quantity=1},
            {type="item",       name="electrum-special-analysis", quantity=1},
            {type="technology", name="ir-electronics-3",          quantity=1},
            {type="item",       name="helium-special-analysis",   quantity=1},
            {type="technology", name="ir-force-fields",           quantity=1},
            {type="item",       name="hydrogen-special-analysis", quantity=1},
            {type="technology", name="rocket-silo",               quantity=1},
            {type="item",       name="uranium-special-analysis",  quantity=1},
            {type="technology", name="nuclear-power",             quantity=1},

            {type="group",      name="Resources"},
            {type="item",       name="copper-ingot",            quantity=1},
            {type="item",       name="tin-ingot",               quantity=1},
            {type="item",       name="glass",                   quantity=1},
            {type="item",       name="bronze-ingot",            quantity=1},
            {type="item",       name="iron-ingot",              quantity=1},
            {type="item",       name="concrete",                quantity=1},
            {type="item",       name="plastic-bar",             quantity=1},
            {type="item",       name="gold-ingot",              quantity=1},
            {type="item",       name="steel-ingot",             quantity=1},
            {type="item",       name="nickel-ingot",            quantity=1},
            {type="item",       name="lead-ingot",              quantity=1},
            {type="item",       name="chromium-ingot",          quantity=1},
            {type="item",       name="platinum-ingot",          quantity=1},
            {type="item",       name="brass-ingot",             quantity=1},
            {type="item",       name="carbon-foil",             quantity=1},
            {type="item",       name="electrum-gem",            quantity=1},
            {type="item",       name="electronic-circuit",      quantity=1},
            {type="item",       name="computer-mk1",            quantity=1},
            {type="item",       name="advanced-circuit",        quantity=1},
            {type="item",       name="computer-mk2",            quantity=1},
            {type="item",       name="processing-unit",         quantity=1},
            {type="item",       name="computer-mk3",            quantity=1},

            {type="group",      name="Progress"},
            {type="item",       name="steambot",                quantity=1},
            {type="item",       name="construction-robot",      quantity=1},
            {type="item",       name="monowheel",               quantity=1},
            {type="item",       name="heavy-roller",            quantity=1},
            {type="item",       name="heavy-picket",            quantity=1},
            {type="item",       name="car",                     quantity=1},
            {type="item",       name="tank",                    quantity=1},
            {type="item",       name="locomotive",              quantity=1},
            {type="item",       name="spidertron",              quantity=1},
            {type="item",       name="chrome-transmat",         quantity=1},
            {type="item",       name="rocket-part",             quantity=100},

            {type="group",      name="Power"},
            {type="item",       name="steam-engine",            quantity=1},
            {type="item",       name="petro-generator",         quantity=1},
            {type="item",       name="solar-panel",             quantity=1},
            {type="item",       name="solar-array",             quantity=1},
            {type="item",       name="nuclear-reactor",         quantity=1},

            {type="group",      name="Kills"},
            {type="kill",       name="medium-biter",            quantity=1},
            {type="kill",       name="big-biter",               quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1},
            {type="kill",       name="behemoth-biter",          quantity=1000, next="x10"},
            {type="kill",       name="character",               quantity=1, next="x5", hidden=true},
        }
    },
}
