/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.datagen.xplat;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import at.petrak.hexcasting.common.blocks.circles.directrix.BlockRedstoneDirectrix;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.paucal.api.forge.datagen.PaucalBlockStateAndModelProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class HexBlockStatesAndModels
extends PaucalBlockStateAndModelProvider {
    public HexBlockStatesAndModels(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "hexcasting", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModelFile.ExistingModelFile slateModel = this.models().getExistingFile(this.modLoc("slate"));
        this.getVariantBuilder(HexBlocks.SLATE).forAllStatesExcept(bs -> {
            int rotationX = 0;
            int rotationY = 0;
            switch ((AttachFace)bs.m_61143_(BlockSlate.ATTACH_FACE)) {
                case CEILING: {
                    rotationX = 180;
                    break;
                }
                case WALL: {
                    rotationX = 90;
                    rotationY = ((Direction)bs.m_61143_((Property)BlockSlate.FACING)).m_122424_().m_122416_() * 90;
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)slateModel).rotationX(rotationX).rotationY(rotationY).uvLock(true).build();
        }, new Property[]{BlockSlate.WATERLOGGED});
        this.impetus(HexBlocks.IMPETUS_RIGHTCLICK, "impetus_rightclick", "rightclick");
        this.impetus(HexBlocks.IMPETUS_LOOK, "impetus_look", "look");
        this.impetus(HexBlocks.IMPETUS_STOREDPLAYER, "impetus_storedplayer", "storedplayer");
        this.arrowCircleBlock(HexBlocks.EMPTY_IMPETUS, "empty_impetus", this.modLoc("block/slate"), "impetus/front_empty", "impetus/back_empty", "impetus/up_empty", "impetus/down_empty", "impetus/left_empty", "impetus/right_empty");
        this.getVariantBuilder(HexBlocks.DIRECTRIX_REDSTONE).forAllStates(bs -> {
            Boolean isLit = (Boolean)bs.m_61143_((Property)BlockCircleComponent.ENERGIZED);
            String litness = isLit != false ? "lit" : "dim";
            Boolean isPowered = (Boolean)bs.m_61143_((Property)BlockRedstoneDirectrix.REDSTONE_POWERED);
            String poweredness = isPowered != false ? "powered" : "unpowered";
            Direction dir = (Direction)bs.m_61143_((Property)BlockStateProperties.f_61372_);
            ResourceLocation up = this.modLoc("block/directrix/redstone/up_" + poweredness + "_" + litness);
            ResourceLocation left = this.modLoc("block/directrix/redstone/left_" + poweredness + "_" + litness);
            ResourceLocation right = this.modLoc("block/directrix/redstone/right_" + poweredness + "_" + litness);
            ResourceLocation down = this.modLoc("block/directrix/redstone/down_" + poweredness + "_" + litness);
            ResourceLocation front = this.modLoc("block/directrix/redstone/front_" + litness);
            ResourceLocation back = this.modLoc("block/directrix/redstone/back_" + poweredness);
            ResourceLocation[] routing = HexBlockStatesAndModels.routeReslocsForArrowBlock(dir, front, back, up, down, left, right);
            String modelName = "redstone_directrix_" + poweredness + "_" + litness + "_" + dir.m_122433_();
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, routing[0], routing[1], routing[2], routing[3], routing[4], routing[5])).texture("particle", this.modLoc("block/slate"));
            if (!isLit.booleanValue() && !isPowered.booleanValue() && dir == Direction.NORTH) {
                this.simpleBlockItem(HexBlocks.DIRECTRIX_REDSTONE, (ModelFile)model);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
        this.getVariantBuilder(HexBlocks.EMPTY_DIRECTRIX).forAllStates(bs -> {
            Boolean isLit = (Boolean)bs.m_61143_((Property)BlockCircleComponent.ENERGIZED);
            String litness = isLit != false ? "lit" : "dim";
            Direction.Axis axis = (Direction.Axis)bs.m_61143_((Property)BlockStateProperties.f_61365_);
            ResourceLocation horiz = this.modLoc("block/directrix/empty/horiz_" + litness);
            ResourceLocation vert = this.modLoc("block/directrix/empty/vert_" + litness);
            ResourceLocation end = this.modLoc("block/directrix/empty/end_" + litness);
            ResourceLocation x = null;
            ResourceLocation y = null;
            ResourceLocation z = null;
            switch (axis) {
                case X: {
                    x = end;
                    y = horiz;
                    z = horiz;
                    break;
                }
                case Y: {
                    x = vert;
                    y = end;
                    z = vert;
                    break;
                }
                case Z: {
                    x = horiz;
                    y = vert;
                    z = end;
                }
            }
            String modelName = "empty_directrix_" + litness + "_" + axis.m_122477_();
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, y, y, z, z, x, x)).texture("particle", this.modLoc("block/slate"));
            if (!isLit.booleanValue() && axis == Direction.Axis.Z) {
                this.simpleBlockItem(HexBlocks.EMPTY_DIRECTRIX, (ModelFile)model);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
        BlockModelBuilder akashicRecordModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("akashic_record", "block/block")).renderType("translucent")).texture("inner", this.modLoc("block/akashic_ligature"))).texture("outer", this.modLoc("block/akashic_record"))).texture("particle", this.modLoc("block/akashic_ligature"))).element().cube("#outer").end()).element().from(15.75f, 15.75f, 15.75f).to(0.25f, 0.25f, 0.25f).allFaces((dir, builder) -> builder.texture("#inner").rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN)).end();
        this.simpleBlock(HexBlocks.AKASHIC_RECORD, (ModelFile)akashicRecordModel);
        this.simpleBlockItem(HexBlocks.AKASHIC_RECORD, (ModelFile)akashicRecordModel);
        this.blockAndItem(HexBlocks.AKASHIC_LIGATURE, (BlockModelBuilder)this.models().cubeAll("akashic_ligature", this.modLoc("block/akashic_ligature")));
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("akashic_bookshelf")).renderType("cutout")).texture("front", this.modLoc("block/akashic_bookshelf"))).texture("side", this.modLoc("block/akashic_bookshelf_horiz"))).texture("top_bottom", this.modLoc("block/akashic_bookshelf_vert"))).texture("particle", this.modLoc("block/akashic_bookshelf_vert"))).element().allFaces((dir, builder) -> builder.texture(switch (dir) {
            case Direction.UP, Direction.DOWN -> "#top_bottom";
            case Direction.SOUTH, Direction.WEST, Direction.EAST -> "#side";
            default -> "#front";
        }).cullface(dir)).end()).element().face(Direction.NORTH).texture("#overlay").cullface(Direction.NORTH).tintindex(0);
        this.getVariantBuilder(HexBlocks.AKASHIC_BOOKSHELF).forAllStates(bs -> {
            Direction dir = (Direction)bs.m_61143_((Property)BlockAkashicBookshelf.FACING);
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            if (((Boolean)bs.m_61143_((Property)BlockAkashicBookshelf.HAS_BOOKS)).booleanValue()) {
                for (int i = 1; i <= 4; ++i) {
                    BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("akashic_bookshelf_" + i, this.modLoc("block/akashic_bookshelf"))).texture("overlay", this.modLoc("block/akashic_bookshelf_overlay_" + i));
                    builder.modelFile((ModelFile)model).rotationY(dir.m_122424_().m_122416_() * 90).uvLock(true);
                    if (i >= 4) continue;
                    builder = builder.nextModel();
                }
            } else {
                BlockModelBuilder model = (BlockModelBuilder)this.models().orientable("akashic_bookshelf_empty", this.modLoc("block/akashic_bookshelf_horiz"), this.modLoc("block/akashic_bookshelf"), this.modLoc("block/akashic_bookshelf_vert"));
                if (dir == Direction.NORTH) {
                    this.simpleBlockItem(HexBlocks.AKASHIC_BOOKSHELF, (ModelFile)model);
                }
                builder.modelFile((ModelFile)model).rotationY(dir.m_122424_().m_122416_() * 90).uvLock(true);
            }
            return builder.build();
        });
        this.blockAndItem(HexBlocks.SLATE_BLOCK, (BlockModelBuilder)this.models().cubeAll("slate_block", this.modLoc("block/slate")));
        this.blockAndItem((Block)HexBlocks.AMETHYST_DUST_BLOCK, (BlockModelBuilder)this.models().singleTexture("amethyst_dust_block", this.modLoc("block/cube_half_mirrored"), "all", this.modLoc("block/amethyst_dust_block")));
        this.cubeBlockAndItem((Block)HexBlocks.AMETHYST_TILES, "amethyst_tiles");
        this.cubeBlockAndItem(HexBlocks.SCROLL_PAPER, "scroll_paper");
        this.cubeBlockAndItem(HexBlocks.ANCIENT_SCROLL_PAPER, "ancient_scroll_paper");
        this.blockAndItem(HexBlocks.SCROLL_PAPER_LANTERN, (BlockModelBuilder)this.models().cubeBottomTop("scroll_paper_lantern", this.modLoc("block/scroll_paper_lantern_side"), this.modLoc("block/scroll_paper_lantern_bottom"), this.modLoc("block/scroll_paper_lantern_top")));
        this.blockAndItem(HexBlocks.ANCIENT_SCROLL_PAPER_LANTERN, (BlockModelBuilder)this.models().cubeBottomTop("ancient_scroll_paper_lantern", this.modLoc("block/ancient_scroll_paper_lantern_side"), this.modLoc("block/ancient_scroll_paper_lantern_bottom"), this.modLoc("block/ancient_scroll_paper_lantern_top")));
        this.axisBlock(HexBlocks.EDIFIED_LOG, this.modLoc("block/edified_log"), this.modLoc("block/edified_log_top"));
        this.axisBlock(HexBlocks.STRIPPED_EDIFIED_LOG, this.modLoc("block/stripped_edified_log"), this.modLoc("block/stripped_edified_log_top"));
        this.axisBlock(HexBlocks.EDIFIED_WOOD, this.modLoc("block/edified_log"), this.modLoc("block/edified_log"));
        this.axisBlock(HexBlocks.STRIPPED_EDIFIED_WOOD, this.modLoc("block/stripped_edified_log"), this.modLoc("block/stripped_edified_log"));
        this.blockAndItem(HexBlocks.EDIFIED_PANEL, (BlockModelBuilder)this.models().cubeAll("edified_panel", this.modLoc("block/edified_panel")));
        this.blockAndItem(HexBlocks.EDIFIED_TILE, (BlockModelBuilder)this.models().cubeAll("edified_tile", this.modLoc("block/edified_tile")));
        ResourceLocation leavesParent = new ResourceLocation("block/leaves");
        this.blockAndItem((Block)HexBlocks.AMETHYST_EDIFIED_LEAVES, (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("amethyst_edified_leaves", leavesParent)).texture("all", this.modLoc("block/amethyst_edified_leaves"))).renderType("cutout_mipped"));
        this.blockAndItem((Block)HexBlocks.AVENTURINE_EDIFIED_LEAVES, (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("aventurine_edified_leaves", leavesParent)).texture("all", this.modLoc("block/aventurine_edified_leaves"))).renderType("cutout_mipped"));
        this.blockAndItem((Block)HexBlocks.CITRINE_EDIFIED_LEAVES, (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("citrine_edified_leaves", leavesParent)).texture("all", this.modLoc("block/citrine_edified_leaves"))).renderType("cutout_mipped"));
        this.doorBlockWithRenderType(HexBlocks.EDIFIED_DOOR, this.modLoc("block/edified_door_lower"), this.modLoc("block/edified_door_upper"), "cutout");
        this.trapdoorBlockWithRenderType(HexBlocks.EDIFIED_TRAPDOOR, this.modLoc("block/edified_trapdoor"), true, "cutout");
        ResourceLocation planks1 = this.modLoc("block/edified_planks");
        BlockModelBuilder planksModel = (BlockModelBuilder)this.models().cubeAll("edified_planks", planks1);
        this.simpleBlock(HexBlocks.EDIFIED_PLANKS, ConfiguredModel.builder().modelFile((ModelFile)planksModel).weight(3).nextModel().modelFile((ModelFile)this.models().cubeAll("edified_planks_2", this.modLoc("block/edified_planks_2"))).weight(3).nextModel().modelFile((ModelFile)this.models().cubeAll("edified_planks_3", this.modLoc("block/edified_planks_3"))).build());
        this.simpleBlockItem(HexBlocks.EDIFIED_PLANKS, (ModelFile)planksModel);
        this.stairsBlock(HexBlocks.EDIFIED_STAIRS, planks1);
        this.slabBlock(HexBlocks.EDIFIED_SLAB, planks1, planks1);
        this.buttonBlock((ButtonBlock)HexBlocks.EDIFIED_BUTTON, planks1);
        this.pressurePlateBlock(HexBlocks.EDIFIED_PRESSURE_PLATE, planks1);
        ModelFile.ExistingModelFile sconceModel = this.models().getExistingFile(this.modLoc("amethyst_sconce"));
        this.simpleBlock((Block)HexBlocks.SCONCE, (ModelFile)sconceModel);
        this.simpleBlockItem((Block)HexBlocks.SCONCE, (ModelFile)sconceModel);
        BlockModelBuilder conjuredModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("conjured")).texture("particle", this.mcLoc("block/amethyst_block"))).renderType("cutout");
        this.simpleBlock(HexBlocks.CONJURED_BLOCK, (ModelFile)conjuredModel);
        this.simpleBlock(HexBlocks.CONJURED_LIGHT, (ModelFile)conjuredModel);
    }

    private void impetus(Block block, String name, String stub) {
        this.arrowCircleBlock(block, name, this.modLoc("block/slate"), "impetus/" + stub, "impetus/back", "impetus/up", "impetus/down", "impetus/left", "impetus/right");
    }

    private void arrowCircleBlock(Block block, String name, ResourceLocation particle, String frontStub, String backStub, String upStub, String downStub, String leftStub, String rightStub) {
        this.getVariantBuilder(block).forAllStates(bs -> {
            Boolean isLit = (Boolean)bs.m_61143_((Property)BlockCircleComponent.ENERGIZED);
            String litness = isLit != false ? "lit" : "dim";
            Direction dir = (Direction)bs.m_61143_((Property)BlockStateProperties.f_61372_);
            ResourceLocation up = this.modLoc("block/" + upStub + "_" + litness);
            ResourceLocation front = this.modLoc("block/" + frontStub + "_" + litness);
            ResourceLocation back = this.modLoc("block/" + backStub + "_" + litness);
            ResourceLocation left = this.modLoc("block/" + leftStub + "_" + litness);
            ResourceLocation right = this.modLoc("block/" + rightStub + "_" + litness);
            ResourceLocation down = this.modLoc("block/" + downStub + "_" + litness);
            ResourceLocation[] routing = HexBlockStatesAndModels.routeReslocsForArrowBlock(dir, front, back, up, down, left, right);
            String modelName = name + "_" + litness + "_" + dir.m_122433_();
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, routing[0], routing[1], routing[2], routing[3], routing[4], routing[5])).texture("particle", particle);
            if (!isLit.booleanValue() && dir == Direction.EAST) {
                this.simpleBlockItem(block, (ModelFile)model);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
    }

    private static ResourceLocation[] routeReslocsForArrowBlock(Direction dir, ResourceLocation front, ResourceLocation back, ResourceLocation up, ResourceLocation down, ResourceLocation left, ResourceLocation right) {
        ResourceLocation bottom = null;
        ResourceLocation top = null;
        ResourceLocation north = null;
        ResourceLocation south = null;
        ResourceLocation east = null;
        ResourceLocation west = null;
        switch (dir) {
            case UP: {
                top = front;
                bottom = back;
                south = west = up;
                east = west;
                north = west;
                break;
            }
            case DOWN: {
                bottom = front;
                top = back;
                south = west = down;
                east = west;
                north = west;
                break;
            }
            case NORTH: {
                north = front;
                south = back;
                west = left;
                east = right;
                top = up;
                bottom = down;
                break;
            }
            case SOUTH: {
                south = front;
                north = back;
                west = right;
                east = left;
                top = down;
                bottom = up;
                break;
            }
            case WEST: {
                west = front;
                east = back;
                north = right;
                south = left;
                top = left;
                bottom = left;
                break;
            }
            case EAST: {
                east = front;
                west = back;
                north = left;
                south = right;
                top = right;
                bottom = right;
            }
        }
        return new ResourceLocation[]{bottom, top, north, south, east, west};
    }
}

