/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.circles.BlockEntitySlate;
import at.petrak.hexcasting.common.blocks.entity.BlockEntityConjured;
import at.petrak.hexcasting.common.blocks.entity.BlockEntityLookingImpetus;
import at.petrak.hexcasting.common.blocks.entity.BlockEntityRightClickImpetus;
import at.petrak.hexcasting.common.blocks.entity.BlockEntityStoredPlayerImpetus;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class HexBlockEntities {
    private static final Map<ResourceLocation, BlockEntityType<?>> BLOCK_ENTITIES = new LinkedHashMap();
    public static final BlockEntityType<BlockEntityConjured> CONJURED_TILE = HexBlockEntities.register("conjured_tile", BlockEntityConjured::new, HexBlocks.CONJURED_LIGHT, HexBlocks.CONJURED_BLOCK);
    public static final BlockEntityType<BlockEntityAkashicBookshelf> AKASHIC_BOOKSHELF_TILE = HexBlockEntities.register("akashic_bookshelf_tile", BlockEntityAkashicBookshelf::new, HexBlocks.AKASHIC_BOOKSHELF);
    public static final BlockEntityType<BlockEntityStoredPlayerImpetus> IMPETUS_STOREDPLAYER_TILE = HexBlockEntities.register("impetus_storedplayer_tile", BlockEntityStoredPlayerImpetus::new, HexBlocks.IMPETUS_STOREDPLAYER);
    public static final BlockEntityType<BlockEntityLookingImpetus> IMPETUS_LOOK_TILE = HexBlockEntities.register("impetus_look_tile", BlockEntityLookingImpetus::new, HexBlocks.IMPETUS_LOOK);
    public static final BlockEntityType<BlockEntityRightClickImpetus> IMPETUS_RIGHTCLICK_TILE = HexBlockEntities.register("impetus_rightclick_tile", BlockEntityRightClickImpetus::new, HexBlocks.IMPETUS_RIGHTCLICK);
    public static final BlockEntityType<BlockEntitySlate> SLATE_TILE = HexBlockEntities.register("slate_tile", BlockEntitySlate::new, HexBlocks.SLATE);

    public static void registerTiles(BiConsumer<BlockEntityType<?>, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, BlockEntityType<?>> e : BLOCK_ENTITIES.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static <T extends BlockEntity> BlockEntityType<T> register(String id, BiFunction<BlockPos, BlockState, T> func, Block ... blocks) {
        BlockEntityType<T> ret = IXplatAbstractions.INSTANCE.createBlockEntityType(func, blocks);
        BlockEntityType<T> old = BLOCK_ENTITIES.put(new ResourceLocation("hexcasting", id), ret);
        if (old != null) {
            throw new IllegalArgumentException("Duplicate id " + id);
        }
        return ret;
    }
}

