/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.operators.spells;

import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.OperatorUtils;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.RenderedSpell;
import at.petrak.hexcasting.api.spell.SpellAction;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.eval.SpellContinuation;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/OpBreakBlock;", "Lat/petrak/hexcasting/api/spell/SpellAction;", "()V", "argc", "", "getArgc", "()I", "execute", "Lkotlin/Triple;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "", "Lat/petrak/hexcasting/api/spell/ParticleSpray;", "args", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "Spell", "hexcasting-forge-1.19.2"})
public final class OpBreakBlock
implements SpellAction {
    @NotNull
    public static final OpBreakBlock INSTANCE = new OpBreakBlock();

    private OpBreakBlock() {
    }

    @Override
    public int getArgc() {
        return 1;
    }

    @Override
    @NotNull
    public Triple<RenderedSpell, Integer, List<ParticleSpray>> execute(@NotNull List<? extends Iota> args, @NotNull CastingContext ctx) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        BlockPos pos = OperatorUtils.getBlockPos(args, 0, this.getArgc());
        ctx.assertVecInRange(pos);
        Spell spell = new Spell(pos);
        Integer n = 11250;
        Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)pos));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(pos)");
        return new Triple((Object)spell, (Object)n, (Object)CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null)));
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingContext ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingContext ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull SpellContinuation continuation, @NotNull List<Iota> stack, @Nullable Iota ravenmind, @NotNull CastingContext ctx) {
        return SpellAction.DefaultImpls.operate(this, continuation, stack, ravenmind, ctx);
    }

    @Override
    public boolean isGreat() {
        return SpellAction.DefaultImpls.isGreat(this);
    }

    @Override
    public boolean getAlwaysProcessGreatSpell() {
        return SpellAction.DefaultImpls.getAlwaysProcessGreatSpell(this);
    }

    @Override
    public boolean getCausesBlindDiversion() {
        return SpellAction.DefaultImpls.getCausesBlindDiversion(this);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return SpellAction.DefaultImpls.getDisplayName(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/OpBreakBlock$Spell;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "pos", "Lnet/minecraft/core/BlockPos;", "(Lnet/minecraft/core/BlockPos;)V", "getPos", "()Lnet/minecraft/core/BlockPos;", "cast", "", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.19.2"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final BlockPos pos;

        public Spell(@NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.pos = pos;
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        @Override
        public void cast(@NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (!ctx.canEditBlockAt(this.pos)) {
                return;
            }
            BlockState blockstate = ctx.getWorld().m_8055_(this.pos);
            if (!IXplatAbstractions.INSTANCE.isBreakingAllowed((Level)ctx.getWorld(), this.pos, blockstate, (Player)ctx.getCaster())) {
                return;
            }
            Tier tier = HexConfig.server().opBreakHarvestLevel();
            if (!blockstate.m_60795_() && blockstate.m_60800_((BlockGetter)ctx.getWorld(), this.pos) >= 0.0f && IXplatAbstractions.INSTANCE.isCorrectTierForDrops(tier, blockstate)) {
                ctx.getWorld().m_46953_(this.pos, true, (Entity)ctx.getCaster());
            }
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        @NotNull
        public final Spell copy(@NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new Spell(pos);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, BlockPos blockPos, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = spell.pos;
            }
            return spell.copy(blockPos);
        }

        @NotNull
        public String toString() {
            return "Spell(pos=" + this.pos + ")";
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            return Intrinsics.areEqual((Object)this.pos, (Object)spell.pos);
        }
    }
}

