/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.event;

import cofh.core.capability.CapabilityShieldItem;
import cofh.core.event.ShieldEvents;
import cofh.core.util.helpers.AreaEffectHelper;
import cofh.redstonearsenal.init.RSABlocks;
import cofh.redstonearsenal.item.FluxArmorItem;
import cofh.redstonearsenal.item.FluxShieldItem;
import cofh.redstonearsenal.item.FluxShovelItem;
import cofh.redstonearsenal.item.FluxSickleItem;
import cofh.redstonearsenal.item.FluxTridentItem;
import cofh.redstonearsenal.util.FluxShieldingHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="redstone_arsenal")
public class RSAEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleAttackEntityEvent(AttackEntityEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof FluxTridentItem) {
            FluxTridentItem trident = (FluxTridentItem)item;
            if (player.m_21209_() && trident.plungeAttack(player.f_19853_, (LivingEntity)player, stack)) {
                event.getTarget().f_19802_ = 0;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingFallEvent(LivingFallEvent event) {
        LivingEntity living;
        ItemStack stack;
        Item item;
        if (event.getEntity() instanceof Player && (item = (stack = (living = event.getEntity()).m_21205_()).m_41720_()) instanceof FluxTridentItem) {
            FluxTridentItem trident = (FluxTridentItem)item;
            if (living.m_21209_()) {
                if (trident.plungeAttack(living.f_19853_, living, stack)) {
                    FluxTridentItem.stopSpinAttack(living);
                    event.setCanceled(true);
                } else {
                    event.setDamageMultiplier(0.4f);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePlayerFlyableFallEvent(PlayerFlyableFallEvent event) {
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof FluxTridentItem) {
            FluxTridentItem trident = (FluxTridentItem)item;
            if (player.m_21209_() && trident.plungeAttack(player.f_19853_, (LivingEntity)player, stack)) {
                FluxTridentItem.stopSpinAttack((LivingEntity)player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        ItemStack from = event.getFrom();
        ItemStack to = event.getTo();
        LivingEntity entity = event.getEntity();
        if (event.getSlot().equals((Object)EquipmentSlot.MAINHAND) && entity.m_21209_() && from.m_41720_() instanceof FluxTridentItem && !(to.m_41720_() instanceof FluxTridentItem)) {
            FluxTridentItem.stopSpinAttack(entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        event.getPosition().ifPresent(pos -> {
            Item patt4527$temp = stack.m_41720_();
            if (patt4527$temp instanceof FluxSickleItem) {
                FluxSickleItem sickle = (FluxSickleItem)patt4527$temp;
                if (event.getNewSpeed() > 0.0f && sickle.isEmpowered(stack) && !AreaEffectHelper.isMature((Level)player.f_19853_, (BlockPos)pos, (BlockState)event.getState())) {
                    event.setNewSpeed(0.0f);
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleBlockToolModificationEvent(BlockEvent.BlockToolModificationEvent event) {
        if (event.isCanceled()) {
            return;
        }
        ItemStack stack = event.getHeldItemStack();
        Item item = stack.m_41720_();
        ToolAction action = event.getToolAction();
        if (action.equals(ToolActions.SHOVEL_FLATTEN) && item instanceof FluxShovelItem) {
            BlockState modified;
            FluxShovelItem shovel = (FluxShovelItem)item;
            BlockState state = event.getState();
            if (state.m_60713_(Blocks.f_152481_) || state.m_60713_((Block)RSABlocks.FLUX_PATH.get()) || state.m_60713_(Blocks.f_50093_)) {
                event.setFinalState(Blocks.f_50493_.m_49966_());
            } else if (shovel.isEmpowered(stack) && (modified = state.m_60734_().getToolModifiedState(state, event.getContext(), action, event.isSimulated())) != null && modified.m_60713_(Blocks.f_152481_)) {
                event.setFinalState(((Block)RSABlocks.FLUX_PATH.get()).m_49966_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        ItemStack shieldedItem;
        Player player;
        ItemStack shield;
        DamageSource source;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (ShieldEvents.canBlockDamageSource((LivingEntity)target, (DamageSource)(source = event.getSource())) || target.m_6673_(source) || target.m_21023_(MobEffects.f_19607_) && source.m_19384_()) {
            return;
        }
        if (target.m_21254_() && source.m_19385_().equals("flux") && (shield = target.m_21211_()).m_41720_() instanceof FluxShieldItem && ShieldEvents.canBlockDamagePosition((LivingEntity)target, (Vec3)source.m_7270_())) {
            shield.getCapability(CapabilityShieldItem.SHIELD_ITEM_CAPABILITY).ifPresent(cap -> cap.onBlock(target, source, event.getAmount()));
            event.setCanceled(true);
            return;
        }
        float amount = event.getAmount();
        if (!(!(amount <= 500.0f) || target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_()) || source.m_19376_() && source.m_19379_() || (shieldedItem = FluxShieldingHelper.findShieldedItem(target)).m_41619_())) {
            if (target.f_19802_ > 0) {
                event.setCanceled(true);
            } else if (FluxShieldingHelper.useFluxShieldCharge(target, shieldedItem)) {
                target.f_19802_ = 10;
                event.setCanceled(true);
                if (target instanceof ServerPlayer) {
                    FluxShieldingHelper.updateHUD((ServerPlayer)target);
                }
            }
            return;
        }
        if (source.m_146705_()) {
            ItemStack helmet = target.m_6844_(EquipmentSlot.HEAD);
            float damage = Math.max(0.5f, amount * 0.25f);
            Item item = helmet.m_41720_();
            if (item instanceof FluxArmorItem) {
                FluxArmorItem armor = (FluxArmorItem)item;
                int use = Math.min((int)(damage * (float)armor.getEnergyPerUse(false)), armor.getEnergyStored(helmet));
                armor.useEnergy(helmet, use, (Entity)target);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        DamageSource source = event.getSource();
        if (source.m_19376_() && source.m_19379_()) {
            return;
        }
        float amount = event.getAmount();
        if (amount <= 0.0f) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (FluxShieldingHelper.useFluxShieldCharge(target)) {
            event.setAmount(Math.max(amount - 500.0f, 0.0f));
            if (target instanceof ServerPlayer) {
                FluxShieldingHelper.updateHUD((ServerPlayer)target);
            }
        } else if (!source.m_19376_()) {
            float damage = Math.max(0.5f, amount * 0.25f);
            target.m_6168_().forEach(stack -> {
                Item patt9276$temp = stack.m_41720_();
                if (patt9276$temp instanceof FluxArmorItem) {
                    FluxArmorItem armor = (FluxArmorItem)patt9276$temp;
                    int use = Math.min((int)(damage * (float)armor.getEnergyPerUse(false)), armor.getEnergyStored((ItemStack)stack));
                    armor.useEnergy((ItemStack)stack, use, (Entity)target);
                }
            });
        }
    }
}

