/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.data;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import shadows.hostilenetworks.data.DataModel;

public enum ModelTier {
    FAULTY(0, 1, "faulty", ChatFormatting.DARK_GRAY, 0.01f),
    BASIC(6, 4, "basic", ChatFormatting.GREEN, 0.05f),
    ADVANCED(54, 10, "advanced", ChatFormatting.BLUE, 0.22f),
    SUPERIOR(354, 18, "superior", ChatFormatting.LIGHT_PURPLE, 0.65f),
    SELF_AWARE(1254, 0, "self_aware", ChatFormatting.GOLD, 0.995f);

    private static final ModelTier[] VALUES;
    private final int data;
    private final int dataPerKill;
    public final String name;
    public final ChatFormatting color;
    public final float accuracy;

    private ModelTier(int data, int dataPerKill, String name, ChatFormatting color, float accuracy) {
        this.data = data;
        this.dataPerKill = dataPerKill;
        this.name = name;
        this.color = color;
        this.accuracy = accuracy;
    }

    public ModelTier previous() {
        if (this == FAULTY) {
            return this;
        }
        return VALUES[this.ordinal() - 1];
    }

    public ModelTier next() {
        if (this == SELF_AWARE) {
            return this;
        }
        return VALUES[this.ordinal() + 1];
    }

    public Component getComponent() {
        return Component.m_237115_((String)("hostilenetworks.tier." + this.name)).m_130940_(this.color);
    }

    public static ModelTier getByData(@Nullable DataModel model, int data) {
        if (model == null) {
            return FAULTY;
        }
        for (int i = 4; i >= 0; --i) {
            if (data < model.getTierData(VALUES[i])) continue;
            return VALUES[i];
        }
        return FAULTY;
    }

    public static int[] defaultData() {
        return Arrays.stream(VALUES).mapToInt(t -> t.data).toArray();
    }

    public static int[] defaultDataPerKill() {
        return Arrays.stream(VALUES).mapToInt(t -> t.dataPerKill).toArray();
    }

    static {
        VALUES = ModelTier.values();
    }
}

