/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.data;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import shadows.hostilenetworks.HostileNetworks;
import shadows.hostilenetworks.data.DataModel;
import shadows.placebo.json.PlaceboJsonReloadListener;

public class DataModelManager
extends PlaceboJsonReloadListener<DataModel> {
    public static final DataModelManager INSTANCE = new DataModelManager();
    private Map<EntityType<?>, DataModel> modelsByType = new HashMap();

    public DataModelManager() {
        super(HostileNetworks.LOGGER, "data_models", true, false);
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, DataModel.SERIALIZER);
    }

    protected <T extends DataModel> void register(ResourceLocation key, T model) {
        super.register(key, model);
        if (this.modelsByType.containsKey(model.type)) {
            String msg = "Attempted to register two models (%s and %s) for Entity Type %s!";
            throw new UnsupportedOperationException(String.format(msg, key, this.modelsByType.get(model.type).getId(), EntityType.m_20613_(model.type)));
        }
        this.modelsByType.put(model.type, model);
    }

    protected void beginReload() {
        super.beginReload();
        this.modelsByType = new HashMap();
    }

    protected void onReload() {
        super.onReload();
        this.modelsByType.clear();
        this.registry.values().forEach(model -> this.modelsByType.put(model.getType(), (DataModel)((Object)model)));
        this.modelsByType = ImmutableMap.copyOf(this.modelsByType);
    }

    protected <T extends DataModel> void validateItem(T item) {
        super.validateItem(item);
        item.validate();
    }

    @Nullable
    public DataModel getForEntity(EntityType<?> type) {
        return this.modelsByType.get(type);
    }
}

