/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.utils.UnifyTag;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class TagOwnerships {
    private final Map<UnifyTag<Item>, UnifyTag<Item>> refsToOwner;
    private final Multimap<UnifyTag<Item>, UnifyTag<Item>> ownerToRefs;

    public TagOwnerships(Set<UnifyTag<Item>> unifyTags, Map<ResourceLocation, Set<ResourceLocation>> tagOwnershipConfig) {
        ImmutableMap.Builder refsToOwnerBuilder = ImmutableMap.builder();
        ImmutableMultimap.Builder ownerToRefsBuilder = ImmutableMultimap.builder();
        tagOwnershipConfig.forEach((rawOwner, rawRefs) -> {
            for (ResourceLocation rawRef : rawRefs) {
                UnifyTag<Item> owner = UnifyTag.item(rawOwner);
                UnifyTag<Item> ref = UnifyTag.item(rawRef);
                if (!unifyTags.contains(owner)) {
                    AlmostUnified.LOG.warn("[TagOwnerships] Owner tag '#{}' is not present in the unify tag list!", (Object)owner.location());
                    continue;
                }
                if (unifyTags.contains(ref)) {
                    AlmostUnified.LOG.warn("[TagOwnerships] Reference tag '#{}' of owner tag '#{}' is present in the unify tag list!", (Object)ref.location(), (Object)owner.location());
                    continue;
                }
                refsToOwnerBuilder.put(ref, owner);
                ownerToRefsBuilder.put(owner, ref);
            }
        });
        this.refsToOwner = refsToOwnerBuilder.build();
        this.ownerToRefs = ownerToRefsBuilder.build();
    }

    public void applyOwnershipToRawTags(Map<ResourceLocation, Collection<Holder<Item>>> rawTags) {
        HashMultimap changedTags = HashMultimap.create();
        this.ownerToRefs.asMap().forEach((arg_0, arg_1) -> TagOwnerships.lambda$applyOwnershipToRawTags$2(rawTags, (Multimap)changedTags, arg_0, arg_1));
        if (!changedTags.isEmpty()) {
            changedTags.asMap().forEach((tag, items) -> AlmostUnified.LOG.info("[TagOwnerships] Modified tag '#{}', added {}", tag, items));
        }
    }

    @Nullable
    public UnifyTag<Item> getOwnerByTag(UnifyTag<Item> tag) {
        return this.refsToOwner.get(tag);
    }

    public Set<UnifyTag<Item>> getRefs() {
        return this.refsToOwner.keySet();
    }

    private static /* synthetic */ void lambda$applyOwnershipToRawTags$2(Map rawTags, Multimap changedTags, UnifyTag owner, Collection refs) {
        Collection rawHolders = (Collection)rawTags.get(owner.location());
        if (rawHolders == null) {
            AlmostUnified.LOG.warn("[TagOwnerships] Owner tag '#{}' does not exist!", (Object)owner.location());
            return;
        }
        ImmutableSet.Builder holders = ImmutableSet.builder();
        holders.addAll((Iterable)rawHolders);
        boolean changed = false;
        for (UnifyTag ref : refs) {
            Collection refHolders = (Collection)rawTags.get(ref.location());
            if (refHolders == null) {
                AlmostUnified.LOG.warn("[TagOwnerships] Reference tag '#{}' of owner tag '#{}' does not exist!", (Object)ref.location(), (Object)owner.location());
                continue;
            }
            for (Holder holder : refHolders) {
                holders.add((Object)holder);
                holder.m_203543_().ifPresent(key -> changedTags.put((Object)ref.location(), (Object)key.m_135782_()));
                changed = true;
            }
        }
        if (changed) {
            rawTags.put(owner.location(), holders.build());
        }
    }
}

