/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.utils.UnifyTag;
import com.almostreliable.unified.utils.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.world.item.Item;

public class TagMap {
    private final Map<UnifyTag<Item>, Set<ResourceLocation>> tagsToItems = new HashMap<UnifyTag<Item>, Set<ResourceLocation>>();
    private final Map<ResourceLocation, Set<UnifyTag<Item>>> itemsToTags = new HashMap<ResourceLocation, Set<UnifyTag<Item>>>();

    protected TagMap() {
    }

    public static TagMap create(Set<UnifyTag<Item>> unifyTags) {
        TagMap tagMap = new TagMap();
        unifyTags.forEach(ut -> {
            TagKey asTagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)ut.location());
            Registry.f_122827_.m_206058_(asTagKey).forEach(holder -> {
                ResourceLocation key = Registry.f_122827_.m_7981_((Object)((Item)holder.m_203334_()));
                tagMap.put((UnifyTag<Item>)ut, key);
            });
        });
        return tagMap;
    }

    public static TagMap create(TagManager tagManager) {
        Map<ResourceLocation, Collection<Holder<Item>>> tags = TagMap.unpackTagManager(tagManager);
        TagMap tagMap = new TagMap();
        for (Map.Entry<ResourceLocation, Collection<Holder<Item>>> entry : tags.entrySet()) {
            UnifyTag<Item> unifyTag = UnifyTag.item(entry.getKey());
            for (Holder<Item> holder : entry.getValue()) {
                holder.m_203543_().map(ResourceKey::m_135782_).filter(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_7804_(arg_0)).ifPresent(itemId -> tagMap.put(unifyTag, (ResourceLocation)itemId));
            }
        }
        return tagMap;
    }

    public TagMap filtered(Predicate<UnifyTag<Item>> tagFilter, Predicate<ResourceLocation> itemFilter) {
        TagMap tagMap = new TagMap();
        this.tagsToItems.forEach((tag, items) -> {
            if (!tagFilter.test((UnifyTag<Item>)tag)) {
                return;
            }
            items.stream().filter(itemFilter).forEach(item -> tagMap.put((UnifyTag<Item>)tag, (ResourceLocation)item));
        });
        return tagMap;
    }

    public int tagSize() {
        return this.tagsToItems.size();
    }

    public int itemSize() {
        return this.itemsToTags.size();
    }

    public Set<ResourceLocation> getItemsByTag(UnifyTag<Item> tag) {
        return Collections.unmodifiableSet(this.tagsToItems.getOrDefault(tag, Collections.emptySet()));
    }

    public Set<UnifyTag<Item>> getTagsByItem(ResourceLocation items) {
        return Collections.unmodifiableSet(this.itemsToTags.getOrDefault(items, Collections.emptySet()));
    }

    public Set<UnifyTag<Item>> getTags() {
        return Collections.unmodifiableSet(this.tagsToItems.keySet());
    }

    protected void put(UnifyTag<Item> tag, ResourceLocation item) {
        this.tagsToItems.computeIfAbsent(tag, k -> new HashSet()).add(item);
        this.itemsToTags.computeIfAbsent(item, k -> new HashSet()).add(tag);
    }

    private static Map<ResourceLocation, Collection<Holder<Item>>> unpackTagManager(TagManager tagManager) {
        Map tags = tagManager.m_203904_().stream().filter(result -> result.f_203928_() == Registry.f_122904_).findFirst().map(TagManager.LoadResult::f_203929_).orElseThrow(() -> new IllegalStateException("No item tag result found"));
        return (Map)Utils.cast(tags);
    }
}

