/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.utils.JsonUtils;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagOwnerships;
import com.almostreliable.unified.utils.UnifyTag;
import com.almostreliable.unified.utils.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class RecipeContextImpl
implements RecipeContext {
    private final ReplacementMap replacementMap;
    private final JsonObject originalRecipe;

    public RecipeContextImpl(JsonObject json, ReplacementMap replacementMap) {
        this.originalRecipe = json;
        this.replacementMap = replacementMap;
    }

    @Override
    @Nullable
    public ResourceLocation getReplacementForItem(@Nullable ResourceLocation item) {
        if (item == null) {
            return null;
        }
        return this.replacementMap.getReplacementForItem(item);
    }

    @Override
    @Nullable
    public ResourceLocation getPreferredItemForTag(@Nullable UnifyTag<Item> tag, Predicate<ResourceLocation> filter) {
        if (tag == null) {
            return null;
        }
        return this.replacementMap.getPreferredItemForTag(tag, filter);
    }

    @Override
    @Nullable
    public UnifyTag<Item> getPreferredTagForItem(@Nullable ResourceLocation item) {
        if (item == null) {
            return null;
        }
        return this.replacementMap.getPreferredTagForItem(item);
    }

    @Override
    @Nullable
    public JsonElement createIngredientReplacement(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        JsonElement copy = element.deepCopy();
        this.tryCreateIngredientReplacement(copy);
        return element.equals(copy) ? null : copy;
    }

    private void tryCreateIngredientReplacement(@Nullable JsonElement element) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            for (JsonElement e : array) {
                this.tryCreateIngredientReplacement(e);
            }
        }
        if (element instanceof JsonObject) {
            ResourceLocation item;
            UnifyTag<Item> tag;
            Object tag2;
            JsonPrimitive primitive;
            JsonElement e;
            JsonObject object = (JsonObject)element;
            this.tryCreateIngredientReplacement(object.get("value"));
            this.tryCreateIngredientReplacement(object.get("ingredient"));
            e = object.get("tag");
            if (e instanceof JsonPrimitive) {
                primitive = (JsonPrimitive)e;
                tag2 = Utils.toItemTag(primitive.getAsString());
                AlmostUnified.getRuntime().getTagOwnerships().map(arg_0 -> RecipeContextImpl.lambda$tryCreateIngredientReplacement$0((UnifyTag)tag2, arg_0)).ifPresent(ownerTag -> object.addProperty("tag", ownerTag.location().toString()));
            }
            if ((tag2 = object.get("item")) instanceof JsonPrimitive && (tag = this.getPreferredTagForItem(item = ResourceLocation.m_135820_((String)(primitive = (JsonPrimitive)tag2).getAsString()))) != null) {
                object.remove("item");
                object.addProperty("tag", tag.location().toString());
            }
        }
    }

    @Override
    @Nullable
    public JsonElement createResultReplacement(@Nullable JsonElement element) {
        return this.createResultReplacement(element, true, "item");
    }

    @Override
    @Nullable
    public JsonElement createResultReplacement(@Nullable JsonElement element, boolean tagLookup, String ... lookupKeys) {
        if (element == null) {
            return null;
        }
        JsonElement copy = element.deepCopy();
        JsonElement result = this.tryCreateResultReplacement(copy, tagLookup, lookupKeys);
        return element.equals(result) ? null : result;
    }

    @Nullable
    private JsonElement tryCreateResultReplacement(JsonElement element, boolean tagLookup, String ... lookupKeys) {
        JsonArray array;
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            ResourceLocation item = ResourceLocation.m_135820_((String)primitive.getAsString());
            ResourceLocation replacement = this.getReplacementForItem(item);
            if (replacement != null) {
                return new JsonPrimitive(replacement.toString());
            }
            return null;
        }
        if (element instanceof JsonArray && JsonUtils.replaceOn(array = (JsonArray)element, j -> this.tryCreateResultReplacement((JsonElement)j, tagLookup, lookupKeys))) {
            return element;
        }
        if (element instanceof JsonObject) {
            JsonElement replacement;
            JsonObject object = (JsonObject)element;
            for (String key : lookupKeys) {
                if (!JsonUtils.replaceOn(object, key, j -> this.tryCreateResultReplacement((JsonElement)j, tagLookup, lookupKeys))) continue;
                return element;
            }
            if (tagLookup && (replacement = object.get("tag")) instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)replacement;
                ResourceLocation item = this.getPreferredItemForTag(Utils.toItemTag(primitive.getAsString()), $ -> true);
                if (item != null) {
                    object.remove("tag");
                    object.addProperty("item", item.toString());
                }
                return element;
            }
        }
        return null;
    }

    @Override
    public ResourceLocation getType() {
        String type = this.originalRecipe.get("type").getAsString();
        return new ResourceLocation(type);
    }

    @Override
    public boolean hasProperty(String property) {
        return this.originalRecipe.has(property);
    }

    private static /* synthetic */ UnifyTag lambda$tryCreateIngredientReplacement$0(UnifyTag tag, TagOwnerships o) {
        return o.getOwnerByTag(tag);
    }
}

