/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.Platform;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.Defaults;
import com.almostreliable.unified.recipe.RecipeLink;
import com.almostreliable.unified.utils.JsonCompare;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class DuplicationConfig
extends Config {
    public static final String NAME = "duplicates";
    private final JsonCompare.CompareSettings defaultRules;
    private final LinkedHashMap<ResourceLocation, JsonCompare.CompareSettings> overrideRules;
    private final Set<Pattern> ignoreRecipeTypes;
    private final Set<Pattern> ignoreRecipes;
    private final boolean strictMode;
    private final Map<ResourceLocation, Boolean> ignoredRecipeTypesCache;

    public DuplicationConfig(JsonCompare.CompareSettings defaultRules, LinkedHashMap<ResourceLocation, JsonCompare.CompareSettings> overrideRules, Set<Pattern> ignoreRecipeTypes, Set<Pattern> ignoreRecipes, boolean strictMode) {
        this.defaultRules = defaultRules;
        this.overrideRules = overrideRules;
        this.ignoreRecipeTypes = ignoreRecipeTypes;
        this.ignoreRecipes = ignoreRecipes;
        this.strictMode = strictMode;
        this.ignoredRecipeTypesCache = new HashMap<ResourceLocation, Boolean>();
    }

    public boolean shouldIgnoreRecipe(RecipeLink recipe) {
        if (this.isRecipeTypeIgnored(recipe)) {
            return true;
        }
        for (Pattern ignoreRecipePattern : this.ignoreRecipes) {
            if (!ignoreRecipePattern.matcher(recipe.getId().toString()).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isRecipeTypeIgnored(RecipeLink recipe) {
        return this.ignoredRecipeTypesCache.computeIfAbsent(recipe.getType(), type -> {
            for (Pattern ignorePattern : this.ignoreRecipeTypes) {
                if (!ignorePattern.matcher(type.toString()).matches()) continue;
                return true;
            }
            return false;
        });
    }

    public JsonCompare.CompareSettings getCompareSettings(ResourceLocation type) {
        return this.overrideRules.getOrDefault(type, this.defaultRules);
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void clearCache() {
        this.ignoredRecipeTypesCache.clear();
    }

    public static class Serializer
    extends Config.Serializer<DuplicationConfig> {
        public static final String DEFAULT_DUPLICATE_RULES = "defaultDuplicateRules";
        public static final String OVERRIDE_DUPLICATE_RULES = "overrideDuplicateRules";
        public static final String IGNORED_RECIPE_TYPES = "ignoredRecipeTypes";
        public static final String IGNORED_RECIPES = "ignoredRecipes";
        public static final String STRICT_MODE = "strictMode";

        @Override
        public DuplicationConfig deserialize(JsonObject json) {
            Platform platform = AlmostUnifiedPlatform.INSTANCE.getPlatform();
            Set<Pattern> ignoreRecipeTypes = this.deserializePatterns(json, IGNORED_RECIPE_TYPES, Defaults.getIgnoredRecipeTypes(platform));
            Set<Pattern> ignoreRecipes = this.deserializePatterns(json, IGNORED_RECIPES, List.of());
            JsonCompare.CompareSettings defaultRules = this.safeGet(() -> this.createCompareSet(json.getAsJsonObject(DEFAULT_DUPLICATE_RULES)), Defaults.getDefaultDuplicateRules(platform));
            LinkedHashMap<ResourceLocation, JsonCompare.CompareSettings> overrideRules = this.safeGet(() -> json.getAsJsonObject(OVERRIDE_DUPLICATE_RULES).entrySet().stream().collect(Collectors.toMap(entry -> new ResourceLocation((String)entry.getKey()), entry -> this.createCompareSet(((JsonElement)entry.getValue()).getAsJsonObject()), (a, b) -> b, LinkedHashMap::new)), Defaults.getDefaultDuplicateOverrides(platform));
            boolean strictMode = this.safeGet(() -> json.get(STRICT_MODE).getAsBoolean(), false);
            return new DuplicationConfig(defaultRules, overrideRules, ignoreRecipeTypes, ignoreRecipes, strictMode);
        }

        private JsonCompare.CompareSettings createCompareSet(JsonObject rules) {
            JsonCompare.CompareSettings result = new JsonCompare.CompareSettings();
            result.deserialize(rules);
            return result;
        }

        @Override
        public JsonObject serialize(DuplicationConfig config) {
            JsonObject json = new JsonObject();
            this.serializePatterns(json, IGNORED_RECIPE_TYPES, config.ignoreRecipeTypes);
            this.serializePatterns(json, IGNORED_RECIPES, config.ignoreRecipes);
            json.add(DEFAULT_DUPLICATE_RULES, (JsonElement)config.defaultRules.serialize());
            JsonObject overrides = new JsonObject();
            config.overrideRules.forEach((rl, compareSettings) -> overrides.add(rl.toString(), (JsonElement)compareSettings.serialize()));
            json.add(OVERRIDE_DUPLICATE_RULES, (JsonElement)overrides);
            json.addProperty(STRICT_MODE, Boolean.valueOf(false));
            return json;
        }
    }
}

