/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.UnifyTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HideHelper {
    public static Collection<ItemStack> createHidingList(AlmostUnifiedRuntime runtime) {
        ReplacementMap repMap = runtime.getReplacementMap().orElse(null);
        TagMap tagMap = runtime.getFilteredTagMap().orElse(null);
        if (repMap == null || tagMap == null) {
            return new ArrayList<ItemStack>();
        }
        HashSet hidingList = new HashSet();
        for (UnifyTag<Item> unifyTag : tagMap.getTags()) {
            Set<ResourceLocation> itemsByTag = tagMap.getItemsByTag(unifyTag);
            long namespaces = itemsByTag.stream().map(ResourceLocation::m_135827_).distinct().count();
            if (namespaces <= 1L) continue;
            HashSet<ResourceLocation> replacements = new HashSet<ResourceLocation>();
            for (ResourceLocation item : itemsByTag) {
                replacements.add(HideHelper.getReplacementForItem(repMap, item));
            }
            HashSet<ResourceLocation> toHide = new HashSet<ResourceLocation>();
            for (ResourceLocation item : itemsByTag) {
                if (replacements.contains(item)) continue;
                toHide.add(item);
            }
            if (toHide.isEmpty()) continue;
            AlmostUnified.LOG.info("[AutoHiding] Hiding {}/{} items for tag '#{}' -> {}", (Object)toHide.size(), (Object)itemsByTag.size(), (Object)unifyTag.location(), toHide);
            hidingList.addAll(toHide);
        }
        hidingList.addAll(HideHelper.getRefItems(repMap));
        return hidingList.stream().flatMap(rl -> Registry.f_122827_.m_6612_(rl).stream()).map(ItemStack::new).collect(Collectors.toList());
    }

    private static ResourceLocation getReplacementForItem(ReplacementMap repMap, ResourceLocation item) {
        ResourceLocation replacement = repMap.getReplacementForItem(item);
        if (replacement == null) {
            return item;
        }
        return replacement;
    }

    private static Set<ResourceLocation> getRefItems(ReplacementMap repMap) {
        HashSet<ResourceLocation> hidingList = new HashSet<ResourceLocation>();
        AlmostUnified.getRuntime().getTagOwnerships().ifPresent(ownerships -> ownerships.getRefs().forEach(ref -> {
            UnifyTag<Item> owner = ownerships.getOwnerByTag((UnifyTag<Item>)ref);
            assert (owner != null);
            ResourceLocation dominantItem = repMap.getPreferredItemForTag(owner, $ -> true);
            TagKey asTagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)ref.location());
            HashSet refItems = new HashSet();
            Registry.f_122827_.m_206058_(asTagKey).forEach(holder -> {
                ResourceLocation item = Registry.f_122827_.m_7981_((Object)((Item)holder.m_203334_()));
                if (item.equals((Object)dominantItem)) {
                    return;
                }
                refItems.add(item);
            });
            if (refItems.isEmpty()) {
                return;
            }
            AlmostUnified.LOG.info("[AutoHiding] Hiding reference tag '#{}' of owner tag '#{}' -> {}", (Object)ref.location(), (Object)owner.location(), refItems);
            hidingList.addAll(refItems);
        }));
        return hidingList;
    }
}

