/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedFallbackRuntime;
import com.almostreliable.unified.compat.HideHelper;
import com.almostreliable.unified.compat.RecipeIndicator;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.recipe.CRTLookup;
import com.almostreliable.unified.recipe.ClientRecipeTracker;
import com.almostreliable.unified.utils.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@REIPluginCompatIgnore
@JeiPlugin
public class AlmostJEI
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return Utils.getRL("jei");
    }

    public void onRuntimeAvailable(IJeiRuntime jei) {
        AlmostUnifiedFallbackRuntime.getInstance().reload();
        Boolean jeiDisabled = AlmostUnified.getRuntime().getUnifyConfig().map(UnifyConfig::reiOrJeiDisabled).orElse(false);
        if (jeiDisabled.booleanValue()) {
            return;
        }
        Collection<ItemStack> items = HideHelper.createHidingList(AlmostUnified.getRuntime());
        if (!items.isEmpty()) {
            jei.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, items);
        }
    }

    public static <R> void handleIndicator(PoseStack stack, int mX, int mY, int posX, int posY, IRecipeCategory<R> recipeCategory, R recipe) {
        ResourceLocation recipeId = recipeCategory.getRegistryName(recipe);
        if (recipeId == null) {
            return;
        }
        ClientRecipeTracker.ClientRecipeLink link = CRTLookup.getLink(recipeId);
        if (link == null) {
            return;
        }
        Rect2i area = new Rect2i(posX, posY, 10, 10);
        RecipeIndicator.renderIndicator(stack, area);
        if (mX >= area.m_110085_() && mX <= area.m_110085_() + area.m_110090_() && mY >= area.m_110086_() && mY <= area.m_110086_() + area.m_110091_()) {
            Utils.renderTooltip(stack, mX, mY, RecipeIndicator.constructTooltip(link));
        }
    }
}

