/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.StoneStrataHandler;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.TagOwnerships;
import com.almostreliable.unified.utils.UnifyTag;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class AlmostUnifiedFallbackRuntime
implements AlmostUnifiedRuntime {
    @Nullable
    private static AlmostUnifiedFallbackRuntime INSTANCE;
    @Nullable
    private UnifyConfig unifyConfig;
    @Nullable
    private TagMap filteredTagMap;
    @Nullable
    private TagOwnerships tagOwnerships;
    @Nullable
    private ReplacementMap replacementMap;

    public static AlmostUnifiedFallbackRuntime getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AlmostUnifiedFallbackRuntime();
            INSTANCE.reload();
        }
        return INSTANCE;
    }

    public void reload() {
        this.unifyConfig = null;
        this.filteredTagMap = null;
        this.tagOwnerships = null;
        this.replacementMap = null;
        this.build();
    }

    public void build() {
        this.unifyConfig = Config.load("unify", new UnifyConfig.Serializer());
        Set<UnifyTag<Item>> unifyTags = this.unifyConfig.bakeTags();
        this.filteredTagMap = TagMap.create(unifyTags).filtered($ -> true, this.unifyConfig::includeItem);
        StoneStrataHandler stoneStrataHandler = AlmostUnifiedFallbackRuntime.createStoneStrataHandler(this.unifyConfig);
        this.tagOwnerships = new TagOwnerships(unifyTags, this.unifyConfig.getTagOwnerships());
        this.replacementMap = new ReplacementMap(this.unifyConfig, this.filteredTagMap, stoneStrataHandler, this.tagOwnerships);
    }

    private static StoneStrataHandler createStoneStrataHandler(UnifyConfig config) {
        Set<UnifyTag<Item>> stoneStrataTags = AlmostUnifiedPlatform.INSTANCE.getStoneStrataTags(config.getStoneStrata());
        TagMap stoneStrataTagMap = TagMap.create(stoneStrataTags);
        return StoneStrataHandler.create(config.getStoneStrata(), stoneStrataTags, stoneStrataTagMap);
    }

    @Override
    public void run(Map<ResourceLocation, JsonElement> recipes, boolean skipClientTracking) {
    }

    @Override
    public Optional<TagMap> getFilteredTagMap() {
        return Optional.ofNullable(this.filteredTagMap);
    }

    @Override
    public Optional<ReplacementMap> getReplacementMap() {
        return Optional.ofNullable(this.replacementMap);
    }

    @Override
    public Optional<UnifyConfig> getUnifyConfig() {
        return Optional.ofNullable(this.unifyConfig);
    }

    @Override
    public Optional<TagOwnerships> getTagOwnerships() {
        return Optional.ofNullable(this.tagOwnerships);
    }
}

