/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnifiedFallbackRuntime;
import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.AlmostUnifiedRuntimeImpl;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.ServerConfigs;
import com.almostreliable.unified.config.StartupConfig;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.TagOwnerships;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.tags.TagManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AlmostUnified {
    public static final Logger LOG = LogManager.getLogger((String)"AlmostUnified");
    @Nullable
    private static AlmostUnifiedRuntime RUNTIME;
    @Nullable
    private static StartupConfig STARTUP_CONFIG;
    @Nullable
    private static ServerConfigs SERVER_CONFIGS;
    @Nullable
    private static TagManager TAG_MANAGER;
    @Nullable
    private static TagOwnerships TAG_OWNERSHIPS;

    public static StartupConfig getStartupConfig() {
        if (STARTUP_CONFIG == null) {
            STARTUP_CONFIG = Config.load("startup", new StartupConfig.Serializer());
        }
        return STARTUP_CONFIG;
    }

    public static boolean isRuntimeLoaded() {
        return RUNTIME != null;
    }

    public static AlmostUnifiedRuntime getRuntime() {
        if (RUNTIME == null) {
            return AlmostUnifiedFallbackRuntime.getInstance();
        }
        return RUNTIME;
    }

    public static void onTagManagerReload(TagManager tagManager) {
        SERVER_CONFIGS = ServerConfigs.load();
        TAG_MANAGER = tagManager;
        UnifyConfig unifyConfig = SERVER_CONFIGS.getUnifyConfig();
        TAG_OWNERSHIPS = new TagOwnerships(unifyConfig.bakeTags(), unifyConfig.getTagOwnerships());
    }

    public static void onReloadRecipeManager() {
        Preconditions.checkNotNull((Object)SERVER_CONFIGS, (Object)"ServerConfigs were not loaded correctly");
        Preconditions.checkNotNull((Object)TAG_MANAGER, (Object)"TagManager was not loaded correctly");
        Preconditions.checkNotNull((Object)TAG_OWNERSHIPS, (Object)"TagOwnerships were not loaded correctly");
        RUNTIME = AlmostUnifiedRuntimeImpl.create(SERVER_CONFIGS, TAG_MANAGER, TAG_OWNERSHIPS);
    }
}

