/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Recipes.Ingredients;

import com.google.gson.JsonObject;

public class ExperienceIngredient {
    private static final String KEY_EXPERIENCE = "experience";
    private static final int RFPT_DEFAULT = 0;
    private int expNeeded;

    public ExperienceIngredient(int rf) {
        this.setExperience(rf);
    }

    public ExperienceIngredient(JsonObject recipeJson) {
        this.parseData(recipeJson);
    }

    private void parseData(JsonObject recipeJson) {
        if (!recipeJson.has(KEY_EXPERIENCE)) {
            this.setExperience(0);
        } else if (recipeJson.get(KEY_EXPERIENCE).isJsonObject()) {
            JsonObject experenceJson = recipeJson.get(KEY_EXPERIENCE).getAsJsonObject();
            this.setExperience(experenceJson.get("experienceValue").getAsInt());
        } else {
            this.setExperience(recipeJson.get(KEY_EXPERIENCE).getAsInt());
        }
    }

    private void setExperience(int rf) {
        this.expNeeded = Math.max(0, rf);
    }

    public int getExperienceRequired() {
        return this.expNeeded;
    }
}

