/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibMultiContainer;
import com.mowmaster.pedestals.PedestalUtils.RecipeUtil;
import com.mowmaster.pedestals.Recipes.Ingredients.DustIngredient;
import com.mowmaster.pedestals.Recipes.Ingredients.EnergyIngredient;
import com.mowmaster.pedestals.Recipes.Ingredients.ExperienceIngredient;
import com.mowmaster.pedestals.Recipes.Ingredients.FluidTagIngredient;
import com.mowmaster.pedestals.Registry.DeferredRegisterItems;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class BottlerRecipe
implements Recipe<MowLibMultiContainer> {
    @ObjectHolder(registryName="forge:recipe_serializer", value="pedestals:bottler")
    private final String group;
    private final ResourceLocation id;
    @Nullable
    private final Ingredient inputStack;
    public final FluidTagIngredient fluidIng;
    private final EnergyIngredient energy;
    private final ExperienceIngredient experience;
    private final DustIngredient dust;
    private final ItemStack generatedItemOrBlock;

    public BottlerRecipe(ResourceLocation id, String group, @Nullable Ingredient inputStack, @Nullable FluidTagIngredient fluidIng, @Nullable EnergyIngredient energy, @Nullable ExperienceIngredient experience, @Nullable DustIngredient dust, ItemStack generatedItemOrBlock) {
        this.group = group;
        this.id = id;
        this.inputStack = inputStack;
        this.fluidIng = fluidIng;
        this.energy = energy;
        this.experience = experience;
        this.dust = dust;
        this.generatedItemOrBlock = generatedItemOrBlock;
    }

    public boolean m_5598_() {
        return true;
    }

    public static Collection<BottlerRecipe> getAllRecipes(Level world) {
        return world.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList allIngredients = NonNullList.m_122779_();
        allIngredients.add((Object)(this.inputStack != null ? this.inputStack : Ingredient.f_43901_));
        return allIngredients;
    }

    public boolean matches(MowLibMultiContainer p_44002_, Level p_44003_) {
        MowLibMultiContainer cont = p_44002_;
        if (this.inputStack == null) {
            return false;
        }
        if (this.fluidIng == null && this.energy == null && this.experience == null && this.dust == null) {
            return false;
        }
        if (this.inputStack.test(cont.m_8020_(0)) && !this.generatedItemOrBlock.m_41619_()) {
            if (this.fluidIng != null && !this.fluidIng.getFluidStack().isEmpty()) {
                if (cont.getFluidStack().isEmpty()) {
                    return false;
                }
                if (!this.fluidIng.getFluidStack().isFluidEqual(cont.getFluidStack())) {
                    return false;
                }
            }
            if (this.energy != null && this.energy.getEnergyNeeded() > 0) {
                if (cont.getEnergy() <= 0) {
                    return false;
                }
                if (this.energy.getEnergyNeeded() > cont.getEnergy()) {
                    return false;
                }
            }
            if (this.experience != null && this.experience.getExperienceRequired() > 0) {
                if (cont.getExperience() <= 0) {
                    return false;
                }
                if (this.experience.getExperienceRequired() > cont.getExperience()) {
                    return false;
                }
            }
            if (this.dust != null && !this.dust.getDustMagic().isEmpty()) {
                if (cont.getDustMagic().isEmpty()) {
                    return false;
                }
                if (!this.dust.getDustMagic().isDustEqual(cont.getDustMagic())) {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public ItemStack assemble(MowLibMultiContainer p_44001_) {
        return this.m_8043_().m_41777_();
    }

    public ItemStack m_8043_() {
        return this.generatedItemOrBlock;
    }

    public FluidStack getFluidNeeded() {
        if (this.fluidIng != null) {
            return this.fluidIng.getFluidStack();
        }
        return FluidStack.EMPTY;
    }

    public int getEnergyNeeded() {
        return this.energy.getEnergyNeeded();
    }

    public int getExperienceNeeded() {
        return this.experience.getExperienceRequired();
    }

    public DustMagic getDustNeeded() {
        return this.dust.getDustMagic();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)DeferredRegisterItems.PEDESTAL_UPGRADE_BOTTLER.get());
    }

    public FluidStack getFluidStack() {
        return this.fluidIng.getFluidStack();
    }

    public int getEnergy() {
        return this.energy.getEnergyNeeded();
    }

    public int getExperience() {
        return this.experience.getExperienceRequired();
    }

    public DustMagic getDustMagic() {
        return this.dust.getDustMagic();
    }

    public Ingredient getPattern() {
        return this.inputStack != null ? this.inputStack : Ingredient.f_43901_;
    }

    public static class Type
    implements RecipeType<BottlerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "bottler";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<BottlerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pedestals", "bottler");

        protected BottlerRecipe createRecipe(ResourceLocation recipeId, String group, @Nullable Ingredient inputStack, @Nullable FluidTagIngredient fluidIng, @Nullable EnergyIngredient energy, @Nullable ExperienceIngredient experience, @Nullable DustIngredient dust, ItemStack generatedItemOrBlock) {
            return new BottlerRecipe(recipeId, group, inputStack, fluidIng, energy, experience, dust, generatedItemOrBlock);
        }

        public BottlerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient inputStack = json.has("inputStack") ? CraftingHelper.getIngredient((JsonElement)json.get("inputStack")) : null;
            FluidTagIngredient fluidTagIngredient = json.has("inputFluidStack") ? RecipeUtil.parseFluid(json, "inputFluidStack") : null;
            EnergyIngredient energyIngredient = new EnergyIngredient(json);
            ExperienceIngredient experienceIngredient = new ExperienceIngredient(json);
            DustIngredient dustIngredient = DustIngredient.parseData(json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return this.createRecipe(recipeId, group, inputStack, fluidTagIngredient, energyIngredient, experienceIngredient, dustIngredient, result);
        }

        public BottlerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            boolean hasInput = buffer.readBoolean();
            Ingredient inputStack = hasInput ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            boolean hasInputFluid = buffer.readBoolean();
            FluidTagIngredient ingredientFluid = hasInputFluid ? FluidTagIngredient.readFromPacket(buffer) : null;
            EnergyIngredient energyIngredient = new EnergyIngredient(buffer.readInt());
            ExperienceIngredient experienceIngredient = new ExperienceIngredient(buffer.readInt());
            DustIngredient dustIngredient = new DustIngredient(buffer.readInt(), buffer.readInt());
            ItemStack result = buffer.m_130267_();
            return this.createRecipe(recipeId, group, inputStack, ingredientFluid, energyIngredient, experienceIngredient, dustIngredient, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, BottlerRecipe recipe) {
            buffer.m_130070_(recipe.group);
            boolean hasInput = recipe.inputStack != null;
            buffer.writeBoolean(hasInput);
            if (hasInput) {
                recipe.inputStack.m_43923_(buffer);
            }
            boolean hasInputFluid = recipe.fluidIng != null;
            buffer.writeBoolean(hasInputFluid);
            if (hasInputFluid) {
                recipe.fluidIng.writeToPacket(buffer);
            }
            buffer.writeInt(recipe.energy.getEnergyNeeded());
            buffer.writeInt(recipe.experience.getExperienceRequired());
            buffer.writeInt(recipe.dust.getDustMagic().getDustColor());
            buffer.writeInt(recipe.dust.getDustMagic().getDustAmount());
            buffer.m_130055_(recipe.generatedItemOrBlock);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }
}

