/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemUpgradeSmoker
extends ItemUpgradeBase {
    public ItemUpgradeSmoker(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return this.baseEnergyCost();
    }

    public int baseEnergyCost() {
        return (Integer)PedestalConfig.COMMON.upgrade_smoker_baseEnergyCost.get();
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        ArrayList<String> messages = new ArrayList<String>();
        if (pedestal.getItemInPedestal().m_41619_() && this.baseEnergyCost() > 0) {
            boolean hasItem = MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)pedestal.getCoinOnPedestal().m_41784_(), (String)"hasitem");
            if (pedestal.getStoredEnergy() < this.baseEnergyCost() && hasItem) {
                messages.add(ChatFormatting.RED + "Needs Energy");
            }
        }
        return messages;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"input");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"output");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"cooktime");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"xpamount");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"_numdelay");
    }

    @Nullable
    protected SmokingRecipe getNormalRecipe(BasePedestalBlockEntity pedestal, ItemStack stackIn) {
        Level level = pedestal.m_58904_();
        Container cont = MowLibContainerUtils.getContainer((int)1);
        cont.m_6836_(-1, stackIn);
        if (level == null) {
            return null;
        }
        RecipeManager recipeManager = level.m_7465_();
        Optional optional = recipeManager.m_44015_(RecipeType.f_44110_, cont, level);
        if (optional.isPresent()) {
            return optional.orElse(null);
        }
        return null;
    }

    protected Collection<ItemStack> getNormalResults(SmokingRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.f_41583_) : Collections.singleton(recipe.m_8043_());
    }

    protected int getCookTime(SmokingRecipe recipe) {
        return recipe == null ? 0 : recipe.m_43753_();
    }

    protected int getExperienceResult(SmokingRecipe recipe) {
        float returner = recipe == null ? 0.0f : recipe.m_43750_();
        return Math.round(returner);
    }

    private ItemStack getResultFromCachedRecipe(ItemStack coin, ItemStack input) {
        ItemStack inputStack = MowLibCompoundTagUtils.readItemStackFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"input");
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)inputStack, (ItemStack)input)) {
            return MowLibCompoundTagUtils.readItemStackFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"output");
        }
        return ItemStack.f_41583_;
    }

    private int getCookTimeFromCachedRecipe(ItemStack coin, ItemStack input) {
        ItemStack inputStack = MowLibCompoundTagUtils.readItemStackFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"input");
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)inputStack, (ItemStack)input)) {
            return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"cooktime");
        }
        return -1;
    }

    private int getXpFromCachedRecipe(ItemStack coin, ItemStack input) {
        ItemStack inputStack = MowLibCompoundTagUtils.readItemStackFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"input");
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)inputStack, (ItemStack)input)) {
            return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"xpamount");
        }
        return 0;
    }

    private void cacheRecipe(BasePedestalBlockEntity pedestal, ItemStack coin, ItemStack input) {
        ItemStack result;
        SmokingRecipe recipe = this.getNormalRecipe(pedestal, input);
        if (recipe != null && !(result = this.getNormalResults(recipe).stream().findFirst().orElse(ItemStack.f_41583_)).m_41619_()) {
            MowLibCompoundTagUtils.writeItemStackToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (ItemStack)input, (String)"input");
            MowLibCompoundTagUtils.writeItemStackToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (ItemStack)result, (String)"output");
            MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)this.getCookTime(recipe), (String)"cooktime");
            MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)this.getExperienceResult(recipe), (String)"xpamount");
            MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)this.getExperienceResult(recipe), (String)"hasitem");
        }
    }

    private boolean hasCachedRecipe(ItemStack coin) {
        ItemStack inputStack = MowLibCompoundTagUtils.readItemStackFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"input");
        return !inputStack.m_41619_();
    }

    private int getCookTime(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numdelay");
    }

    private void resetCookTime(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)0, (String)"_numdelay");
    }

    private void incrementCookingTime(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCookTime(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1 + this.getSpeedTicksReduced(pedestal.getCoinOnPedestal())), (String)"_numdelay");
    }

    private void resetCache(BasePedestalBlockEntity pedestal, ItemStack coin) {
        if (this.hasCachedRecipe(coin)) {
            MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"input");
            MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"output");
            MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"cooktime");
            MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"xpamount");
            MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numdelay");
        }
    }

    @Override
    public void updateAction(Level level, BasePedestalBlockEntity pedestal) {
        BlockPos pedestalPos = pedestal.getPos();
        ItemStack coin = pedestal.getCoinOnPedestal();
        BlockPos posInventory = this.getPosOfBlockBelow(level, pedestalPos, 1);
        ItemStack itemFromInv = ItemStack.f_41583_;
        LazyOptional cap = MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true);
        if (!this.isInventoryEmpty((LazyOptional<IItemHandler>)cap) && cap.isPresent()) {
            int i;
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            BlockEntity invToPullFrom = level.m_7702_(posInventory);
            if (invToPullFrom instanceof BasePedestalBlockEntity) {
                itemFromInv = ItemStack.f_41583_;
            } else if (handler != null && (i = this.getNextSlotWithItemsCapFilteredMachine(pedestal, (LazyOptional<IItemHandler>)cap)) >= 0) {
                itemFromInv = handler.getStackInSlot(i);
                ItemStack copyIncoming = itemFromInv.m_41777_();
                copyIncoming.m_41764_(1);
                if (itemFromInv != null && !itemFromInv.m_41619_()) {
                    if (!MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)pedestal.getCoinOnPedestal().m_41784_(), (String)"hasitem")) {
                        MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)pedestal.getCoinOnPedestal().m_41784_(), (boolean)true, (String)"hasitem");
                        pedestal.update();
                    }
                    if (this.hasCachedRecipe(coin)) {
                        int cooktime = this.getCookTimeFromCachedRecipe(coin, copyIncoming);
                        int xp = this.getXpFromCachedRecipe(coin, copyIncoming);
                        ItemStack result = this.getResultFromCachedRecipe(coin, copyIncoming);
                        if (!result.m_41619_()) {
                            int currentCookTime = this.getCookTime(pedestal);
                            if (currentCookTime >= cooktime) {
                                this.resetCookTime(pedestal);
                                if (!handler.extractItem(i, 1, true).m_41619_() && pedestal.addItemStack(result, true).m_41619_()) {
                                    handler.extractItem(i, 1, false);
                                    pedestal.addExperience(xp, false);
                                    pedestal.addItemStack(result, false);
                                    if (pedestal.canSpawnParticles()) {
                                        MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_() + 0.75, (double)pedestalPos.m_123343_(), new int[]{255, 150, 0}));
                                    }
                                }
                            } else {
                                int cost = this.baseEnergyCost();
                                if (pedestal.removeEnergy(cost, true) >= cost) {
                                    pedestal.removeEnergy(cost, false);
                                    this.incrementCookingTime(pedestal);
                                    if (pedestal.canSpawnParticles()) {
                                        MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_() + 0.75, (double)pedestalPos.m_123343_(), new int[]{0, 0, 0}));
                                    }
                                }
                            }
                        } else {
                            this.cacheRecipe(pedestal, coin, copyIncoming);
                        }
                    } else {
                        this.cacheRecipe(pedestal, coin, copyIncoming);
                    }
                } else if (MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)pedestal.getCoinOnPedestal().m_41784_(), (String)"hasitem")) {
                    MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)pedestal.getCoinOnPedestal().m_41784_(), (boolean)false, (String)"hasitem");
                    pedestal.update();
                }
            }
        }
    }
}

