/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.google.common.collect.Maps;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeRecycler
extends ItemUpgradeBase
implements IHasModeTypes {
    public ItemUpgradeRecycler(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_storedExpUnderOne");
    }

    private boolean canProcess(ItemStack stackIn) {
        if (!stackIn.m_41619_()) {
            boolean tagged = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_recycle"))).stream().toList().contains(stackIn);
            return !tagged && (stackIn.m_41720_() instanceof ArmorItem || stackIn.m_41720_() instanceof TieredItem);
        }
        return false;
    }

    public int getNextSlotWithItemsCapFilteredAndPasses(BasePedestalBlockEntity pedestal, LazyOptional<IItemHandler> cap) {
        AtomicInteger slot = new AtomicInteger(-1);
        if (cap.isPresent()) {
            cap.ifPresent(itemHandler -> {
                int range = itemHandler.getSlots();
                for (int i = 0; i < range; ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    if (stackInSlot.m_41619_() || itemHandler.extractItem(i, 1, true).equals(ItemStack.f_41583_) || !this.passesItemFilter(pedestal, stackInSlot) || !this.canProcess(stackInSlot)) continue;
                    ItemStack itemFromPedestal = pedestal.getMatchingItemInPedestalOrEmptySlot(stackInSlot);
                    if (itemFromPedestal.m_41619_()) {
                        slot.set(i);
                        break;
                    }
                    if (!this.doItemsMatch(itemFromPedestal, stackInSlot)) continue;
                    slot.set(i);
                    break;
                }
            });
        }
        return slot.get();
    }

    @Nullable
    protected AbstractCookingRecipe getNormalRecipe(Level level, ItemStack stackIn) {
        Container cont = MowLibContainerUtils.getContainer((int)1);
        cont.m_6836_(-1, stackIn);
        if (level == null) {
            return null;
        }
        RecipeManager recipeManager = level.m_7465_();
        Optional optional = recipeManager.m_44015_(RecipeType.f_44109_, cont, level);
        if (optional.isPresent()) {
            return (AbstractCookingRecipe)optional.get();
        }
        Optional optional1 = recipeManager.m_44015_(RecipeType.f_44108_, cont, level);
        return optional1.orElse(null);
    }

    protected Collection<ItemStack> getNormalResults(AbstractCookingRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.f_41583_) : Collections.singleton(recipe.m_8043_());
    }

    protected float getNormalResultsExp(AbstractCookingRecipe recipe) {
        return recipe == null ? 0.0f : recipe.m_43750_();
    }

    private boolean canAddExperienceFromProcessing(BasePedestalBlockEntity pedestal, float experience) {
        int sum;
        ItemStack coin = pedestal.getCoinOnPedestal();
        int getExperienceStored = MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41783_(), (String)"_storedExpUnderOne");
        int convertFloatDecimal = (int)(experience * 100.0f);
        int expToAdd = 0;
        int remainingXP = 0;
        boolean returner = false;
        if (sum >= 100) {
            for (sum = getExperienceStored + convertFloatDecimal; sum >= 100; sum -= 100) {
                ++expToAdd;
            }
            if (pedestal.addExperience(expToAdd, true) > 0) {
                pedestal.addExperience(expToAdd, false);
                remainingXP = sum;
                returner = true;
            }
        } else {
            remainingXP = sum;
        }
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41783_(), (int)remainingXP, (String)"_storedExpUnderOne");
        return returner;
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        BlockPos posInventory = this.getPosOfBlockBelow(level, pedestalPos, 1);
        ItemStack itemFromInv = ItemStack.f_41583_;
        LazyOptional cap = MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true);
        if (!this.isInventoryEmpty((LazyOptional<IItemHandler>)cap) && cap.isPresent()) {
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            BlockEntity invToPullFrom = level.m_7702_(posInventory);
            if (invToPullFrom instanceof BasePedestalBlockEntity) {
                itemFromInv = ItemStack.f_41583_;
            } else if (handler != null) {
                ItemStack copyIncoming;
                int i;
                if (this.canTransferXP(coin) && (i = this.getNextSlotWithItemsCapFiltered(pedestal, (LazyOptional<IItemHandler>)cap)) >= 0) {
                    int getGrindedXpCount;
                    int getXPSpace;
                    itemFromInv = handler.getStackInSlot(i);
                    copyIncoming = itemFromInv.m_41777_();
                    if (itemFromInv != null && !itemFromInv.m_41619_() && (copyIncoming.m_41793_() || copyIncoming.m_41720_() instanceof EnchantedBookItem) && (getXPSpace = pedestal.spaceForExperience()) >= (getGrindedXpCount = this.getItemsExpDisenchantAmount(copyIncoming))) {
                        LinkedHashMap enchantsNone = Maps.newLinkedHashMap();
                        ItemStack stackToReturn = copyIncoming.m_41720_() instanceof EnchantedBookItem ? new ItemStack((ItemLike)Items.f_42517_, 1) : copyIncoming;
                        EnchantmentHelper.m_44865_((Map)enchantsNone, (ItemStack)stackToReturn);
                        if (!stackToReturn.m_41619_()) {
                            if (this.canTransferItems(coin)) {
                                if (pedestal.addExperience(getGrindedXpCount, true) > 0) {
                                    EnchantmentHelper.m_44865_((Map)enchantsNone, (ItemStack)itemFromInv);
                                    pedestal.addExperience(getGrindedXpCount, false);
                                }
                            } else if (!handler.extractItem(i, 1, true).m_41619_() && pedestal.addItem(stackToReturn, true) && pedestal.addExperience(getGrindedXpCount, true) > 0) {
                                handler.extractItem(i, 1, false);
                                pedestal.addExperience(getGrindedXpCount, false);
                                pedestal.addItem(stackToReturn, false);
                            }
                        }
                    }
                }
                if (this.canTransferItems(coin) && (i = this.getNextSlotWithItemsCapFilteredAndPasses(pedestal, (LazyOptional<IItemHandler>)cap)) >= 0) {
                    itemFromInv = handler.getStackInSlot(i);
                    copyIncoming = itemFromInv.m_41777_();
                    copyIncoming.m_41764_(1);
                    if (itemFromInv != null && !itemFromInv.m_41619_()) {
                        AbstractCookingRecipe recipe = this.getNormalRecipe(pedestal.m_58904_(), copyIncoming);
                        float getEXP = this.getNormalResultsExp(recipe);
                        ItemStack returnedStack = this.getNormalResults(recipe).stream().findFirst().orElse(ItemStack.f_41583_);
                        if (!returnedStack.m_41619_()) {
                            if (!handler.extractItem(i, 1, true).m_41619_() && pedestal.addItem(returnedStack, true)) {
                                handler.extractItem(i, 1, false);
                                if (getEXP > 0.0f) {
                                    this.canAddExperienceFromProcessing(pedestal, getEXP);
                                }
                                pedestal.addItem(returnedStack, false);
                            }
                        } else if (!handler.extractItem(i, 1, true).m_41619_() && pedestal.addItem(copyIncoming, true)) {
                            handler.extractItem(i, 1, false);
                            pedestal.addItem(copyIncoming, false);
                        }
                    }
                }
            }
        }
    }

    public int getItemsExpDisenchantAmount(ItemStack stack) {
        int exp = 0;
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            exp += enchantment.m_6183_(integer.intValue());
        }
        return exp * stack.m_41613_();
    }
}

