/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Filters.BaseFilter;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardBase;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeQuarry
extends ItemUpgradeBase {
    public ItemUpgradeQuarry(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyBlockCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard() {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_quarry_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_quarry_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_quarry_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_quarry_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_quarry_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_quarry_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_quarry_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_quarry_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_quarry_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_quarry_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_quarry_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_quarry_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        return new ItemStack((ItemLike)Items.f_42385_);
    }

    private void buildValidBlockList(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        ItemStack coin = pedestal.getCoinOnPedestal();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            List<BlockPos> listed = WorkCardBase.readBlockPosListFromNBT(card);
            ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
            for (BlockPos pos : listed) {
                if (!workCardBase.selectedPointWithinRange(pedestal, pos)) continue;
                valid.add(pos);
            }
            ItemUpgradeQuarry.saveBlockPosListCustomToNBT(coin, "_validlist", valid);
        }
    }

    private void buildValidBlockListArea(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        ItemStack coin = pedestal.getCoinOnPedestal();
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            AABB area = new AABB(WorkCardBase.readBlockPosFromNBT(card, 1), WorkCardBase.readBlockPosFromNBT(card, 2));
            int maxX = (int)area.f_82291_;
            int maxY = (int)area.f_82292_;
            int maxZ = (int)area.f_82293_;
            int minX = (int)area.f_82288_;
            int minY = (int)area.f_82289_;
            int minZ = (int)area.f_82290_;
            BlockPos pedestalPos = pedestal.getPos();
            for (int i = maxX; i >= minX; --i) {
                for (int j = maxZ; j >= minZ; --j) {
                    BlockPos newPoint = new BlockPos(i, pedestalPos.m_123342_(), j);
                    if (!workCardBase.selectedPointWithinRange(pedestal, newPoint)) continue;
                    valid.add(newPoint);
                }
            }
            ItemUpgradeQuarry.saveBlockPosListCustomToNBT(coin, "_validlist", valid);
        }
    }

    private List<BlockPos> getValidList(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return ItemUpgradeQuarry.readBlockPosListCustomFromNBT(coin, "_validlist");
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.removeBlockListCustomNBTTags(coinInPedestal, "_validlist");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numdelay");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numheight");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_boolstop");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        ItemStack card;
        Item item;
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            boolean override = workCardBase.hasTwoPointsSelected(card);
            List<BlockPos> listed = this.getValidList(pedestal);
            if (override) {
                if (listed.size() > 0) {
                    this.quarryAction(level, pedestal);
                } else if (workCardBase.selectedAreaWithinRange(pedestal) && !this.hasBlockListCustomNBTTags(coin, "_validlist")) {
                    this.buildValidBlockListArea(pedestal);
                }
            }
        }
    }

    private boolean getStopped(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_boolstop");
    }

    private void setStopped(BasePedestalBlockEntity pedestal, boolean value) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (boolean)value, (String)"_boolstop");
    }

    private int getHeightIteratorValue(BasePedestalBlockEntity pedestal) {
        return (Integer)PedestalConfig.COMMON.upgrade_quarry_baseBlocksMined.get() + this.getBlockCapacityIncrease(pedestal.getCoinOnPedestal());
    }

    private int getCurrentHeight(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return coin.m_41784_().m_128441_("pedestals_numheight") ? MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numheight") : pedestal.m_58904_().m_141937_();
    }

    private void setCurrentHeight(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numheight");
    }

    private void iterateCurrentHeight(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentHeight(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + this.getHeightIteratorValue(pedestal)), (String)"_numheight");
    }

    private int getCurrentDelay(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numdelay");
    }

    private void setCurrentDelay(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numdelay");
    }

    private void iterateCurrentDelay(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentDelay(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1 + this.getSpeedTicksReduced(pedestal.getCoinOnPedestal())), (String)"_numdelay");
    }

    private int getCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private void iterateCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentPosition(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1), (String)"_numposition");
    }

    private List<ItemStack> getBlockDrops(BasePedestalBlockEntity pedestal, BlockState blockTarget, BlockPos posTarget) {
        ItemStack getToolFromPedestal = pedestal.getToolStack().m_41619_() ? new ItemStack((ItemLike)Items.f_42386_) : pedestal.getToolStack();
        Level level = pedestal.m_58904_();
        if (blockTarget.m_60734_() != Blocks.f_50016_) {
            WeakReference<FakePlayer> getPlayer = pedestal.getPedestalPlayer(pedestal);
            if (getPlayer != null && getPlayer.get() != null) {
                LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_())).m_78984_(LootContextParams.f_81455_, (Object)((Entity)getPlayer.get())).m_78972_(LootContextParams.f_81463_, (Object)getToolFromPedestal);
                return blockTarget.m_60724_(builder);
            }
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)getToolFromPedestal);
            return blockTarget.m_60724_(builder);
        }
        return new ArrayList<ItemStack>();
    }

    private boolean canMine(BasePedestalBlockEntity pedestal, BlockState canMineBlock, BlockPos canMinePos) {
        return ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_can_chop_cant_quarry"))).stream().toList().contains(canMineBlock.m_60734_());
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, BlockState canMineBlock, BlockPos canMinePos) {
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInPedestal()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral()) {
            ItemStack blockToCheck = ItemStack.f_41583_;
            if (canMineBlock.m_60734_() instanceof Block) {
                blockToCheck = canMineBlock.m_60734_().m_7397_((BlockGetter)pedestal.m_58904_(), canMinePos, canMineBlock);
            }
            return filter.canAcceptItems(filterInPedestal, blockToCheck);
        }
        return true;
    }

    private void dropXP(Level level, BasePedestalBlockEntity pedestal, BlockState blockAtPoint, BlockPos currentPoint) {
        int fortune = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44987_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)pedestal.getToolStack()) : 0;
        int silky = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44985_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)pedestal.getToolStack()) : 0;
        int xpdrop = blockAtPoint.m_60734_().getExpDrop(blockAtPoint, (LevelReader)level, level.f_46441_, currentPoint, fortune, silky);
        if (xpdrop > 0) {
            blockAtPoint.m_60734_().m_49805_((ServerLevel)level, currentPoint, xpdrop);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void quarryAction(Level level, BasePedestalBlockEntity pedestal) {
        int min;
        boolean minMaxHeight;
        if (level.m_5776_()) return;
        if (!pedestal.hasWorkCard()) return;
        ItemStack card = pedestal.getWorkCardInPedestal();
        Item item = card.m_41720_();
        if (!(item instanceof WorkCardBase)) return;
        WorkCardBase workCardBase = (WorkCardBase)item;
        WeakReference<FakePlayer> getPlayer = pedestal.getPedestalPlayer(pedestal);
        if (getPlayer == null) return;
        if (getPlayer.get() == null) return;
        List<BlockPos> listed = this.getValidList(pedestal);
        int currentPosition = this.getCurrentPosition(pedestal);
        BlockPos currentPoint = listed.get(currentPosition);
        AABB area = new AABB(WorkCardBase.readBlockPosFromNBT(card, 1), WorkCardBase.readBlockPosFromNBT(card, 2));
        int maxY = (int)area.f_82292_;
        int minY = (int)area.f_82289_;
        int ySpread = maxY - minY;
        boolean bl = minMaxHeight = ySpread > 0;
        if (ySpread > this.getHeightIteratorValue(pedestal)) {
            this.setCurrentHeight(pedestal, minY);
        }
        int currentYMin = this.getCurrentHeight(pedestal);
        int currentYMax = minMaxHeight ? 0 : currentYMin + this.getHeightIteratorValue(pedestal);
        int n = min = minMaxHeight ? minY : currentYMin;
        int max = minMaxHeight ? (ySpread > this.getHeightIteratorValue(pedestal) ? minY + this.getHeightIteratorValue(pedestal) : maxY) : currentYMax;
        int absoluteMax = minMaxHeight ? maxY : level.m_151558_();
        boolean fuelRemoved = true;
        boolean runsOnce = true;
        boolean stop = this.getStopped(pedestal);
        if (!this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), currentPoint), true)) return;
        if (stop) {
            if (pedestal.canSpawnParticles()) {
                MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestal.getPos().m_123341_(), (double)((float)pedestal.getPos().m_123342_() + 1.0f), (double)pedestal.getPos().m_123343_(), new int[]{55, 55, 55}));
            }
        } else {
            for (int y = min; y <= max; ++y) {
                BlockEvent.BreakEvent e;
                BlockPos adjustedPoint = new BlockPos(currentPoint.m_123341_(), y, currentPoint.m_123343_());
                BlockState blockAtPoint = level.m_8055_(adjustedPoint);
                if (blockAtPoint.m_60734_().equals(Blocks.f_50016_) || !(blockAtPoint.m_60800_((BlockGetter)level, currentPoint) >= 0.0f) || !ForgeEventFactory.doPlayerHarvestCheck((Player)(getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get()), (BlockState)blockAtPoint, (boolean)true) || MinecraftForge.EVENT_BUS.post((Event)(e = new BlockEvent.BreakEvent(level, adjustedPoint, blockAtPoint, getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get()))) || this.canMine(pedestal, blockAtPoint, adjustedPoint) || !this.passesFilter(pedestal, blockAtPoint, adjustedPoint) || ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_break"))).stream().toList().contains(blockAtPoint.m_60734_())) continue;
                boolean damage = false;
                if (adjustedPoint.equals((Object)pedestal.getPos()) || !this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), adjustedPoint), true)) continue;
                if (((Boolean)PedestalConfig.COMMON.quarryDamageTools.get()).booleanValue() && pedestal.hasTool()) {
                    BlockPos pedestalPos = pedestal.getPos();
                    if (pedestal.getDurabilityRemainingOnInsertedTool() <= 0) {
                        if (!pedestal.canSpawnParticles()) return;
                        MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                        return;
                    }
                    if (!pedestal.damageInsertedTool(1, true)) {
                        if (!pedestal.canSpawnParticles()) return;
                        MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                        return;
                    }
                    damage = true;
                }
                if (this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), adjustedPoint), false)) {
                    boolean canRemoveBlockEntities = (Boolean)PedestalConfig.COMMON.blockBreakerBreakEntities.get();
                    List<ItemStack> drops = this.getBlockDrops(pedestal, blockAtPoint, adjustedPoint);
                    if (level.m_7702_(adjustedPoint) != null) {
                        if (!canRemoveBlockEntities) continue;
                        blockAtPoint.m_60753_(level, adjustedPoint, blockAtPoint, true);
                        this.dropXP(level, pedestal, blockAtPoint, adjustedPoint);
                        level.m_46747_(adjustedPoint);
                        level.m_46597_(adjustedPoint, Blocks.f_50016_.m_49966_());
                        if (damage) {
                            pedestal.damageInsertedTool(1, false);
                        }
                        if (drops.size() <= 0) continue;
                        for (ItemStack stack : drops) {
                            MowLibItemUtils.spawnItemStack((Level)level, (double)adjustedPoint.m_123341_(), (double)adjustedPoint.m_123342_(), (double)adjustedPoint.m_123343_(), (ItemStack)stack);
                        }
                        continue;
                    }
                    this.dropXP(level, pedestal, blockAtPoint, adjustedPoint);
                    level.m_46597_(adjustedPoint, Blocks.f_50016_.m_49966_());
                    if (damage) {
                        pedestal.damageInsertedTool(1, false);
                    }
                    if (drops.size() <= 0) continue;
                    for (ItemStack stack : drops) {
                        MowLibItemUtils.spawnItemStack((Level)level, (double)adjustedPoint.m_123341_(), (double)adjustedPoint.m_123342_(), (double)adjustedPoint.m_123343_(), (ItemStack)stack);
                    }
                    continue;
                }
                fuelRemoved = false;
            }
        }
        if (currentPosition + 1 >= listed.size() && currentYMax >= absoluteMax) {
            if (!runsOnce) {
                this.setCurrentPosition(pedestal, 0);
                return;
            }
            int delay = listed.size() * Math.abs((minMaxHeight ? maxY : level.m_151558_()) - (minMaxHeight ? maxY : level.m_141937_()));
            if (this.getCurrentDelay(pedestal) >= delay) {
                this.setCurrentPosition(pedestal, 0);
                this.setStopped(pedestal, false);
                this.setCurrentDelay(pedestal, 0);
                return;
            }
            this.iterateCurrentDelay(pedestal);
            this.setStopped(pedestal, true);
            return;
        }
        if (currentPosition + 1 >= listed.size()) {
            this.setCurrentPosition(pedestal, 0);
            this.iterateCurrentHeight(pedestal);
            return;
        }
        if (!fuelRemoved) return;
        this.iterateCurrentPosition(pedestal);
    }
}

