/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Filters.BaseFilter;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardBase;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradePlanter
extends ItemUpgradeBase {
    public ItemUpgradePlanter(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean canModifySuperSpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean needsWorkCard() {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 0;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_planter_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_planter_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_planter_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_planter_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_planter_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_planter_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_planter_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_planter_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_planter_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_planter_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_planter_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_planter_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    private void buildValidBlockList(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        ItemStack coin = pedestal.getCoinOnPedestal();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            List<BlockPos> listed = WorkCardBase.readBlockPosListFromNBT(card);
            ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
            for (BlockPos pos : listed) {
                if (!workCardBase.selectedPointWithinRange(pedestal, pos)) continue;
                valid.add(pos);
            }
            ItemUpgradePlanter.saveBlockPosListCustomToNBT(coin, "_validlist", valid);
        }
    }

    private void buildValidBlockListArea(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        ItemStack coin = pedestal.getCoinOnPedestal();
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            AABB area = new AABB(WorkCardBase.readBlockPosFromNBT(card, 1), WorkCardBase.readBlockPosFromNBT(card, 2));
            int maxX = (int)area.f_82291_;
            int maxY = (int)area.f_82292_;
            int maxZ = (int)area.f_82293_;
            int minX = (int)area.f_82288_;
            int minY = (int)area.f_82289_;
            int minZ = (int)area.f_82290_;
            BlockPos pedestalPos = pedestal.getPos();
            if (minY < pedestalPos.m_123342_()) {
                for (int i = maxX; i >= minX; --i) {
                    for (int j = maxZ; j >= minZ; --j) {
                        for (int k = maxY; k >= minY; --k) {
                            BlockPos newPoint = new BlockPos(i, k, j);
                            if (!workCardBase.selectedPointWithinRange(pedestal, newPoint)) continue;
                            valid.add(newPoint);
                        }
                    }
                }
            } else {
                for (int i = minX; i <= maxX; ++i) {
                    for (int j = minZ; j <= maxZ; ++j) {
                        for (int k = minY; k <= maxY; ++k) {
                            BlockPos newPoint = new BlockPos(i, k, j);
                            if (!workCardBase.selectedPointWithinRange(pedestal, newPoint)) continue;
                            valid.add(newPoint);
                        }
                    }
                }
            }
        }
        ItemUpgradePlanter.saveBlockPosListCustomToNBT(coin, "_validlist", valid);
    }

    private List<BlockPos> getValidList(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return ItemUpgradePlanter.readBlockPosListCustomFromNBT(coin, "_validlist");
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.removeBlockListCustomNBTTags(coinInPedestal, "_validlist");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        ItemStack card;
        Item item;
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            boolean override = workCardBase.hasTwoPointsSelected(card);
            List<BlockPos> listed = this.getValidList(pedestal);
            if (override && pedestal.hasItem()) {
                if (listed.size() > 0) {
                    this.planterAction(level, pedestal);
                } else if (workCardBase.selectedAreaWithinRange(pedestal) && !this.hasBlockListCustomNBTTags(coin, "_validlist")) {
                    this.buildValidBlockListArea(pedestal);
                }
            } else {
                List<BlockPos> getList = WorkCardBase.readBlockPosListFromNBT(card);
                if (!override && listed.size() > 0) {
                    this.planterAction(level, pedestal);
                } else if (getList.size() > 0 && !this.hasBlockListCustomNBTTags(coin, "_validlist")) {
                    BlockPos hasValidPos = IntStream.range(0, getList.size()).mapToObj(getList::get).filter(blockPos -> this.selectedPointWithinRange(pedestal, (BlockPos)blockPos)).findFirst().orElse(BlockPos.f_121853_);
                    if (!hasValidPos.equals((Object)BlockPos.f_121853_)) {
                        this.buildValidBlockList(pedestal);
                    }
                }
            }
        }
    }

    private int getCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private void iterateCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentPosition(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1), (String)"_numposition");
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, BlockState canMineBlock, BlockPos canMinePos) {
        ItemStack blockToCheck;
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInPedestal()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral() && Block.m_49814_((Item)(blockToCheck = pedestal.getItemInPedestal()).m_41720_()) != Blocks.f_50016_) {
            return filter.canAcceptItems(filterInPedestal, blockToCheck);
        }
        return true;
    }

    private boolean canPlace(BasePedestalBlockEntity pedestal) {
        ItemStack getPlaceItem = pedestal.getItemInPedestal();
        Block possibleBlock = Block.m_49814_((Item)getPlaceItem.m_41720_());
        if (possibleBlock != Blocks.f_50016_) {
            return !ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_place"))).stream().toList().contains(getPlaceItem) && possibleBlock instanceof IPlantable && (possibleBlock instanceof BushBlock || possibleBlock instanceof StemBlock || possibleBlock instanceof BonemealableBlock || possibleBlock instanceof ChorusFlowerBlock);
        }
        return false;
    }

    public BlockState getState(Block getBlock, ItemStack itemForBlock) {
        BlockState stated = Blocks.f_50016_.m_49966_();
        stated = itemForBlock.m_41720_() == Items.f_42451_ ? Blocks.f_50088_.m_49966_() : getBlock.m_49966_();
        return stated;
    }

    private BlockPos getPosBasedOnPedestalDirection(BasePedestalBlockEntity pedestalBlockEntity, BlockPos pos) {
        Direction ofPedestal = this.getPedestalFacing(pedestalBlockEntity.m_58904_(), pedestalBlockEntity.getPos());
        switch (ofPedestal) {
            case UP: {
                return pos.m_7495_();
            }
            case DOWN: {
                return pos.m_7494_();
            }
            case NORTH: {
                return pos.m_122019_();
            }
            case EAST: {
                return pos.m_122024_();
            }
            case SOUTH: {
                return pos.m_122012_();
            }
            case WEST: {
                return pos.m_122029_();
            }
        }
        return pos.m_7495_();
    }

    public void planterAction(Level level, BasePedestalBlockEntity pedestal) {
        WeakReference<FakePlayer> getPlayer;
        if (!level.m_5776_() && (getPlayer = pedestal.getPedestalPlayer(pedestal)) != null && getPlayer.get() != null) {
            if (this.hasSuperSpeed(pedestal.getCoinOnPedestal())) {
                List<BlockPos> listed = this.getValidList(pedestal);
                for (BlockPos currentPoint : listed) {
                    UseOnContext blockContext;
                    InteractionResult result;
                    BlockState blockAtPoint = level.m_8055_(currentPoint);
                    if (!this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), currentPoint), true) || pedestal.removeItem(1, true).m_41619_() || !this.canPlace(pedestal) || !this.passesFilter(pedestal, blockAtPoint, currentPoint) || pedestal.removeItem(1, true).m_41619_() || currentPoint.equals((Object)pedestal.getPos()) || !level.m_8055_(this.getPedestalFacing(level, pedestal.getPos()) == Direction.DOWN ? currentPoint.m_7494_() : currentPoint.m_7495_()).canSustainPlant((BlockGetter)level, this.getPosBasedOnPedestalDirection(pedestal, currentPoint), this.getPedestalFacing(level, pedestal.getPos()), (IPlantable)Block.m_49814_((Item)pedestal.getItemInPedestal().m_41720_())) || !this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), currentPoint), false) || (result = ForgeHooks.onPlaceItemIntoWorld((UseOnContext)(blockContext = new UseOnContext(level, getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get(), InteractionHand.MAIN_HAND, pedestal.getItemInPedestal().m_41777_(), new BlockHitResult(Vec3.f_82478_, this.getPedestalFacing(level, pedestal.getPos()), currentPoint, false))))) != InteractionResult.CONSUME) continue;
                    if (pedestal.canSpawnParticles()) {
                        MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)currentPoint.m_123341_() + 0.5, (double)currentPoint.m_123342_() + 0.5, (double)currentPoint.m_123343_() + 0.5, new int[]{100, 255, 100}));
                    }
                    pedestal.removeItem(1, false);
                }
            } else {
                List<BlockPos> listed = this.getValidList(pedestal);
                int currentPosition = this.getCurrentPosition(pedestal);
                BlockPos currentPoint = listed.get(currentPosition);
                BlockState blockAtPoint = level.m_8055_(currentPoint);
                boolean fuelRemoved = true;
                if (this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), currentPoint), true) && !pedestal.removeItem(1, true).m_41619_()) {
                    if (this.canPlace(pedestal) && this.passesFilter(pedestal, blockAtPoint, currentPoint) && !pedestal.removeItem(1, true).m_41619_() && !currentPoint.equals((Object)pedestal.getPos()) && level.m_8055_(this.getPedestalFacing(level, pedestal.getPos()) == Direction.DOWN ? currentPoint.m_7494_() : currentPoint.m_7495_()).canSustainPlant((BlockGetter)level, this.getPosBasedOnPedestalDirection(pedestal, currentPoint), this.getPedestalFacing(level, pedestal.getPos()), (IPlantable)Block.m_49814_((Item)pedestal.getItemInPedestal().m_41720_()))) {
                        if (this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), currentPoint), false)) {
                            UseOnContext blockContext = new UseOnContext(level, getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get(), InteractionHand.MAIN_HAND, pedestal.getItemInPedestal().m_41777_(), new BlockHitResult(Vec3.f_82478_, this.getPedestalFacing(level, pedestal.getPos()), currentPoint, false));
                            InteractionResult result = ForgeHooks.onPlaceItemIntoWorld((UseOnContext)blockContext);
                            if (result == InteractionResult.CONSUME) {
                                if (pedestal.canSpawnParticles()) {
                                    MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)currentPoint.m_123341_() + 0.5, (double)currentPoint.m_123342_() + 0.5, (double)currentPoint.m_123343_() + 0.5, new int[]{100, 255, 100}));
                                }
                                pedestal.removeItem(1, false);
                            }
                        } else {
                            fuelRemoved = false;
                        }
                    }
                    if (currentPosition + 1 >= listed.size()) {
                        this.setCurrentPosition(pedestal, 0);
                    } else if (fuelRemoved) {
                        this.iterateCurrentPosition(pedestal);
                    }
                }
            }
        }
    }
}

