/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlock;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardBase;
import com.mowmaster.pedestals.Recipes.UpgradeModificationGlobalRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ItemUpgradeModifications
extends ItemUpgradeBase {
    public ItemUpgradeModifications(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean selectedPointWithinRange(BasePedestalBlockEntity pedestal, BlockPos posPoint) {
        Level level;
        return this.isSelectionInRange(pedestal, posPoint) && (level = pedestal.m_58904_()).m_8055_(posPoint).m_60734_() instanceof BasePedestalBlock;
    }

    @Override
    public boolean needsWorkCard() {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 3;
    }

    private void buildValidBlockList(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        Level level = pedestal.m_58904_();
        ItemStack coin = pedestal.getCoinOnPedestal();
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            List<BlockPos> listed = WorkCardBase.readBlockPosListFromNBT(card);
            for (BlockPos pos : listed) {
                if (!this.selectedPointWithinRange(pedestal, pos) || !(level.m_8055_(pos).m_60734_() instanceof BasePedestalBlock)) continue;
                valid.add(pos);
            }
        }
        ItemUpgradeModifications.saveBlockPosListCustomToNBT(coin, "_validlist", valid);
    }

    private List<BlockPos> getValidList(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return ItemUpgradeModifications.readBlockPosListCustomFromNBT(coin, "_validlist");
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.removeBlockListCustomNBTTags(coinInPedestal, "_validlist");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        ItemStack card;
        Item item;
        List<BlockPos> listed = this.getValidList(pedestal);
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            List<BlockPos> getList = WorkCardBase.readBlockPosListFromNBT(card);
            if (listed.size() > 0) {
                this.modifierAction(level, pedestal);
            } else if (getList.size() > 0 && !this.hasBlockListCustomNBTTags(coin, "_validlist")) {
                this.buildValidBlockList(pedestal);
            }
        }
    }

    @Nullable
    protected UpgradeModificationGlobalRecipe getModificationGlobalRecipe(BasePedestalBlockEntity pedestal, ItemStack upgradeIn, List<ItemStack> ingredientStacks) {
        Level level = pedestal.m_58904_();
        int conSize = 1;
        for (int i = 0; i < ingredientStacks.size(); ++i) {
            if (ingredientStacks.get(i).m_41619_()) continue;
            ++conSize;
        }
        Container cont = MowLibContainerUtils.getContainer((int)conSize);
        cont.m_6836_(-1, upgradeIn);
        for (int i = 0; i < ingredientStacks.size(); ++i) {
            if (ingredientStacks.get(i).m_41619_()) continue;
            cont.m_6836_(-1, ingredientStacks.get(i));
        }
        if (level == null) {
            return null;
        }
        RecipeManager recipeManager = level.m_7465_();
        Optional optional = recipeManager.m_44015_((RecipeType)UpgradeModificationGlobalRecipe.Type.INSTANCE, cont, level);
        if (optional.isPresent()) {
            return optional.orElse(null);
        }
        return null;
    }

    protected boolean upgradeModifiedSuccessfully(UpgradeModificationGlobalRecipe recipe, ItemStack upgradeInput, boolean simulate) {
        return recipe == null ? false : recipe.getResultingModifiedItem(upgradeInput, simulate);
    }

    public void modifierAction(Level level, BasePedestalBlockEntity pedestal) {
        if (!level.m_5776_()) {
            boolean fullstop = false;
            List<BlockPos> listed = this.getValidList(pedestal);
            ArrayList<ItemStack> ingredientList = new ArrayList<ItemStack>();
            for (int i = 0; i < listed.size(); ++i) {
                BlockEntity invToCheck = level.m_7702_(listed.get(i));
                if (invToCheck == null) {
                    fullstop = true;
                    break;
                }
                if (!(invToCheck instanceof BasePedestalBlockEntity)) continue;
                BasePedestalBlockEntity pedestalToCheck = (BasePedestalBlockEntity)invToCheck;
                ingredientList.add(pedestalToCheck.getItemInPedestal());
            }
            if (!fullstop) {
                BlockPos posInventory = this.getPosOfBlockBelow(level, pedestal.getPos(), 1);
                ItemStack upgradeItemStackInput = ItemStack.f_41583_;
                LazyOptional cap = MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestal.getPos()), (boolean)true);
                if (!this.isInventoryEmpty((LazyOptional<IItemHandler>)cap) && cap.isPresent()) {
                    int i;
                    IItemHandler handler = (IItemHandler)cap.orElse(null);
                    BlockEntity invToPullFrom = level.m_7702_(posInventory);
                    if (invToPullFrom instanceof BasePedestalBlockEntity) {
                        upgradeItemStackInput = ItemStack.f_41583_;
                    } else if (handler != null && (i = this.getNextSlotWithItemsCapFiltered(pedestal, (LazyOptional<IItemHandler>)cap)) >= 0) {
                        upgradeItemStackInput = handler.getStackInSlot(i);
                        ItemStack copyIncoming = upgradeItemStackInput.m_41777_();
                        copyIncoming.m_41764_(1);
                        if (pedestal.addItem(upgradeItemStackInput, true)) {
                            UpgradeModificationGlobalRecipe recipeGlobal = this.getModificationGlobalRecipe(pedestal, copyIncoming, ingredientList);
                            if (recipeGlobal != null) {
                                if (this.upgradeModifiedSuccessfully(recipeGlobal, copyIncoming, true)) {
                                    if (!handler.extractItem(i, 1, true).m_41619_()) {
                                        if (pedestal.addItem(copyIncoming, true)) {
                                            for (int j = 0; j < listed.size(); ++j) {
                                                BasePedestalBlockEntity pedestalToCheck;
                                                BlockEntity invToCheck = level.m_7702_(listed.get(j));
                                                if (invToCheck == null) {
                                                    fullstop = true;
                                                    break;
                                                }
                                                if (!(invToCheck instanceof BasePedestalBlockEntity) || (pedestalToCheck = (BasePedestalBlockEntity)invToCheck).removeItem(1, true).m_41619_()) continue;
                                                pedestalToCheck.removeItem(1, false);
                                                BlockPos pedestalToCheckPoint = this.getPosOfBlockBelow(level, pedestalToCheck.getPos(), -1);
                                                if (!pedestal.canSpawnParticles()) continue;
                                                MowLibPacketHandler.sendToNearby((Level)pedestalToCheck.m_58904_(), (BlockPos)pedestalToCheck.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalToCheckPoint.m_123341_(), (double)pedestalToCheckPoint.m_123342_(), (double)pedestalToCheckPoint.m_123343_(), new int[]{50, 200, 0}));
                                            }
                                            if (!fullstop) {
                                                handler.extractItem(i, 1, false);
                                                this.upgradeModifiedSuccessfully(recipeGlobal, copyIncoming, false);
                                                pedestal.addItem(copyIncoming, false);
                                                BlockPos pedestalToCheckPoint = this.getPosOfBlockBelow(level, pedestal.getPos(), -1);
                                                if (pedestal.canSpawnParticles()) {
                                                    MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalToCheckPoint.m_123341_(), (double)pedestalToCheckPoint.m_123342_(), (double)pedestalToCheckPoint.m_123343_(), new int[]{0, 255, 0}));
                                                }
                                            }
                                        } else {
                                            BlockPos pedestalToCheckPoint = this.getPosOfBlockBelow(level, pedestal.getPos(), -1);
                                            if (pedestal.canSpawnParticles()) {
                                                MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalToCheckPoint.m_123341_(), (double)pedestalToCheckPoint.m_123342_(), (double)pedestalToCheckPoint.m_123343_(), new int[]{50, 50, 50}));
                                            }
                                        }
                                    }
                                } else {
                                    BlockPos pedestalToCheckPoint = this.getPosOfBlockBelow(level, pedestal.getPos(), -1);
                                    if (pedestal.canSpawnParticles()) {
                                        MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalToCheckPoint.m_123341_(), (double)pedestalToCheckPoint.m_123342_(), (double)pedestalToCheckPoint.m_123343_(), new int[]{50, 50, 50}));
                                    }
                                }
                            } else {
                                BlockPos pedestalToCheckPoint = this.getPosOfBlockBelow(level, pedestal.getPos(), -1);
                                if (pedestal.canSpawnParticles()) {
                                    MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalToCheckPoint.m_123341_(), (double)pedestalToCheckPoint.m_123342_(), (double)pedestalToCheckPoint.m_123343_(), new int[]{50, 50, 50}));
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

