/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardBase;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeMilker
extends ItemUpgradeBase {
    public ItemUpgradeMilker(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifySuperSpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard() {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_milker_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_milker_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_milker_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_milker_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_milker_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_milker_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_milker_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_milker_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_milker_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_milker_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_milker_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_milker_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        return new ItemStack((ItemLike)Items.f_42446_);
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        WorkCardBase workCardBase;
        ItemStack card;
        Item item;
        if (level.m_5776_()) {
            return;
        }
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase && (workCardBase = (WorkCardBase)item).hasTwoPointsSelected(card) && workCardBase.selectedAreaWithinRange(pedestal)) {
            WeakReference<FakePlayer> getPlayer;
            boolean canRun = true;
            Fluid getFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation("minecraft:milk"));
            if (getFluid != null && pedestal.spaceForFluid() < 1000) {
                return;
            }
            if ((getFluid == null || getFluid.m_76145_().m_76178_()) && pedestal.getItemInPedestal().m_41619_()) {
                return;
            }
            if (this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), pedestalPos), true) && (getPlayer = pedestal.getPedestalPlayer(pedestal)) != null && getPlayer.get() != null) {
                AABB getArea = workCardBase.getAABBonUpgrade(card);
                List entities = level.m_45976_(LivingEntity.class, getArea);
                ItemStack toolStack = pedestal.hasItem() ? pedestal.getItemInPedestal().m_41777_() : pedestal.getToolStack();
                ItemUpgradeMilker.tryEquipItem(toolStack, getPlayer, InteractionHand.MAIN_HAND);
                if (canRun) {
                    block0: for (LivingEntity getEntity : entities) {
                        Animal animal;
                        InteractionResult result;
                        if (getEntity == null) continue;
                        BlockPos getEntityPos = getEntity.m_20097_();
                        if (!(getEntity instanceof Animal) || (result = (animal = (Animal)getEntity).m_6071_(getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get(), InteractionHand.MAIN_HAND)) != InteractionResult.CONSUME) continue;
                        NonNullList getItemsInPlayer = ((FakePlayer)getPlayer.get()).m_150109_().f_35974_;
                        for (int i = 0; i < getItemsInPlayer.size(); ++i) {
                            BucketItem bucket;
                            Item getFluidStack;
                            ItemStack stackInPlayer = (ItemStack)getItemsInPlayer.get(i);
                            if (stackInPlayer.m_41619_() || toolStack.m_41720_().equals(stackInPlayer.m_41720_()) || !this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), getEntityPos), false)) continue;
                            if (stackInPlayer.m_41720_().equals(Items.f_42455_)) {
                                if (getFluid != null && pedestal.getItemInPedestal().m_41619_()) {
                                    getFluidStack = new FluidStack(getFluid, 1000);
                                    if (pedestal.addFluid((FluidStack)getFluidStack, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                                    pedestal.addFluid((FluidStack)getFluidStack, IFluidHandler.FluidAction.EXECUTE);
                                    if (this.hasAdvancedOne(coin)) continue;
                                    continue block0;
                                }
                                if (pedestal.removeItem(1, true).m_41619_()) continue;
                                pedestal.removeItem(1, false);
                                MowLibItemUtils.spawnItemStack((Level)level, (double)getEntityPos.m_123341_(), (double)getEntityPos.m_123342_(), (double)getEntityPos.m_123343_(), (ItemStack)stackInPlayer);
                                if (this.hasAdvancedOne(coin)) continue;
                                continue block0;
                            }
                            getFluidStack = stackInPlayer.m_41720_();
                            if (!(getFluidStack instanceof BucketItem) || (bucket = (BucketItem)getFluidStack).getFluid().equals(Fluids.f_76191_) || pedestal.addFluid((FluidStack)(getFluidStack = new FluidStack(bucket.getFluid(), 1000)), IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                            pedestal.addFluid((FluidStack)getFluidStack, IFluidHandler.FluidAction.EXECUTE);
                            if (!this.hasAdvancedOne(coin)) continue block0;
                        }
                    }
                }
            }
        }
    }
}

