/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Recipes.CobbleGenRecipe;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class ItemUpgradeMaterialGenerator
extends ItemUpgradeBase {
    public ItemUpgradeMaterialGenerator(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyItemCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        return new ItemStack((ItemLike)Items.f_42427_);
    }

    public int getCobbleGenSpawnRate(ItemStack upgradeStack) {
        if (this.getItemCapacityIncrease(upgradeStack) > 0) {
            return this.getItemCapacityIncrease(upgradeStack);
        }
        return 1;
    }

    @Nullable
    public CobbleGenRecipe getRecipe(Level level, ItemStack stackIn) {
        Container cont = MowLibContainerUtils.getContainer((int)1);
        cont.m_6836_(-1, stackIn);
        List recipes = level.m_7465_().m_44056_((RecipeType)CobbleGenRecipe.Type.INSTANCE, cont, level);
        return recipes.size() > 0 ? (CobbleGenRecipe)level.m_7465_().m_44056_((RecipeType)CobbleGenRecipe.Type.INSTANCE, cont, level).get(0) : null;
    }

    protected Collection<ItemStack> getGeneratedItem(CobbleGenRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.f_41583_) : Collections.singleton(recipe.m_8043_());
    }

    protected int getEnergyRequiredForGeneration(CobbleGenRecipe recipe) {
        return recipe == null ? 0 : recipe.getResultEnergyNeeded();
    }

    protected int getExperienceRequiredForGeneration(CobbleGenRecipe recipe) {
        return recipe == null ? 0 : recipe.getResultExperienceNeeded();
    }

    protected FluidStack getFluidRequiredForGeneration(CobbleGenRecipe recipe) {
        return recipe == null ? FluidStack.EMPTY : recipe.getResultFluidNeeded();
    }

    protected DustMagic getDustRequiredForGeneration(CobbleGenRecipe recipe) {
        return recipe == null ? DustMagic.EMPTY : recipe.getResultDustNeeded();
    }

    public List<ItemStack> getItemToGenerate(BasePedestalBlockEntity pedestal, CobbleGenRecipe recipe) {
        ItemStack getInitialGeneratedItem = ItemStack.f_41583_;
        Level level = pedestal.m_58904_();
        if (recipe == null) {
            return new ArrayList<ItemStack>();
        }
        getInitialGeneratedItem = this.getGeneratedItem(recipe).stream().findFirst().get();
        Block generatedBlock = Block.m_49814_((Item)getInitialGeneratedItem.m_41720_());
        if (generatedBlock != Blocks.f_50016_) {
            ItemStack getToolFromPedestal = pedestal.getToolStack().m_41619_() ? this.getUpgradeDefaultTool() : pedestal.getToolStack();
            WeakReference<FakePlayer> getPlayer = pedestal.getPedestalPlayer(pedestal);
            if (getPlayer != null && getPlayer.get() != null) {
                LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_())).m_78972_(LootContextParams.f_81455_, (Object)((Entity)getPlayer.get())).m_78972_(LootContextParams.f_81463_, (Object)getToolFromPedestal);
                return generatedBlock.m_49966_().m_60734_().m_7381_(generatedBlock.m_49966_(), builder);
            }
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)getToolFromPedestal);
            return generatedBlock.m_49966_().m_60734_().m_7381_(generatedBlock.m_49966_(), builder);
        }
        return new ArrayList<ItemStack>();
    }

    public ItemStack getItemStackToGenerate(BasePedestalBlockEntity pedestal, CobbleGenRecipe recipe) {
        ItemStack getInitialGeneratedItem = ItemStack.f_41583_;
        Level level = pedestal.m_58904_();
        if (recipe == null) {
            return ItemStack.f_41583_;
        }
        getInitialGeneratedItem = this.getGeneratedItem(recipe).stream().findFirst().get();
        return getInitialGeneratedItem;
    }

    public List<ItemStack> getItemsToGenerate(BasePedestalBlockEntity pedestal, ItemStack blockToBreak) {
        Level level = pedestal.m_58904_();
        Block generatedBlock = Block.m_49814_((Item)blockToBreak.m_41720_());
        if (generatedBlock != Blocks.f_50016_) {
            ItemStack getToolFromPedestal = pedestal.getToolStack().m_41619_() ? new ItemStack((ItemLike)Items.f_42427_) : pedestal.getToolStack();
            WeakReference<FakePlayer> getPlayer = pedestal.getPedestalPlayer(pedestal);
            if (getPlayer != null && getPlayer.get() != null) {
                LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_())).m_78984_(LootContextParams.f_81455_, (Object)((Entity)getPlayer.get())).m_78972_(LootContextParams.f_81463_, (Object)getToolFromPedestal);
                return generatedBlock.m_49966_().m_60724_(builder);
            }
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)getToolFromPedestal);
            return generatedBlock.m_49966_().m_60724_(builder);
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    public void actionOnNeighborBelowChange(BasePedestalBlockEntity pedestal, BlockPos belowBlock) {
        CobbleGenRecipe recipe = this.getRecipe(pedestal.m_58904_(), new ItemStack((ItemLike)pedestal.m_58904_().m_8055_(belowBlock).m_60734_().m_5456_()));
        ItemStack getOutput = this.getItemStackToGenerate(pedestal, recipe);
        ArrayList<ItemStack> getStackList = new ArrayList<ItemStack>();
        getStackList.add(getOutput);
        int getEnergyNeeded = this.getEnergyRequiredForGeneration(recipe);
        int getExperienceNeeded = this.getExperienceRequiredForGeneration(recipe);
        FluidStack getFluidStackNeeded = this.getFluidRequiredForGeneration(recipe);
        DustMagic getDustNeeded = this.getDustRequiredForGeneration(recipe);
        CompoundTag tagCoin = new CompoundTag();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        if (coinInPedestal.m_41782_()) {
            tagCoin = coinInPedestal.m_41783_();
        }
        tagCoin = MowLibCompoundTagUtils.writeItemStackListToNBT((String)"pedestals", (CompoundTag)tagCoin, getStackList, (String)"_stackList");
        tagCoin = MowLibCompoundTagUtils.writeFluidStackToNBT((String)"pedestals", (CompoundTag)tagCoin, (FluidStack)getFluidStackNeeded, (String)"_fluidStack");
        tagCoin = MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)tagCoin, (int)getEnergyNeeded, (String)"_energyNeeded");
        tagCoin = MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)tagCoin, (int)getExperienceNeeded, (String)"_xpNeeded");
        DustMagic.setDustMagicInTag((CompoundTag)coinInPedestal.m_41783_(), (DustMagic)getDustNeeded);
        coinInPedestal.m_41751_(tagCoin);
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_stackList");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_fluidStack");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_energyNeeded");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_xpNeeded");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"mowlib", (CompoundTag)coinInPedestal.m_41783_(), (String)"_dustMagicColor");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"mowlib", (CompoundTag)coinInPedestal.m_41783_(), (String)"_dustMagicAmount");
    }

    private boolean needsFuel(FluidStack getFluidStackNeeded, int getEnergyNeeded, int getExperienceNeeded, DustMagic getDustNeeded) {
        if (!getFluidStackNeeded.isEmpty()) {
            return true;
        }
        if (getEnergyNeeded > 0) {
            return true;
        }
        if (getExperienceNeeded > 0) {
            return true;
        }
        return !getDustNeeded.isEmpty();
    }

    private boolean hasEnoughFuel(BasePedestalBlockEntity pedestal, FluidStack getFluidStackNeeded, int getEnergyNeeded, int getExperienceNeeded, DustMagic getDustNeeded, boolean toolDamage, int modifier) {
        int increase;
        FluidStack pedestalsFluid = pedestal.getStoredFluid();
        int pedestalEnergy = pedestal.getStoredEnergy();
        int pedestalExperience = pedestal.getStoredExperience();
        DustMagic pedestalDust = pedestal.getStoredDust();
        if (!getFluidStackNeeded.isEmpty()) {
            increase = getFluidStackNeeded.getAmount() * modifier;
            if (pedestalsFluid.getAmount() < increase) {
                return false;
            }
        }
        if (getEnergyNeeded > 0 && pedestalEnergy < (increase = pedestalEnergy * modifier)) {
            return false;
        }
        if (getExperienceNeeded > 0 && pedestalExperience < (increase = pedestalExperience * modifier)) {
            return false;
        }
        if (!getDustNeeded.isEmpty()) {
            increase = pedestalDust.getDustAmount() * modifier;
            if (pedestalDust.getDustAmount() < increase) {
                return false;
            }
        }
        return !toolDamage || pedestal.damageInsertedTool(increase = modifier, true);
    }

    private boolean removeFuel(BasePedestalBlockEntity pedestal, FluidStack getFluidStackNeeded, int getEnergyNeeded, int getExperienceNeeded, DustMagic getDustNeeded, boolean toolDamage, int modifier) {
        boolean returner = false;
        boolean needsFuel = this.needsFuel(getFluidStackNeeded, getEnergyNeeded, getExperienceNeeded, getDustNeeded);
        FluidStack neededFluid = getFluidStackNeeded.copy();
        int neededEnergy = getEnergyNeeded;
        int neededExperience = getExperienceNeeded;
        DustMagic neededDust = getDustNeeded.copy();
        if (needsFuel) {
            if (this.hasEnoughFuel(pedestal, getFluidStackNeeded, getEnergyNeeded, getExperienceNeeded, getDustNeeded, toolDamage, modifier)) {
                int increase;
                if (!neededFluid.isEmpty()) {
                    increase = neededFluid.getAmount() * modifier;
                    neededFluid.setAmount(increase);
                    if (pedestal.removeFluid(neededFluid, IFluidHandler.FluidAction.SIMULATE).equals((Object)neededFluid)) {
                        returner = true;
                        pedestal.removeFluid(neededFluid, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if (neededEnergy > 0 && pedestal.removeEnergy(increase = neededEnergy * modifier, true) > 0) {
                    returner = true;
                    pedestal.removeEnergy(increase, false);
                }
                if (neededExperience > 0 && pedestal.removeExperience(increase = neededExperience * modifier, true) > 0) {
                    returner = true;
                    pedestal.removeExperience(increase, false);
                }
                if (!neededDust.isEmpty()) {
                    increase = neededDust.getDustAmount() * modifier;
                    neededDust.setDustAmount(increase);
                    if (pedestal.removeDust(neededDust, IDustHandler.DustAction.SIMULATE).equals((Object)neededDust)) {
                        returner = true;
                        pedestal.removeDust(neededDust, IDustHandler.DustAction.EXECUTE);
                    }
                }
                if (toolDamage) {
                    increase = modifier;
                    pedestal.damageInsertedTool(increase, false);
                    returner = true;
                }
            }
        } else {
            returner = true;
        }
        return returner;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        boolean damage;
        boolean needsFuel;
        DustMagic getDustNeeded;
        int getExperienceNeeded;
        int getEnergyNeeded;
        FluidStack getFluidStackNeeded;
        List<ItemStack> getCobbleGenOutputs;
        ItemStack getCobbleGenOutput;
        BlockPos posBelow = this.getPosOfBlockBelow(level, pedestalPos, 1);
        int modifier = this.getCobbleGenSpawnRate(coin);
        if (MowLibCompoundTagUtils.readItemStackListFromNBT((String)"pedestals", (CompoundTag)coin.m_41783_(), (String)"_stackList") == null) {
            this.actionOnNeighborBelowChange(pedestal, posBelow);
        }
        if (!(getCobbleGenOutput = (ItemStack)MowLibCompoundTagUtils.readItemStackListFromNBT((String)"pedestals", (CompoundTag)coin.m_41783_(), (String)"_stackList").get(0)).m_41619_()) {
            block15: {
                getCobbleGenOutputs = this.getItemsToGenerate(pedestal, getCobbleGenOutput);
                getFluidStackNeeded = MowLibCompoundTagUtils.readFluidStackFromNBT((String)"pedestals", (CompoundTag)coin.m_41783_(), (String)"_fluidStack");
                getEnergyNeeded = MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41783_(), (String)"_energyNeeded");
                getExperienceNeeded = MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41783_(), (String)"_xpNeeded");
                getDustNeeded = DustMagic.getDustMagicInTag((CompoundTag)coin.m_41783_());
                needsFuel = this.needsFuel(getFluidStackNeeded, getEnergyNeeded, getExperienceNeeded, getDustNeeded);
                damage = false;
                if (((Boolean)PedestalConfig.COMMON.cobbleGeneratorDamageTools.get()).booleanValue() && pedestal.hasTool()) {
                    if (pedestal.getDurabilityRemainingOnInsertedTool() > 0) {
                        if (pedestal.damageInsertedTool(1, true)) {
                            damage = true;
                            break block15;
                        } else {
                            if (!pedestal.canSpawnParticles()) return;
                            MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                            return;
                        }
                    }
                    if (!pedestal.canSpawnParticles()) return;
                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                    return;
                }
            }
            if (getCobbleGenOutputs.size() <= 0) {
                return;
            }
            if (getCobbleGenOutputs.size() <= 0) return;
            boolean itemsInserted = false;
        } else {
            if (!pedestal.canSpawnParticles()) return;
            MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_(), new int[]{50, 50, 50}));
            return;
        }
        for (int i = 0; i < getCobbleGenOutputs.size(); ++i) {
            ItemStack testStack;
            ItemStack stacked;
            boolean hadSpacePreModifier;
            if (getCobbleGenOutputs.get(i).m_41619_() || !(hadSpacePreModifier = pedestal.hasSpaceForItem(stacked = getCobbleGenOutputs.get(i)))) continue;
            ItemStack stackedCopy = stacked.m_41777_();
            int modifierAmount = stacked.m_41613_() * modifier;
            if (modifier > 1) {
                stackedCopy.m_41764_(modifierAmount);
            }
            if ((testStack = pedestal.addItemStack(stackedCopy, true)).m_41619_()) {
                if (needsFuel) {
                    if (!this.hasEnoughFuel(pedestal, getFluidStackNeeded, getEnergyNeeded, getExperienceNeeded, getDustNeeded, damage, modifier) || !this.removeFuel(pedestal, getFluidStackNeeded, getEnergyNeeded, getExperienceNeeded, getDustNeeded, damage, modifier)) continue;
                    pedestal.addItem(stackedCopy, false);
                    continue;
                }
                pedestal.addItem(stackedCopy, false);
                continue;
            }
            if (testStack.m_41613_() <= 0) continue;
            stackedCopy.m_41774_(testStack.m_41613_());
            if (needsFuel) {
                if (!this.hasEnoughFuel(pedestal, getFluidStackNeeded, getEnergyNeeded, getExperienceNeeded, getDustNeeded, damage, modifier) || !this.removeFuel(pedestal, getFluidStackNeeded, getEnergyNeeded, getExperienceNeeded, getDustNeeded, damage, modifier)) continue;
                pedestal.addItem(stackedCopy, false);
                continue;
            }
            pedestal.addItem(stackedCopy, false);
        }
    }
}

