/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.Capabilities.Experience.IExperienceStorage;
import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.MowLibUtils.MowLibDustUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibEnergyUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibFluidUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibXpUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemUpgradeImport
extends ItemUpgradeBase
implements IHasModeTypes {
    public ItemUpgradeImport(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyItemCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyFluidCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyEnergyCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyXPCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyDustCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyEntityContainers(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    public static LazyOptional<IItemHandler> findItemHandlerAtPosEntity(Level world, BlockPos pos, Direction side, boolean allowEntity) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        BlockEntity neighbourTile = world.m_7702_(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(ForgeCapabilities.ITEM_HANDLER, side)).isPresent()) {
            return cap2;
        }
        if (allowEntity && !(list = world.m_6443_(Entity.class, new AABB(pos), entity -> entity instanceof Entity)).isEmpty() && (cap = ((Entity)list.get(world.f_46441_.m_188503_(list.size()))).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        IDustHandler handler;
        LazyOptional cap;
        int baseRate;
        BlockPos posInventory = this.getPosOfBlockBelow(level, pedestalPos, 1);
        if (this.canTransferItems(coin)) {
            int baseRate2 = (Integer)PedestalConfig.COMMON.upgrade_import_baseItemTransferSpeed.get();
            int transferRate = baseRate2 + this.getItemCapacityIncrease(pedestal.getCoinOnPedestal());
            ItemStack itemFromInv = ItemStack.f_41583_;
            LazyOptional<IItemHandler> cap2 = MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true);
            if (this.hasEntityContainer(coin)) {
                cap2 = ItemUpgradeImport.findItemHandlerAtPosEntity(level, posInventory, this.getPedestalFacing(level, pedestalPos), true);
            }
            if (!this.isInventoryEmpty(cap2) && cap2.isPresent()) {
                int i;
                IItemHandler handler2 = (IItemHandler)cap2.orElse(null);
                BlockEntity invToPullFrom = level.m_7702_(posInventory);
                if (invToPullFrom instanceof BasePedestalBlockEntity) {
                    itemFromInv = ItemStack.f_41583_;
                } else if (handler2 != null && (i = this.getNextSlotWithItemsCapFiltered(pedestal, cap2)) >= 0) {
                    int maxStackSizeAllowedInPedestal = 0;
                    int roomLeftInPedestal = 0;
                    itemFromInv = handler2.getStackInSlot(i);
                    ItemStack copyIncoming = itemFromInv.m_41777_();
                    ItemStack itemFromPedestal = pedestal.getMatchingItemInPedestalOrEmptySlot(copyIncoming);
                    if (itemFromInv != null && !itemFromInv.m_41619_() && itemFromInv.m_41720_() != Items.f_41852_) {
                        maxStackSizeAllowedInPedestal = itemFromPedestal.m_41619_() || itemFromPedestal.equals(ItemStack.f_41583_) ? 64 : itemFromPedestal.m_41741_();
                        roomLeftInPedestal = maxStackSizeAllowedInPedestal - itemFromPedestal.m_41613_();
                        int itemCountInInv = itemFromInv.m_41613_();
                        int allowedTransferRate = transferRate;
                        if (roomLeftInPedestal < transferRate) {
                            allowedTransferRate = roomLeftInPedestal;
                        }
                        if (itemCountInInv < allowedTransferRate) {
                            allowedTransferRate = itemCountInInv;
                        }
                        copyIncoming.m_41764_(allowedTransferRate);
                        if (!handler2.extractItem(i, allowedTransferRate, true).m_41619_() && pedestal.addItem(copyIncoming, true)) {
                            handler2.extractItem(i, allowedTransferRate, false);
                            pedestal.addItem(copyIncoming, false);
                        }
                    }
                }
            }
        }
        if (this.canTransferFluids(coin)) {
            IFluidHandler handler3;
            LazyOptional<IFluidHandler> cap3 = MowLibFluidUtils.findFluidHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true);
            if (this.hasEntityContainer(coin)) {
                cap3 = ItemUpgradeImport.findItemHandlerAtPosEntityFluid(level, posInventory, this.getPedestalFacing(level, pedestalPos), true);
            }
            if (cap3.isPresent() && (handler3 = (IFluidHandler)cap3.orElse(null)) != null) {
                int tanks = handler3.getTanks();
                FluidStack fluidCheckedMatching = FluidStack.EMPTY;
                fluidCheckedMatching = IntStream.range(0, tanks).mapToObj(arg_0 -> ((IFluidHandler)handler3).getFluidInTank(arg_0)).filter(fluidStack -> !fluidStack.isEmpty()).findFirst().orElse(FluidStack.EMPTY);
                if (!fluidCheckedMatching.isEmpty()) {
                    FluidStack fluidInPedestal = pedestal.getStoredFluid();
                    int fluidSpaceInPedestal = pedestal.spaceForFluid();
                    if (tanks > 1) {
                        if (!fluidInPedestal.isEmpty()) {
                            FluidStack fluidInTank = handler3.getFluidInTank(0);
                            amountIn = fluidInTank.getAmount();
                            baseRate = (Integer)PedestalConfig.COMMON.upgrade_import_baseFluidTransferSpeed.get();
                            int rate = baseRate + this.getFluidCapacityIncrease(pedestal.getCoinOnPedestal());
                            int actualCoinRate = fluidSpaceInPedestal >= rate ? rate : fluidSpaceInPedestal;
                            int n = transferRate = amountIn >= actualCoinRate ? actualCoinRate : amountIn;
                            if (fluidSpaceInPedestal >= transferRate || pedestal.getStoredFluid().isEmpty()) {
                                FluidStack estFluidToDrain = fluidInTank.copy();
                                estFluidToDrain.setAmount(transferRate);
                                FluidStack fluidToActuallyDrain = handler3.drain(estFluidToDrain, IFluidHandler.FluidAction.SIMULATE);
                                int amountCanAddToPedestal = pedestal.addFluid(fluidToActuallyDrain, IFluidHandler.FluidAction.SIMULATE);
                                if (!fluidInTank.isEmpty() && amountCanAddToPedestal > 0) {
                                    FluidStack fluidDrained = handler3.drain(amountCanAddToPedestal, IFluidHandler.FluidAction.EXECUTE);
                                    pedestal.addFluid(fluidDrained, IFluidHandler.FluidAction.EXECUTE);
                                }
                            }
                        } else {
                            FluidStack fluidMatching = FluidStack.EMPTY;
                            fluidMatching = IntStream.range(0, tanks).mapToObj(arg_0 -> ((IFluidHandler)handler3).getFluidInTank(arg_0)).filter(fluidStack -> fluidInPedestal.isFluidEqual(fluidStack)).findFirst().orElse(FluidStack.EMPTY);
                            if (!fluidMatching.isEmpty()) {
                                amountIn = fluidMatching.getAmount();
                                baseRate = (Integer)PedestalConfig.COMMON.upgrade_import_baseFluidTransferSpeed.get();
                                int rate = baseRate + this.getFluidCapacityIncrease(pedestal.getCoinOnPedestal());
                                int actualCoinRate = fluidSpaceInPedestal >= rate ? rate : fluidSpaceInPedestal;
                                int n = transferRate = amountIn >= actualCoinRate ? actualCoinRate : amountIn;
                                if (fluidSpaceInPedestal >= transferRate || pedestal.getStoredFluid().isEmpty()) {
                                    FluidStack estFluidToDrain = fluidMatching.copy();
                                    estFluidToDrain.setAmount(transferRate);
                                    FluidStack fluidToActuallyDrain = handler3.drain(estFluidToDrain, IFluidHandler.FluidAction.SIMULATE);
                                    int amountCanAddToPedestal = pedestal.addFluid(fluidToActuallyDrain, IFluidHandler.FluidAction.SIMULATE);
                                    if (!fluidMatching.isEmpty() && amountCanAddToPedestal > 0) {
                                        FluidStack fluidDrained = handler3.drain(amountCanAddToPedestal, IFluidHandler.FluidAction.EXECUTE);
                                        pedestal.addFluid(fluidDrained, IFluidHandler.FluidAction.EXECUTE);
                                    }
                                }
                            }
                        }
                    } else {
                        FluidStack fluidInTank = handler3.getFluidInTank(tanks - 1);
                        if (fluidInPedestal.isEmpty() || fluidInPedestal.isFluidEqual(fluidInTank)) {
                            amountIn = fluidInTank.getAmount();
                            baseRate = (Integer)PedestalConfig.COMMON.upgrade_import_baseFluidTransferSpeed.get();
                            int rate = baseRate + this.getFluidCapacityIncrease(pedestal.getCoinOnPedestal());
                            int actualCoinRate = fluidSpaceInPedestal >= rate ? rate : fluidSpaceInPedestal;
                            int n = transferRate = amountIn >= actualCoinRate ? actualCoinRate : amountIn;
                            if (fluidSpaceInPedestal >= transferRate || pedestal.getStoredFluid().isEmpty()) {
                                FluidStack estFluidToDrain = fluidInTank.copy();
                                estFluidToDrain.setAmount(transferRate);
                                FluidStack fluidToActuallyDrain = handler3.drain(estFluidToDrain, IFluidHandler.FluidAction.SIMULATE);
                                int amountCanAddToPedestal = pedestal.addFluid(fluidToActuallyDrain, IFluidHandler.FluidAction.SIMULATE);
                                if (!fluidInTank.isEmpty() && amountCanAddToPedestal > 0) {
                                    FluidStack fluidDrained = handler3.drain(amountCanAddToPedestal, IFluidHandler.FluidAction.EXECUTE);
                                    pedestal.addFluid(fluidDrained, IFluidHandler.FluidAction.EXECUTE);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.canTransferEnergy(coin)) {
            IEnergyStorage handler4;
            int getMaxEnergyValue = pedestal.getEnergyCapacity();
            LazyOptional<IEnergyStorage> cap4 = MowLibEnergyUtils.findEnergyHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true);
            if (this.hasEntityContainer(coin)) {
                cap4 = ItemUpgradeImport.findItemHandlerAtPosEntityEnergy(level, posInventory, this.getPedestalFacing(level, pedestalPos), true);
            }
            if (cap4.isPresent() && (handler4 = (IEnergyStorage)cap4.orElse(null)) != null && handler4.canExtract()) {
                int baseRate3;
                int maxRate;
                int transferRate;
                int containerCurrentEnergy = handler4.getEnergyStored();
                int getMaxEnergy = getMaxEnergyValue;
                int getCurrentEnergy = pedestal.getStoredEnergy();
                int getSpaceForEnergy = getMaxEnergy - getCurrentEnergy;
                int n = transferRate = getSpaceForEnergy >= (maxRate = (baseRate3 = ((Integer)PedestalConfig.COMMON.upgrade_import_baseEnergyTransferSpeed.get()).intValue()) + this.getEnergyCapacityIncrease(pedestal.getCoinOnPedestal())) ? maxRate : getSpaceForEnergy;
                if (containerCurrentEnergy < transferRate) {
                    transferRate = containerCurrentEnergy;
                }
                if (handler4.extractEnergy(transferRate, true) > 0) {
                    pedestal.addEnergy(transferRate, false);
                    handler4.extractEnergy(transferRate, false);
                }
            }
        }
        if (this.canTransferXP(coin)) {
            IExperienceStorage handler5;
            int getMaxExperienceValue = pedestal.getExperienceCapacity();
            LazyOptional cap5 = MowLibXpUtils.findExperienceHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true);
            BlockEntity invToPushTo = level.m_7702_(posInventory);
            if (cap5.isPresent() && (handler5 = (IExperienceStorage)cap5.orElse(null)) != null && handler5.canExtract()) {
                int maxRate;
                int transferRate;
                int containerCurrentExperience = handler5.getExperienceStored();
                int getMaxExperience = getMaxExperienceValue;
                int getCurrentExperience = pedestal.getStoredExperience();
                int getSpaceForExperience = getMaxExperience - getCurrentExperience;
                int n = transferRate = getSpaceForExperience >= (maxRate = (baseRate = ((Integer)PedestalConfig.COMMON.upgrade_import_baseExpTransferSpeed.get()).intValue()) + MowLibXpUtils.getExpCountByLevel((int)this.getXPCapacityIncrease(pedestal.getCoinOnPedestal()))) ? maxRate : getSpaceForExperience;
                if (containerCurrentExperience < transferRate) {
                    transferRate = containerCurrentExperience;
                }
                if (handler5.extractExperience(transferRate, true) > 0) {
                    pedestal.addExperience(transferRate, false);
                    handler5.extractExperience(transferRate, false);
                }
            }
        }
        if (this.canTransferDust(coin) && (cap = MowLibDustUtils.findDustHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos))).isPresent() && (handler = (IDustHandler)cap.orElse(null)) != null && pedestal.canAcceptDust(handler.getDustMagicInTank(0))) {
            int baseRate4;
            int maxRate;
            int getSpaceForDust;
            DustMagic getCurrentlyStored = handler.getDustMagicInTank(0);
            int colorCurrentlyStored = getCurrentlyStored.getDustColor();
            int containerCurrentDust = getCurrentlyStored.getDustAmount();
            int transferRate = Math.min(containerCurrentDust, (getSpaceForDust = pedestal.spaceForDust()) >= (maxRate = (baseRate4 = ((Integer)PedestalConfig.COMMON.upgrade_import_baseDustTransferSpeed.get()).intValue()) + this.getDustCapacityIncrease(pedestal.getCoinOnPedestal())) ? maxRate : getSpaceForDust);
            if (handler.drain(transferRate, IDustHandler.DustAction.SIMULATE).getDustAmount() > 0 && handler.drain(transferRate, IDustHandler.DustAction.EXECUTE).getDustAmount() > 0) {
                pedestal.addDust(new DustMagic(colorCurrentlyStored, transferRate), IDustHandler.DustAction.EXECUTE);
            }
        }
    }

    public static ItemStack setDustMagicInItem(ItemStack stackToSet, DustMagic magicIn) {
        ItemStack copyStack = stackToSet.m_41777_();
        CompoundTag copyStackTag = stackToSet.m_41784_();
        copyStackTag.m_128405_("mowlib_dustMagicColor", magicIn.getDustColor());
        copyStackTag.m_128405_("mowlib_dustMagicAmount", magicIn.getDustAmount());
        copyStack.m_41751_(copyStackTag);
        return copyStack;
    }

    public static DustMagic getDustMagicInItem(ItemStack stack) {
        DustMagic magic = new DustMagic(-1, 0);
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            if (tag.m_128441_("mowlib_dustMagicColor")) {
                magic.setDustColor(tag.m_128451_("mowlib_dustMagicColor"));
                if (tag.m_128441_("mowlib_dustMagicAmount")) {
                    magic.setDustAmount(tag.m_128451_("mowlib_dustMagicAmount"));
                }
            } else if (tag.m_128441_("mowlib_color")) {
                magic.setDustColor(MowLibColorReference.getColorFromItemStackInt((ItemStack)stack));
                magic.setDustAmount(stack.m_41613_());
            }
        }
        return magic;
    }

    @Override
    public void onCollideAction(BasePedestalBlockEntity pedestal) {
        List entitiesColliding = pedestal.m_58904_().m_45976_(Entity.class, new AABB(pedestal.getPos()));
        for (Entity entityIn : entitiesColliding) {
            ItemStack newStackInPlayer;
            ItemStack itemStack2;
            ItemEntity itemEntity;
            Player player;
            if (this.canTransferXP(pedestal.getCoinOnPedestal()) && pedestal.canAcceptExperience()) {
                if (entityIn instanceof Player) {
                    int transferRate;
                    int value;
                    int currentlyStoredExp;
                    player = (Player)entityIn;
                    if (!player.m_6144_() && (currentlyStoredExp = pedestal.getStoredExperience()) < pedestal.getExperienceCapacity() && (value = MowLibXpUtils.removeXp((Player)player, (int)(transferRate = this.getUpgradeExperienceTransferRate(pedestal.getCoinOnPedestal())))) > 0) {
                        pedestal.addExperience(value, false);
                        if (pedestal.canSpawnParticles()) {
                            MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_(), new int[]{0, 255, 0}));
                        }
                    }
                } else if (entityIn instanceof ExperienceOrb) {
                    int value;
                    ExperienceOrb xpOrb = (ExperienceOrb)entityIn;
                    int currentlyStoredExp = pedestal.getStoredExperience();
                    if (currentlyStoredExp < pedestal.getExperienceCapacity() && (value = xpOrb.m_20801_()) > 0) {
                        pedestal.addExperience(value, false);
                        xpOrb.m_142687_(Entity.RemovalReason.DISCARDED);
                        if (pedestal.canSpawnParticles()) {
                            MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_(), new int[]{0, 255, 0}));
                        }
                    }
                }
            }
            if (this.canTransferDust(pedestal.getCoinOnPedestal())) {
                // empty if block
            }
            if (this.canTransferFluids(pedestal.getCoinOnPedestal())) {
                if (entityIn instanceof ItemEntity) {
                    Item value;
                    itemEntity = (ItemEntity)entityIn;
                    itemStack2 = itemEntity.m_32055_();
                    if (!itemStack2.m_41720_().equals(Items.f_42446_) && (value = itemStack2.m_41720_()) instanceof BucketItem) {
                        BucketItem bucket = (BucketItem)value;
                        if (this.passesFluidFilter(pedestal, this.getFluidStackFromItemStack(itemStack2))) {
                            Fluid bucketFluid = bucket.getFluid();
                            FluidStack fluidInTank = new FluidStack(bucketFluid, 1000);
                            fluidSpaceInPedestal = pedestal.spaceForFluid();
                            FluidStack fluidInPedestal = pedestal.getStoredFluid();
                            if ((fluidInPedestal.isEmpty() || fluidInPedestal.isFluidEqual(fluidInTank)) && (fluidSpaceInPedestal >= (transferRate = 1000) || pedestal.getStoredFluid().isEmpty())) {
                                FluidStack fluidDrained = fluidInTank.copy();
                                if (!fluidInTank.isEmpty()) {
                                    pedestal.addFluid(fluidDrained, IFluidHandler.FluidAction.EXECUTE);
                                    itemEntity.m_32045_(new ItemStack((ItemLike)Items.f_42446_, 1));
                                }
                            }
                        }
                    }
                } else if (entityIn instanceof Player && !(player = (Player)entityIn).m_6144_()) {
                    ItemStack bucketItemStack = IntStream.range(0, player.m_150109_().f_35974_.size()).mapToObj(arg_0 -> ((NonNullList)player.m_150109_().f_35974_).get(arg_0)).filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> !itemStack.m_41720_().equals(Items.f_42446_)).filter(itemStack -> itemStack.m_41720_() instanceof BucketItem).filter(itemStack -> this.passesFluidFilter(pedestal, this.getFluidStackFromItemStack((ItemStack)itemStack))).findFirst().orElse(ItemStack.f_41583_);
                    if (!bucketItemStack.m_41619_()) {
                        BucketItem bucket = (BucketItem)bucketItemStack.m_41720_();
                        Fluid bucketFluid = bucket.getFluid();
                        FluidStack fluidInTank = new FluidStack(bucketFluid, 1000);
                        fluidSpaceInPedestal = pedestal.spaceForFluid();
                        FluidStack fluidInPedestal = pedestal.getStoredFluid();
                        if ((fluidInPedestal.isEmpty() || fluidInPedestal.isFluidEqual(fluidInTank)) && (fluidSpaceInPedestal >= (transferRate = 1000) || pedestal.getStoredFluid().isEmpty())) {
                            FluidStack fluidDrained = fluidInTank.copy();
                            if (!fluidInTank.isEmpty()) {
                                pedestal.addFluid(fluidDrained, IFluidHandler.FluidAction.EXECUTE);
                                int slot = player.m_150109_().m_36030_(bucketItemStack);
                                if (!player.m_7500_()) {
                                    player.m_150109_().m_8020_(slot).m_41774_(1);
                                }
                                if (!player.m_7500_()) {
                                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_, 1));
                                }
                                String fluid = pedestal.getStoredFluid().getDisplayName().getString() + ": " + pedestal.getStoredFluid().getAmount() + "/" + pedestal.getFluidCapacity();
                                MowLibMessageUtils.messagePopupText((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)fluid);
                            }
                        }
                    }
                }
            }
            if (!this.canTransferItems(pedestal.getCoinOnPedestal())) continue;
            if (entityIn instanceof ItemEntity) {
                itemEntity = (ItemEntity)entityIn;
                itemStack2 = itemEntity.m_32055_();
                ItemStack stackInPedestal = pedestal.getItemInPedestal();
                boolean stacksMatch = this.doItemsMatch(stackInPedestal, itemStack2);
                if (pedestal.hasItem() && !stacksMatch || !this.passesItemFilter(pedestal, itemStack2)) continue;
                int spaceInPed = stackInPedestal.m_41741_() - stackInPedestal.m_41613_();
                int filterAllowedSpace = this.getCountItemFilter(pedestal, itemStack2);
                int actualSpaceInPed = filterAllowedSpace > spaceInPed ? spaceInPed : filterAllowedSpace;
                if (actualSpaceInPed <= 0) continue;
                int itemInCount = itemStack2.m_41613_();
                int countToAdd = itemInCount <= actualSpaceInPed ? itemInCount : actualSpaceInPed;
                ItemStack stackToAdd = itemStack2.m_41777_();
                stackToAdd.m_41764_(countToAdd);
                if (!pedestal.addItem(stackToAdd, true)) continue;
                itemEntity.m_32055_().m_41764_(itemInCount - countToAdd);
                if (itemInCount <= countToAdd) {
                    itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                pedestal.addItem(stackToAdd, false);
                if (!pedestal.canSpawnParticles()) continue;
                MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_(), new int[]{180, 180, 180}));
                continue;
            }
            if (!(entityIn instanceof Player) || (player = (Player)entityIn).m_6144_()) continue;
            ItemStack itemFromInv = ItemStack.f_41583_;
            itemFromInv = IntStream.range(0, player.m_150109_().f_35974_.size()).mapToObj(arg_0 -> ((NonNullList)player.m_150109_().f_35974_).get(arg_0)).filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> this.passesItemFilter(pedestal, (ItemStack)itemStack)).findFirst().orElse(ItemStack.f_41583_);
            if (itemFromInv.m_41619_()) continue;
            ItemStack itemStack3 = itemFromInv;
            ItemStack stackInPedestal = pedestal.getItemInPedestal();
            boolean stacksMatch = this.doItemsMatch(stackInPedestal, itemStack3);
            if (pedestal.hasItem() && !stacksMatch || !this.passesItemFilter(pedestal, itemStack3)) continue;
            int spaceInPed = stackInPedestal.m_41741_() - stackInPedestal.m_41613_();
            int filterAllowedSpace = this.getCountItemFilter(pedestal, itemStack3);
            int actualSpaceInPed = filterAllowedSpace > spaceInPed ? spaceInPed : filterAllowedSpace;
            if (actualSpaceInPed <= 0) continue;
            int itemInCount = itemStack3.m_41613_();
            int countToAdd = itemInCount <= actualSpaceInPed ? itemInCount : actualSpaceInPed;
            ItemStack stackToAdd = itemStack3.m_41777_();
            stackToAdd.m_41764_(countToAdd);
            if (!pedestal.addItem(stackToAdd, true)) continue;
            ItemStack itemStack4 = newStackInPlayer = itemInCount > countToAdd ? itemStack3.m_41777_() : ItemStack.f_41583_;
            if (!newStackInPlayer.m_41619_()) {
                newStackInPlayer.m_41764_(itemInCount - countToAdd);
            }
            int slot = player.m_150109_().m_36030_(itemStack3);
            player.m_150109_().m_6836_(slot, newStackInPlayer);
            pedestal.addItem(stackToAdd, false);
            if (!pedestal.canSpawnParticles()) continue;
            MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_(), new int[]{180, 180, 0}));
        }
    }
}

