/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMultiContainer;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Recipes.FluidConverterRecipe;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemUpgradeFluidConverter
extends ItemUpgradeBase {
    public ItemUpgradeFluidConverter(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
    }

    @Nullable
    protected FluidConverterRecipe getNormalRecipe(BasePedestalBlockEntity pedestal) {
        Level level = pedestal.m_58904_();
        MowLibMultiContainer cont = MowLibContainerUtils.getMultiContainer((int)0);
        cont.setFluidStack(pedestal.getStoredFluid());
        if (level == null) {
            return null;
        }
        RecipeManager recipeManager = level.m_7465_();
        Optional optional = recipeManager.m_44015_((RecipeType)FluidConverterRecipe.Type.INSTANCE, (Container)cont, level);
        if (optional.isPresent()) {
            return optional.orElse(null);
        }
        return null;
    }

    protected FluidStack getFluidRequired(FluidConverterRecipe recipe) {
        if (recipe != null) {
            return recipe.getFluidRequired();
        }
        return FluidStack.EMPTY;
    }

    protected Collection<ItemStack> getNormalResults(FluidConverterRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.f_41583_) : Collections.singleton(recipe.m_8043_());
    }

    protected int getEnergyResult(FluidConverterRecipe recipe) {
        return recipe == null ? 0 : recipe.getEnergyReturned();
    }

    protected int getExperienceResult(FluidConverterRecipe recipe) {
        return recipe == null ? 0 : recipe.getExperienceReturned();
    }

    protected DustMagic getDustResult(FluidConverterRecipe recipe) {
        return recipe == null ? DustMagic.EMPTY : recipe.getDustReturned();
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        if (pedestal.hasFluid()) {
            FluidConverterRecipe recipe = this.getNormalRecipe(pedestal);
            FluidStack fluidRequired = this.getFluidRequired(recipe);
            ItemStack returnedStack = this.getNormalResults(recipe).stream().findFirst().orElse(ItemStack.f_41583_);
            boolean energy = true;
            int getReturnedEnergy = this.getEnergyResult(recipe);
            boolean exp = true;
            int getReturnedExperience = this.getExperienceResult(recipe);
            boolean dust = true;
            DustMagic getReturnedDust = this.getDustResult(recipe);
            if (!(getReturnedEnergy <= 0 && getReturnedExperience <= 0 && getReturnedDust.isEmpty() && returnedStack.m_41619_() || pedestal.getStoredFluid().getAmount() < fluidRequired.getAmount() || pedestal.removeFluid(fluidRequired, IFluidHandler.FluidAction.SIMULATE).isEmpty())) {
                boolean allowed = true;
                if (!returnedStack.m_41619_() && !pedestal.addItem(returnedStack, true)) {
                    allowed = false;
                }
                if (getReturnedEnergy > 0 && pedestal.addEnergy(getReturnedEnergy, true) < getReturnedEnergy) {
                    allowed = false;
                }
                if (getReturnedExperience > 0 && pedestal.addExperience(getReturnedExperience, true) < getReturnedExperience) {
                    allowed = false;
                }
                if (!getReturnedDust.isEmpty() && pedestal.addDust(getReturnedDust, IDustHandler.DustAction.SIMULATE) < getReturnedDust.getDustAmount()) {
                    allowed = false;
                }
                if (allowed && !pedestal.removeFluid(fluidRequired, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
                    if (getReturnedEnergy > 0) {
                        pedestal.addEnergy(getReturnedEnergy, false);
                    }
                    if (getReturnedExperience > 0) {
                        pedestal.addExperience(getReturnedExperience, false);
                    }
                    if (!getReturnedDust.isEmpty()) {
                        pedestal.addDust(getReturnedDust, IDustHandler.DustAction.EXECUTE);
                    }
                    if (!returnedStack.m_41619_()) {
                        pedestal.addItem(returnedStack, false);
                    }
                }
            }
        }
    }
}

