/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.Capabilities.Experience.IExperienceStorage;
import com.mowmaster.mowlib.MowLibUtils.MowLibDustUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibEnergyUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibFluidUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibXpUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemUpgradeExport
extends ItemUpgradeBase
implements IHasModeTypes {
    public ItemUpgradeExport(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyItemCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyFluidCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyEnergyCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyXPCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyDustCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyEntityContainers(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        DustMagic dustInPedestal;
        IDustHandler handler;
        LazyOptional cap;
        IExperienceStorage handler2;
        LazyOptional cap2;
        int maxRate;
        BlockPos posInventory = this.getPosOfBlockBelow(level, pedestalPos, 1);
        if (this.canTransferItems(coin)) {
            int baseRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseItemTransferSpeed.get();
            int transferRate = baseRate + this.getItemCapacityIncrease(pedestal.getCoinOnPedestal());
            ItemStack stackInPedestal = pedestal.removeItem(true);
            ItemStack itemFromInv = ItemStack.f_41583_;
            LazyOptional<IItemHandler> cap3 = MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true);
            if (this.hasEntityContainer(coin)) {
                cap3 = ItemUpgradeExport.findItemHandlerAtPosEntity(level, posInventory, this.getPedestalFacing(level, pedestalPos), true);
            }
            if (!stackInPedestal.m_41619_() && !stackInPedestal.equals(ItemStack.f_41583_) && cap3.isPresent()) {
                IItemHandler handler3 = (IItemHandler)cap3.orElse(null);
                BlockEntity invToPullFrom = level.m_7702_(posInventory);
                if (invToPullFrom instanceof BasePedestalBlockEntity) {
                    itemFromInv = ItemStack.f_41583_;
                } else if (handler3 != null) {
                    int i = this.getNextSlotEmptyOrMatching(cap3, stackInPedestal);
                    if (handler3 != null && i >= 0 && handler3.isItemValid(i, stackInPedestal)) {
                        stackInPedestal = pedestal.removeItem(true).m_41777_();
                        ItemStack itemFromInventory = handler3.getStackInSlot(i);
                        int spaceInInventoryStack = handler3.getSlotLimit(i) - itemFromInventory.m_41613_();
                        int allowedTransferRate = transferRate;
                        if (handler3.getSlotLimit(i) <= allowedTransferRate) {
                            allowedTransferRate = handler3.getSlotLimit(i);
                        }
                        if (allowedTransferRate > spaceInInventoryStack) {
                            allowedTransferRate = spaceInInventoryStack;
                        }
                        if (allowedTransferRate > stackInPedestal.m_41613_()) {
                            allowedTransferRate = stackInPedestal.m_41613_();
                        }
                        stackInPedestal.m_41764_(allowedTransferRate);
                        if (ItemHandlerHelper.insertItem((IItemHandler)handler3, (ItemStack)stackInPedestal, (boolean)true).equals(ItemStack.f_41583_)) {
                            pedestal.removeItem(allowedTransferRate, false);
                            ItemHandlerHelper.insertItem((IItemHandler)handler3, (ItemStack)stackInPedestal, (boolean)false);
                        }
                    }
                }
            }
        }
        if (this.canTransferFluids(coin)) {
            IFluidHandler handler4;
            LazyOptional<IFluidHandler> cap4 = MowLibFluidUtils.findFluidHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true);
            if (this.hasEntityContainer(coin)) {
                cap4 = ItemUpgradeExport.findItemHandlerAtPosEntityFluid(level, posInventory, this.getPedestalFacing(level, pedestalPos), true);
            }
            if (cap4.isPresent() && (handler4 = (IFluidHandler)cap4.orElse(null)) != null) {
                int tanks = handler4.getTanks();
                FluidStack fluidInPedestal = pedestal.getStoredFluid();
                if (tanks > 1) {
                    FluidStack fluidCheckedMatching = FluidStack.EMPTY;
                    fluidCheckedMatching = IntStream.range(0, tanks).mapToObj(arg_0 -> ((IFluidHandler)handler4).getFluidInTank(arg_0)).filter(fluidStack -> fluidStack.isFluidEqual(fluidInPedestal)).findFirst().orElse(FluidStack.EMPTY);
                    if (!fluidCheckedMatching.isEmpty()) {
                        int transferRate;
                        FluidStack matchedFluid = fluidCheckedMatching;
                        int value = 0;
                        for (int location = 0; location < tanks; ++location) {
                            if (!handler4.getFluidInTank(location).isFluidEqual(matchedFluid)) continue;
                            value = location;
                            break;
                        }
                        getTankCapacity = handler4.getTankCapacity(value);
                        tankCurrentlyStored = matchedFluid.getAmount();
                        spaceInTank = getTankCapacity - tankCurrentlyStored;
                        amountInCoin = fluidInPedestal.getAmount();
                        int baseRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseFluidTransferSpeed.get();
                        int rate = baseRate + this.getFluidCapacityIncrease(pedestal.getCoinOnPedestal());
                        int actualCoinRate = spaceInTank >= rate ? rate : spaceInTank;
                        int n = transferRate = amountInCoin >= actualCoinRate ? actualCoinRate : amountInCoin;
                        if (spaceInTank >= transferRate) {
                            FluidStack estFluidToFill = new FluidStack(fluidInPedestal.getFluid(), transferRate, fluidInPedestal.getTag());
                            int fluidToActuallyFill = handler4.fill(estFluidToFill, IFluidHandler.FluidAction.SIMULATE);
                            FluidStack fluidToRemove = pedestal.removeFluid(fluidToActuallyFill, IFluidHandler.FluidAction.SIMULATE);
                            if (fluidToActuallyFill > 0 && fluidToRemove.getAmount() > 0) {
                                estFluidToFill = new FluidStack(fluidInPedestal.getFluid(), fluidToRemove.getAmount(), fluidInPedestal.getTag());
                                int fluidDrained = handler4.fill(estFluidToFill, IFluidHandler.FluidAction.EXECUTE);
                                pedestal.removeFluid(fluidDrained, IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                    } else {
                        int transferRate;
                        int value = 0;
                        for (int location = 0; location < tanks; ++location) {
                            if (!handler4.getFluidInTank(location).isEmpty()) continue;
                            value = location;
                            break;
                        }
                        FluidStack emptyTank = handler4.getFluidInTank(value);
                        getTankCapacity = handler4.getTankCapacity(value);
                        tankCurrentlyStored = emptyTank.getAmount();
                        spaceInTank = getTankCapacity - tankCurrentlyStored;
                        amountInCoin = fluidInPedestal.getAmount();
                        int baseRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseFluidTransferSpeed.get();
                        int rate = baseRate + this.getFluidCapacityIncrease(pedestal.getCoinOnPedestal());
                        int actualCoinRate = spaceInTank >= rate ? rate : spaceInTank;
                        int n = transferRate = amountInCoin >= actualCoinRate ? actualCoinRate : amountInCoin;
                        if (spaceInTank >= transferRate) {
                            FluidStack estFluidToFill = new FluidStack(fluidInPedestal.getFluid(), transferRate, fluidInPedestal.getTag());
                            int fluidToActuallyFill = handler4.fill(estFluidToFill, IFluidHandler.FluidAction.SIMULATE);
                            FluidStack fluidToRemove = pedestal.removeFluid(fluidToActuallyFill, IFluidHandler.FluidAction.SIMULATE);
                            if (fluidToActuallyFill > 0 && fluidToRemove.getAmount() > 0) {
                                estFluidToFill = new FluidStack(fluidInPedestal.getFluid(), fluidToRemove.getAmount(), fluidInPedestal.getTag());
                                int fluidDrained = handler4.fill(estFluidToFill, IFluidHandler.FluidAction.EXECUTE);
                                pedestal.removeFluid(fluidDrained, IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                    }
                } else {
                    int gettanks = tanks - 1 <= 0 ? 0 : tanks - 1;
                    FluidStack fluidInTank = handler4.getFluidInTank(gettanks);
                    if (fluidInTank.isEmpty() || fluidInPedestal.isFluidEqual(fluidInTank)) {
                        int transferRate;
                        int getTankCapacity = handler4.getTankCapacity(gettanks);
                        int tankCurrentlyStored = fluidInTank.getAmount();
                        int spaceInTank = getTankCapacity - tankCurrentlyStored;
                        int amountInCoin = fluidInPedestal.getAmount();
                        int baseRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseFluidTransferSpeed.get();
                        int rate = baseRate + this.getFluidCapacityIncrease(pedestal.getCoinOnPedestal());
                        int actualCoinRate = spaceInTank >= rate ? rate : spaceInTank;
                        int n = transferRate = amountInCoin >= actualCoinRate ? actualCoinRate : amountInCoin;
                        if (spaceInTank >= transferRate) {
                            FluidStack estFluidToFill = new FluidStack(fluidInPedestal.getFluid(), transferRate, fluidInPedestal.getTag());
                            int fluidToActuallyFill = handler4.fill(estFluidToFill, IFluidHandler.FluidAction.SIMULATE);
                            FluidStack fluidToRemove = pedestal.removeFluid(fluidToActuallyFill, IFluidHandler.FluidAction.SIMULATE);
                            if (fluidToActuallyFill > 0 && fluidToRemove.getAmount() > 0) {
                                estFluidToFill = new FluidStack(fluidInPedestal.getFluid(), fluidToRemove.getAmount(), fluidInPedestal.getTag());
                                int fluidDrained = handler4.fill(estFluidToFill, IFluidHandler.FluidAction.EXECUTE);
                                pedestal.removeFluid(fluidDrained, IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                    }
                }
            }
        }
        if (this.canTransferEnergy(coin)) {
            IEnergyStorage handler5;
            LazyOptional<IEnergyStorage> cap5 = MowLibEnergyUtils.findEnergyHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true);
            if (this.hasEntityContainer(coin)) {
                cap5 = ItemUpgradeExport.findItemHandlerAtPosEntityEnergy(level, posInventory, this.getPedestalFacing(level, pedestalPos), true);
            }
            if (cap5.isPresent() && (handler5 = (IEnergyStorage)cap5.orElse(null)) != null && handler5.canReceive()) {
                int transferRate;
                int containerMaxEnergy = handler5.getMaxEnergyStored();
                int containerCurrentEnergy = handler5.getEnergyStored();
                int containerEnergySpace = containerMaxEnergy - containerCurrentEnergy;
                int getCurrentEnergy = pedestal.getStoredEnergy();
                int baseRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseEnergyTransferSpeed.get();
                maxRate = baseRate + this.getEnergyCapacityIncrease(pedestal.getCoinOnPedestal());
                int n = transferRate = containerEnergySpace >= maxRate ? maxRate : containerEnergySpace;
                if (getCurrentEnergy < transferRate) {
                    transferRate = getCurrentEnergy;
                }
                if (handler5.receiveEnergy(transferRate, true) > 0) {
                    pedestal.removeEnergy(transferRate, false);
                    handler5.receiveEnergy(transferRate, false);
                }
            }
        }
        if (this.canTransferXP(coin) && (cap2 = MowLibXpUtils.findExperienceHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true)).isPresent() && (handler2 = (IExperienceStorage)cap2.orElse(null)) != null && handler2.canReceive()) {
            int transferRate;
            int containerMaxExperience = handler2.getMaxExperienceStored();
            int containerCurrentExperience = handler2.getExperienceStored();
            int containerExperienceSpace = containerMaxExperience - containerCurrentExperience;
            int getCurrentExperience = pedestal.getStoredExperience();
            int baseRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseExpTransferSpeed.get();
            maxRate = baseRate + MowLibXpUtils.getExpCountByLevel((int)this.getXPCapacityIncrease(pedestal.getCoinOnPedestal()));
            int n = transferRate = containerExperienceSpace >= maxRate ? maxRate : containerExperienceSpace;
            if (getCurrentExperience < transferRate) {
                transferRate = getCurrentExperience;
            }
            if (handler2.receiveExperience(transferRate, true) > 0) {
                pedestal.removeExperience(transferRate, false);
                handler2.receiveExperience(transferRate, false);
            }
        }
        if (this.canTransferDust(coin) && (cap = MowLibDustUtils.findDustHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos))).isPresent() && (handler = (IDustHandler)cap.orElse(null)) != null && handler.isDustValid(0, dustInPedestal = pedestal.getStoredDust())) {
            int containerMaxDust = handler.getTankCapacity(0);
            int containerCurrentDustAmount = handler.getDustMagicInTank(0).getDustAmount();
            int containerDustSpace = containerMaxDust - containerCurrentDustAmount;
            int baseRate = (Integer)PedestalConfig.COMMON.upgrade_export_baseDustTransferSpeed.get();
            maxRate = baseRate + this.getDustCapacityIncrease(pedestal.getCoinOnPedestal());
            int getCurrentDustInPedestal = dustInPedestal.getDustAmount();
            int transferRate = Math.min(getCurrentDustInPedestal, containerDustSpace >= maxRate ? maxRate : containerDustSpace);
            if (handler.fill(new DustMagic(dustInPedestal.getDustColor(), transferRate), IDustHandler.DustAction.SIMULATE) > 0 && handler.fill(new DustMagic(dustInPedestal.getDustColor(), transferRate), IDustHandler.DustAction.EXECUTE) > 0) {
                pedestal.removeDust(transferRate, IDustHandler.DustAction.EXECUTE);
            }
        }
    }
}

