/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Filters.BaseFilter;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardBase;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.IFluidBlock;

public class ItemUpgradeDropper
extends ItemUpgradeBase
implements IHasModeTypes {
    public ItemUpgradeDropper(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyItemCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyXPCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard() {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 0;
    }

    public boolean canDropBolts() {
        return (Boolean)PedestalConfig.COMMON.upgrade_dropper_canDropBolt.get();
    }

    public int baseEnergyCostPerDrop() {
        return (Integer)PedestalConfig.COMMON.upgrade_dropper_baseEnergyDropAmount.get();
    }

    private void buildValidBlockList(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        ItemStack coin = pedestal.getCoinOnPedestal();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            List<BlockPos> listed = WorkCardBase.readBlockPosListFromNBT(card);
            ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
            for (BlockPos pos : listed) {
                if (!workCardBase.selectedPointWithinRange(pedestal, pos)) continue;
                valid.add(pos);
            }
            ItemUpgradeDropper.saveBlockPosListCustomToNBT(coin, "_validlist", valid);
        }
    }

    private void buildValidBlockListArea(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        ItemStack coin = pedestal.getCoinOnPedestal();
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            AABB area = new AABB(WorkCardBase.readBlockPosFromNBT(card, 1), WorkCardBase.readBlockPosFromNBT(card, 2));
            int maxX = (int)area.f_82291_;
            int maxY = (int)area.f_82292_;
            int maxZ = (int)area.f_82293_;
            int minX = (int)area.f_82288_;
            int minY = (int)area.f_82289_;
            int minZ = (int)area.f_82290_;
            BlockPos pedestalPos = pedestal.getPos();
            if (minY < pedestalPos.m_123342_()) {
                for (int i = maxX; i >= minX; --i) {
                    for (int j = maxZ; j >= minZ; --j) {
                        for (int k = maxY; k >= minY; --k) {
                            BlockPos newPoint = new BlockPos(i, k, j);
                            if (!workCardBase.selectedPointWithinRange(pedestal, newPoint)) continue;
                            valid.add(newPoint);
                        }
                    }
                }
            } else {
                for (int i = minX; i <= maxX; ++i) {
                    for (int j = minZ; j <= maxZ; ++j) {
                        for (int k = minY; k <= maxY; ++k) {
                            BlockPos newPoint = new BlockPos(i, k, j);
                            if (!workCardBase.selectedPointWithinRange(pedestal, newPoint)) continue;
                            valid.add(newPoint);
                        }
                    }
                }
            }
        }
        ItemUpgradeDropper.saveBlockPosListCustomToNBT(coin, "_validlist", valid);
    }

    private List<BlockPos> getValidList(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return ItemUpgradeDropper.readBlockPosListCustomFromNBT(coin, "_validlist");
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.removeBlockListCustomNBTTags(coinInPedestal, "_validlist");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        ItemStack card;
        Item item;
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            boolean override = workCardBase.hasTwoPointsSelected(card);
            List<BlockPos> listed = this.getValidList(pedestal);
            if (override) {
                if (listed.size() > 0) {
                    this.dropperAction(level, pedestal);
                } else if (workCardBase.selectedAreaWithinRange(pedestal) && !this.hasBlockListCustomNBTTags(coin, "_validlist")) {
                    this.buildValidBlockListArea(pedestal);
                }
            } else {
                List<BlockPos> getList = WorkCardBase.readBlockPosListFromNBT(card);
                if (!override && listed.size() > 0) {
                    this.dropperAction(level, pedestal);
                } else if (getList.size() > 0 && !this.hasBlockListCustomNBTTags(coin, "_validlist")) {
                    BlockPos hasValidPos = IntStream.range(0, getList.size()).mapToObj(getList::get).filter(blockPos -> this.selectedPointWithinRange(pedestal, (BlockPos)blockPos)).findFirst().orElse(BlockPos.f_121853_);
                    if (!hasValidPos.equals((Object)BlockPos.f_121853_)) {
                        this.buildValidBlockList(pedestal);
                    }
                }
            }
        }
    }

    private int getCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private void iterateCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentPosition(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1), (String)"_numposition");
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, BlockState canMineBlock, BlockPos canMinePos) {
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInPedestal()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral()) {
            return filter.canAcceptItems(filterInPedestal, pedestal.getItemInPedestal());
        }
        return true;
    }

    public void dropperAction(Level level, BasePedestalBlockEntity pedestal) {
        WeakReference<FakePlayer> getPlayer;
        if (!level.m_5776_() && (getPlayer = pedestal.getPedestalPlayer(pedestal)) != null && getPlayer.get() != null) {
            List<BlockPos> listed = this.getValidList(pedestal);
            int currentPosition = this.getCurrentPosition(pedestal);
            BlockPos currentPoint = listed.get(currentPosition);
            BlockState blockAtPoint = level.m_8055_(currentPoint);
            ItemStack coinUpgrade = pedestal.getCoinOnPedestal();
            if (this.canTransferItems(coinUpgrade) && pedestal.hasItem() && this.passesFilter(pedestal, blockAtPoint, currentPoint) && !currentPoint.equals((Object)pedestal.getPos()) && (level.m_8055_(currentPoint).m_60734_() == Blocks.f_50016_ || level.m_8055_(currentPoint).m_60734_() instanceof IFluidBlock)) {
                int countToDrop;
                ItemStack itemToDrop = pedestal.getItemInPedestal().m_41777_();
                int baseRate = (Integer)PedestalConfig.COMMON.upgrade_dropper_baseItemDropAmount.get();
                int maxRate = baseRate + this.getItemCapacityIncrease(pedestal.getCoinOnPedestal());
                int n = countToDrop = maxRate >= itemToDrop.m_41741_() ? itemToDrop.m_41741_() : maxRate;
                if (!pedestal.removeItem(countToDrop, true).m_41619_()) {
                    ItemStack dropMe = pedestal.removeItem(countToDrop, false);
                    ItemEntity itementity = new ItemEntity(level, (double)currentPoint.m_123341_(), (double)currentPoint.m_123342_(), (double)currentPoint.m_123343_(), dropMe);
                    itementity.m_32060_();
                    itementity.m_20334_(0.0, 0.0, 0.0);
                    itementity.m_20219_(Vec3.m_82512_((Vec3i)currentPoint));
                    if (pedestal.canSpawnParticles()) {
                        MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)currentPoint.m_123341_() + 0.5, (double)currentPoint.m_123342_() + 0.5, (double)currentPoint.m_123343_() + 0.5, new int[]{255, 255, 255}));
                    }
                    level.m_7967_((Entity)itementity);
                }
            }
            if (this.canTransferEnergy(coinUpgrade) && this.canDropBolts() && pedestal.getStoredEnergy() >= this.baseEnergyCostPerDrop() && pedestal.removeEnergy(this.baseEnergyCostPerDrop(), true) > 0) {
                Random rand = new Random();
                LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)currentPoint));
                lightningbolt.m_20879_((ServerPlayer)getPlayer.get());
                pedestal.removeEnergy(this.baseEnergyCostPerDrop(), false);
                level.m_7967_((Entity)lightningbolt);
                level.m_5594_((Player)null, currentPoint, SoundEvents.f_12521_, SoundSource.WEATHER, 5.0f, 1.0f);
            }
            if (this.canTransferXP(coinUpgrade) && pedestal.hasExperience()) {
                int getxpAmountToDrop;
                int baseValue = (Integer)PedestalConfig.COMMON.upgrade_dropper_baseExpDropAmount.get();
                int maxValue = baseValue + this.getXPCapacityIncrease(pedestal.getCoinOnPedestal());
                int n = getxpAmountToDrop = maxValue >= pedestal.getStoredExperience() ? pedestal.getStoredExperience() : maxValue;
                if (pedestal.removeExperience(getxpAmountToDrop, true) > 0) {
                    ExperienceOrb xpEntity = new ExperienceOrb(level, (double)currentPoint.m_123341_(), (double)currentPoint.m_123342_(), (double)currentPoint.m_123343_(), pedestal.removeExperience(getxpAmountToDrop, false));
                    xpEntity.m_20219_(Vec3.m_82512_((Vec3i)currentPoint));
                    if (pedestal.canSpawnParticles()) {
                        MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)currentPoint.m_123341_() + 0.5, (double)currentPoint.m_123342_() + 0.5, (double)currentPoint.m_123343_() + 0.5, new int[]{0, 255, 50}));
                    }
                    level.m_7967_((Entity)xpEntity);
                }
            }
            if (currentPosition + 1 >= listed.size()) {
                this.setCurrentPosition(pedestal, 0);
            } else {
                this.iterateCurrentPosition(pedestal);
            }
        }
    }
}

