/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlock;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class ItemUpgradeCrafter
extends ItemUpgradeBase {
    public ItemUpgradeCrafter(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean selectedPointWithinRange(BasePedestalBlockEntity pedestal, BlockPos posPoint) {
        Level level;
        return this.isSelectionInRange(pedestal, posPoint) && (level = pedestal.m_58904_()).m_8055_(posPoint).m_60734_() instanceof BasePedestalBlock;
    }

    @Override
    public boolean needsWorkCard() {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 3;
    }

    private void buildValidBlockList(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        Level level = pedestal.m_58904_();
        ItemStack coin = pedestal.getCoinOnPedestal();
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            List<BlockPos> listed = WorkCardBase.readBlockPosListFromNBT(card);
            for (BlockPos pos : listed) {
                if (!this.selectedPointWithinRange(pedestal, pos) || !(level.m_8055_(pos).m_60734_() instanceof BasePedestalBlock)) continue;
                valid.add(pos);
            }
        }
        ItemUpgradeCrafter.saveBlockPosListCustomToNBT(coin, "_validlist", valid);
    }

    private List<BlockPos> getValidList(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return ItemUpgradeCrafter.readBlockPosListCustomFromNBT(coin, "_validlist");
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.removeBlockListCustomNBTTags(coinInPedestal, "_validlist");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"input");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"output");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"hasrecipe");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        ItemStack card;
        Item item;
        List<BlockPos> listed = this.getValidList(pedestal);
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            List<BlockPos> getList = WorkCardBase.readBlockPosListFromNBT(card);
            if (listed.size() > 0) {
                this.modifierAction(level, pedestal);
            } else if (getList.size() > 0 && !this.hasBlockListCustomNBTTags(coin, "_validlist")) {
                this.buildValidBlockList(pedestal);
            }
        }
    }

    @Nullable
    protected CraftingRecipe recipeGetCraftingRecipe(BasePedestalBlockEntity pedestal, List<ItemStack> ingredientStacks) {
        RecipeManager recipeManager;
        Optional optional;
        int size;
        Level level = pedestal.m_58904_();
        if (level == null) {
            return null;
        }
        if (ingredientStacks.size() <= 0) {
            return null;
        }
        CraftingContainer cont = MowLibContainerUtils.getContainerCrafting((int)1, (int)1);
        if (ingredientStacks.size() > 1) {
            cont = MowLibContainerUtils.getContainerCrafting((int)2, (int)2);
        }
        if (ingredientStacks.size() > 4) {
            cont = MowLibContainerUtils.getContainerCrafting((int)3, (int)3);
        }
        if (ingredientStacks.size() > 9) {
            cont = MowLibContainerUtils.getContainerCrafting((int)4, (int)4);
        }
        if (ingredientStacks.size() > 16) {
            cont = MowLibContainerUtils.getContainerCrafting((int)5, (int)5);
        }
        if (ingredientStacks.size() > 25) {
            cont = MowLibContainerUtils.getContainerCrafting((int)6, (int)6);
        }
        int iteratorSize = (size = ingredientStacks.size()) < cont.m_6643_() ? cont.m_6643_() : size;
        for (int i = 0; i < iteratorSize; ++i) {
            if (i < size) {
                if (!ingredientStacks.get(i).m_41619_()) {
                    cont.m_6836_(-1, ingredientStacks.get(i));
                    continue;
                }
                cont.m_6836_(-1, ItemStack.f_41583_);
                continue;
            }
            cont.m_6836_(-1, ItemStack.f_41583_);
        }
        if (cont.m_6643_() > 0 && (optional = (recipeManager = level.m_7465_()).m_44015_(RecipeType.f_44107_, (Container)cont, level)).isPresent()) {
            return optional.orElse(null);
        }
        return null;
    }

    protected Collection<ItemStack> getNormalResults(CraftingRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.f_41583_) : Collections.singleton(recipe.m_8043_());
    }

    private List<ItemStack> getResultFromCachedRecipe(ItemStack coin, List<ItemStack> incomingStack) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        List inputStack = MowLibCompoundTagUtils.readItemStackListFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"input");
        if (incomingStack.size() == inputStack.size()) {
            for (int i = 0; i < incomingStack.size(); ++i) {
                if (this.doItemsMatchWithEmpty(incomingStack.get(i), (ItemStack)inputStack.get(i))) continue;
                return results;
            }
            return MowLibCompoundTagUtils.readItemStackListFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"output");
        }
        return results;
    }

    private void cacheRecipe(BasePedestalBlockEntity pedestal, ItemStack coin, List<ItemStack> input) {
        CraftingRecipe recipe = this.recipeGetCraftingRecipe(pedestal, input);
        if (recipe != null) {
            Collection<ItemStack> stackResults = this.getNormalResults(recipe);
            if (stackResults.size() > 0) {
                MowLibCompoundTagUtils.writeItemStackListToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), input, (String)"input");
                ArrayList<ItemStack> stackies = new ArrayList<ItemStack>();
                for (ItemStack stacks : stackResults) {
                    stackies.add(stacks);
                }
                MowLibCompoundTagUtils.writeItemStackListToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), stackies, (String)"output");
                MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (boolean)true, (String)"hasrecipe");
            }
        } else {
            MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (boolean)false, (String)"hasrecipe");
        }
    }

    private boolean hasCachedRecipe(ItemStack coin) {
        return MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"hasrecipe");
    }

    public void modifierAction(Level level, BasePedestalBlockEntity pedestal) {
        if (!level.m_5776_()) {
            boolean fullstop = false;
            ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
            List<BlockPos> listed = this.getValidList(pedestal);
            ArrayList<ItemStack> ingredientList = new ArrayList<ItemStack>();
            for (int i = 0; i < listed.size(); ++i) {
                BlockEntity invToCheck = level.m_7702_(listed.get(i));
                if (invToCheck == null) {
                    fullstop = true;
                    break;
                }
                if (!(invToCheck instanceof BasePedestalBlockEntity)) continue;
                BasePedestalBlockEntity pedestalToCheck = (BasePedestalBlockEntity)invToCheck;
                ingredientList.add(pedestalToCheck.getItemInPedestal());
            }
            if (!fullstop && ingredientList.size() > 0) {
                if (this.hasCachedRecipe(coinInPedestal)) {
                    List<ItemStack> stackResult = this.getResultFromCachedRecipe(coinInPedestal, ingredientList);
                    ItemStack result = stackResult.stream().findFirst().orElse(ItemStack.f_41583_);
                    if (!result.m_41619_()) {
                        if (pedestal.addItem(result, true)) {
                            for (int j = 0; j < listed.size(); ++j) {
                                BlockEntity invToCheck = level.m_7702_(listed.get(j));
                                if (invToCheck == null) {
                                    fullstop = true;
                                    break;
                                }
                                if (!(invToCheck instanceof BasePedestalBlockEntity)) continue;
                                BasePedestalBlockEntity pedestalToCheck = (BasePedestalBlockEntity)invToCheck;
                                ItemStack pedestalToCheckStack = pedestalToCheck.getItemInPedestal().m_41777_();
                                if (pedestalToCheck.removeItem(1, true).m_41619_()) continue;
                                pedestalToCheck.removeItem(1, false);
                                if (pedestalToCheckStack.hasCraftingRemainingItem()) {
                                    pedestal.addItem(pedestalToCheckStack.getCraftingRemainingItem(), false);
                                }
                                BlockPos pedestalToCheckPoint = this.getPosOfBlockBelow(level, pedestalToCheck.getPos(), -1);
                                if (!pedestal.canSpawnParticles()) continue;
                                MowLibPacketHandler.sendToNearby((Level)pedestalToCheck.m_58904_(), (BlockPos)pedestalToCheck.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalToCheckPoint.m_123341_(), (double)pedestalToCheckPoint.m_123342_(), (double)pedestalToCheckPoint.m_123343_(), new int[]{50, 200, 0}));
                            }
                            if (!fullstop) {
                                for (ItemStack stacks : stackResult) {
                                    if (pedestal.addItem(stacks, true)) {
                                        pedestal.addItem(stacks, false);
                                        continue;
                                    }
                                    BlockPos pedestalPos = this.getPosOfBlockBelow(level, pedestal.getPos(), -1);
                                    ItemStack dropMe = stacks;
                                    ItemEntity itementity = new ItemEntity(level, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_(), dropMe);
                                    itementity.m_32060_();
                                    itementity.m_20334_(0.0, 0.0, 0.0);
                                    itementity.m_20219_(Vec3.m_82512_((Vec3i)pedestalPos));
                                    level.m_7967_((Entity)itementity);
                                }
                                BlockPos pedestalToCheckPoint = this.getPosOfBlockBelow(level, pedestal.getPos(), -1);
                                if (pedestal.canSpawnParticles()) {
                                    MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalToCheckPoint.m_123341_(), (double)pedestalToCheckPoint.m_123342_(), (double)pedestalToCheckPoint.m_123343_(), new int[]{0, 255, 0}));
                                }
                            }
                        } else {
                            BlockPos pedestalToCheckPoint = this.getPosOfBlockBelow(level, pedestal.getPos(), -1);
                            if (pedestal.canSpawnParticles()) {
                                MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalToCheckPoint.m_123341_(), (double)pedestalToCheckPoint.m_123342_(), (double)pedestalToCheckPoint.m_123343_(), new int[]{50, 50, 50}));
                            }
                        }
                    } else {
                        this.cacheRecipe(pedestal, coinInPedestal, ingredientList);
                    }
                } else {
                    this.cacheRecipe(pedestal, coinInPedestal, ingredientList);
                }
            }
        }
    }
}

