/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardBase;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;

public class ItemUpgradeBreeder
extends ItemUpgradeBase {
    public ItemUpgradeBreeder(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard() {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_breeder_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_breeder_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_breeder_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_breeder_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_breeder_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_breeder_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_breeder_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_breeder_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_breeder_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_breeder_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_breeder_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_breeder_selectedMultiplier.get();
    }

    public boolean hasBreederLimit() {
        return (Boolean)PedestalConfig.COMMON.upgrade_breeder_entityBreedingLimit.get();
    }

    public int getBreederLimitCount() {
        return (Integer)PedestalConfig.COMMON.upgrade_breeder_entityLimitBreedingCount.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        WorkCardBase workCardBase;
        ItemStack card;
        Item item;
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase && (workCardBase = (WorkCardBase)item).hasTwoPointsSelected(card)) {
            WeakReference<FakePlayer> getPlayer;
            boolean canRun = true;
            if (this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), pedestalPos), true) && (getPlayer = pedestal.getPedestalPlayer(pedestal)) != null && getPlayer.get() != null) {
                AABB getArea = workCardBase.getAABBonUpgrade(card);
                List entities = level.m_45976_(LivingEntity.class, getArea);
                ItemStack toolStack = pedestal.hasItem() ? pedestal.getItemInPedestal() : pedestal.getToolStack();
                ItemUpgradeBreeder.tryEquipItem(toolStack, getPlayer, InteractionHand.MAIN_HAND);
                if (this.hasBreederLimit() && entities.size() >= this.getBreederLimitCount()) {
                    canRun = false;
                }
                if (canRun) {
                    for (LivingEntity getEntity : entities) {
                        InteractionResult result;
                        Animal animal;
                        if (getEntity == null) continue;
                        BlockPos getEntityPos = getEntity.m_20097_();
                        if (!(getEntity instanceof Animal) || !(animal = (Animal)getEntity).m_6898_(toolStack) || animal.m_146764_() != 0 || !animal.m_5957_() || (result = animal.m_6071_(getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get(), InteractionHand.MAIN_HAND)) != InteractionResult.SUCCESS || !this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), getEntityPos), false)) continue;
                        pedestal.removeItem(1, false);
                    }
                }
            }
        }
    }
}

