/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Filters.BaseFilter;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardBase;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeBlockBreaker
extends ItemUpgradeBase {
    public ItemUpgradeBlockBreaker(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard() {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 0;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_blockbreaker_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_blockbreaker_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_blockbreaker_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_blockbreaker_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        return new ItemStack((ItemLike)Items.f_42427_);
    }

    private void buildValidBlockList(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        ItemStack coin = pedestal.getCoinOnPedestal();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            List<BlockPos> listed = WorkCardBase.readBlockPosListFromNBT(card);
            ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
            for (BlockPos pos : listed) {
                if (!workCardBase.selectedPointWithinRange(pedestal, pos)) continue;
                valid.add(pos);
            }
            ItemUpgradeBlockBreaker.saveBlockPosListCustomToNBT(coin, "_validlist", valid);
        }
    }

    private void buildValidBlockListArea(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        ItemStack coin = pedestal.getCoinOnPedestal();
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            AABB area = new AABB(WorkCardBase.readBlockPosFromNBT(card, 1), WorkCardBase.readBlockPosFromNBT(card, 2));
            int maxX = (int)area.f_82291_;
            int maxY = (int)area.f_82292_;
            int maxZ = (int)area.f_82293_;
            int minX = (int)area.f_82288_;
            int minY = (int)area.f_82289_;
            int minZ = (int)area.f_82290_;
            BlockPos pedestalPos = pedestal.getPos();
            if (minY < pedestalPos.m_123342_()) {
                for (int i = maxX; i >= minX; --i) {
                    for (int j = maxZ; j >= minZ; --j) {
                        for (int k = maxY; k >= minY; --k) {
                            BlockPos newPoint = new BlockPos(i, k, j);
                            if (!workCardBase.selectedPointWithinRange(pedestal, newPoint)) continue;
                            valid.add(newPoint);
                        }
                    }
                }
            } else {
                for (int i = minX; i <= maxX; ++i) {
                    for (int j = minZ; j <= maxZ; ++j) {
                        for (int k = minY; k <= maxY; ++k) {
                            BlockPos newPoint = new BlockPos(i, k, j);
                            if (!workCardBase.selectedPointWithinRange(pedestal, newPoint)) continue;
                            valid.add(newPoint);
                        }
                    }
                }
            }
        }
        ItemUpgradeBlockBreaker.saveBlockPosListCustomToNBT(coin, "_validlist", valid);
    }

    private List<BlockPos> getValidList(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return ItemUpgradeBlockBreaker.readBlockPosListCustomFromNBT(coin, "_validlist");
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.removeBlockListCustomNBTTags(coinInPedestal, "_validlist");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numdelay");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numheight");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_boolstop");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        ItemStack card;
        Item item;
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            boolean override = workCardBase.hasTwoPointsSelected(card);
            List<BlockPos> listed = this.getValidList(pedestal);
            if (override) {
                if (listed.size() > 0) {
                    this.breakerAction(level, pedestal);
                } else if (workCardBase.selectedAreaWithinRange(pedestal) && !this.hasBlockListCustomNBTTags(coin, "_validlist")) {
                    this.buildValidBlockListArea(pedestal);
                }
            } else {
                List<BlockPos> getList = WorkCardBase.readBlockPosListFromNBT(card);
                if (!override && listed.size() > 0) {
                    this.breakerAction(level, pedestal);
                } else if (getList.size() > 0 && !this.hasBlockListCustomNBTTags(coin, "_validlist")) {
                    BlockPos hasValidPos = IntStream.range(0, getList.size()).mapToObj(getList::get).filter(blockPos -> this.selectedPointWithinRange(pedestal, (BlockPos)blockPos)).findFirst().orElse(BlockPos.f_121853_);
                    if (!hasValidPos.equals((Object)BlockPos.f_121853_)) {
                        this.buildValidBlockList(pedestal);
                    }
                }
            }
        }
    }

    private int getCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private void iterateCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentPosition(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1), (String)"_numposition");
    }

    private boolean isToolHighEnoughLevelForBlock(ItemStack toolIn, BlockState getBlock) {
        Item item = toolIn.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            Tier toolTier = tieredItem.m_43314_();
            return TierSortingRegistry.isCorrectTierForDrops((Tier)toolTier, (BlockState)getBlock);
        }
        return false;
    }

    private List<ItemStack> getBlockDrops(BasePedestalBlockEntity pedestal, BlockState blockTarget, BlockPos posTarget) {
        ItemStack getToolFromPedestal = pedestal.getToolStack().m_41619_() ? new ItemStack((ItemLike)Items.f_42427_) : pedestal.getToolStack();
        Level level = pedestal.m_58904_();
        if (blockTarget.m_60734_() != Blocks.f_50016_) {
            WeakReference<FakePlayer> getPlayer = pedestal.getPedestalPlayer(pedestal);
            if (getPlayer != null && getPlayer.get() != null) {
                LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_())).m_78984_(LootContextParams.f_81455_, (Object)((Entity)getPlayer.get())).m_78972_(LootContextParams.f_81463_, (Object)getToolFromPedestal);
                return blockTarget.m_60724_(builder);
            }
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pedestal.getPos().m_123341_(), (double)pedestal.getPos().m_123342_(), (double)pedestal.getPos().m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)getToolFromPedestal);
            return blockTarget.m_60724_(builder);
        }
        return new ArrayList<ItemStack>();
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, BlockState canMineBlock, BlockPos canMinePos) {
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInPedestal()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral()) {
            ItemStack blockToCheck = ItemStack.f_41583_;
            if (canMineBlock.m_60734_() instanceof Block) {
                blockToCheck = canMineBlock.m_60734_().m_7397_((BlockGetter)pedestal.m_58904_(), canMinePos, canMineBlock);
            }
            return filter.canAcceptItems(filterInPedestal, blockToCheck);
        }
        return true;
    }

    private void dropXP(Level level, BasePedestalBlockEntity pedestal, BlockState blockAtPoint, BlockPos currentPoint) {
        int fortune = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44987_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)pedestal.getToolStack()) : 0;
        int silky = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44985_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)pedestal.getToolStack()) : 0;
        int xpdrop = blockAtPoint.m_60734_().getExpDrop(blockAtPoint, (LevelReader)level, level.f_46441_, currentPoint, fortune, silky);
        if (xpdrop > 0) {
            blockAtPoint.m_60734_().m_49805_((ServerLevel)level, currentPoint, xpdrop);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void breakerAction(Level level, BasePedestalBlockEntity pedestal) {
        boolean fuelRemoved;
        int currentPosition;
        List<BlockPos> listed;
        block11: {
            block12: {
                List<ItemStack> drops;
                boolean damage;
                BlockState blockAtPoint;
                BlockPos currentPoint;
                block13: {
                    BlockEvent.BreakEvent e;
                    if (level.m_5776_()) return;
                    WeakReference<FakePlayer> getPlayer = pedestal.getPedestalPlayer(pedestal);
                    if (getPlayer == null) return;
                    if (getPlayer.get() == null) return;
                    listed = this.getValidList(pedestal);
                    currentPosition = this.getCurrentPosition(pedestal);
                    currentPoint = listed.get(currentPosition);
                    blockAtPoint = level.m_8055_(currentPoint);
                    fuelRemoved = true;
                    if (blockAtPoint.m_60734_().equals(Blocks.f_50016_) || !(blockAtPoint.m_60800_((BlockGetter)level, currentPoint) >= 0.0f) || !this.passesFilter(pedestal, blockAtPoint, currentPoint) || ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_break"))).stream().toList().contains(blockAtPoint.m_60734_()) || !ForgeEventFactory.doPlayerHarvestCheck((Player)(getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get()), (BlockState)blockAtPoint, (boolean)true) || MinecraftForge.EVENT_BUS.post((Event)(e = new BlockEvent.BreakEvent(level, currentPoint, blockAtPoint, getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get())))) break block11;
                    damage = false;
                    if (currentPoint.equals((Object)pedestal.getPos()) || !this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), currentPoint), true)) break block11;
                    if (((Boolean)PedestalConfig.COMMON.blockBreakerDamageTools.get()).booleanValue() && pedestal.hasTool()) {
                        BlockPos pedestalPos = pedestal.getPos();
                        if (pedestal.getDurabilityRemainingOnInsertedTool() <= 0) {
                            if (!pedestal.canSpawnParticles()) return;
                            MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                            return;
                        }
                        if (!pedestal.damageInsertedTool(1, true)) {
                            if (!pedestal.canSpawnParticles()) return;
                            MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                            return;
                        }
                        damage = true;
                    }
                    if (!this.removeFuelForAction(pedestal, this.getDistanceBetweenPoints(pedestal.getPos(), currentPoint), false)) break block12;
                    boolean canRemoveBlockEntities = (Boolean)PedestalConfig.COMMON.blockBreakerBreakEntities.get();
                    drops = this.getBlockDrops(pedestal, blockAtPoint, currentPoint);
                    if (level.m_7702_(currentPoint) == null) break block13;
                    if (canRemoveBlockEntities) {
                        blockAtPoint.m_60753_(level, currentPoint, blockAtPoint, true);
                        this.dropXP(level, pedestal, blockAtPoint, currentPoint);
                        level.m_46747_(currentPoint);
                        level.m_46597_(currentPoint, Blocks.f_50016_.m_49966_());
                        if (damage) {
                            pedestal.damageInsertedTool(1, false);
                        }
                        if (drops.size() > 0) {
                            for (ItemStack stack : drops) {
                                MowLibItemUtils.spawnItemStack((Level)level, (double)currentPoint.m_123341_(), (double)currentPoint.m_123342_(), (double)currentPoint.m_123343_(), (ItemStack)stack);
                            }
                        }
                    }
                    break block11;
                }
                this.dropXP(level, pedestal, blockAtPoint, currentPoint);
                level.m_46597_(currentPoint, Blocks.f_50016_.m_49966_());
                if (damage) {
                    pedestal.damageInsertedTool(1, false);
                }
                if (drops.size() > 0) {
                    for (ItemStack stack : drops) {
                        MowLibItemUtils.spawnItemStack((Level)level, (double)currentPoint.m_123341_(), (double)currentPoint.m_123342_(), (double)currentPoint.m_123343_(), (ItemStack)stack);
                    }
                }
                break block11;
            }
            fuelRemoved = false;
        }
        if (currentPosition + 1 >= listed.size()) {
            this.setCurrentPosition(pedestal, 0);
            return;
        }
        if (!fuelRemoved) return;
        this.iterateCurrentPosition(pedestal);
    }
}

