/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Filters;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Items.Filters.IItemMode;
import com.mowmaster.mowlib.Items.Filters.IPedestalFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.pedestals.Items.Filters.BaseFilter;
import com.mowmaster.pedestals.Registry.DeferredRegisterItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FilterDurability
extends BaseFilter {
    public FilterDurability(Item.Properties p_41383_) {
        super(p_41383_, IPedestalFilter.FilterDirection.INSERT);
    }

    public int getPercentDamaged(ItemStack itemIn) {
        if (itemIn.m_41763_()) {
            int maxDamage = itemIn.m_41776_();
            int damage = itemIn.m_41773_();
            int durabilityCurrent = maxDamage - damage;
            int percentDurability = Math.floorDiv(durabilityCurrent * 100, maxDamage);
            return percentDurability;
        }
        return 100;
    }

    public int getDurabilityTarget(ItemStack filter) {
        int returner = 0;
        List filterQueue = this.readFilterQueueFromNBT(filter, this.getItemTransportMode(filter));
        if (filterQueue.size() > 0) {
            ItemStack stackGet;
            for (int i = 0; i < filterQueue.size() && (returner += this.getPercentDamaged(stackGet = (ItemStack)filterQueue.get(i))) <= 100; ++i) {
            }
        }
        return returner > 100 ? 100 : returner;
    }

    public boolean canModeUseInventoryAsFilter(IItemMode.ItemTransferMode mode) {
        switch (mode) {
            case ITEMS: {
                return true;
            }
            case FLUIDS: {
                return false;
            }
            case ENERGY: {
                return false;
            }
            case EXPERIENCE: {
                return false;
            }
            case DUST: {
                return false;
            }
        }
        return false;
    }

    public boolean canAcceptItems(ItemStack filter, ItemStack incomingStack) {
        boolean filterBool = super.canAcceptItems(filter, incomingStack);
        int durabilityTarget = this.getDurabilityTarget(filter);
        int percentDurabilityCurrent = this.getPercentDamaged(incomingStack);
        int percentToBeat = durabilityTarget;
        if (filterBool) {
            return incomingStack.m_41763_() ? percentDurabilityCurrent >= percentToBeat : false;
        }
        return incomingStack.m_41763_() ? percentDurabilityCurrent <= percentToBeat : false;
    }

    @Override
    public void chatDetails(Player player, MowLibBaseBlockEntity pedestal, ItemStack filterStack) {
        if (!filterStack.m_41720_().equals(DeferredRegisterItems.FILTER_BASE.get())) {
            MowLibMessageUtils.messagePlayerChatText((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)filterStack.m_41611_().getString());
            boolean filterType = this.getFilterType(filterStack, this.getItemTransportMode(filterStack));
            String above = "pedestals.filters.tooltip_filterabove";
            String below = "pedestals.filters.tooltip_filterbelow";
            ArrayList<String> listed = new ArrayList<String>();
            listed.add(filterType ? below : above);
            MowLibMessageUtils.messagePlayerChatWithAppend((String)"pedestals", (Player)player, (ChatFormatting)ChatFormatting.GOLD, (String)"pedestals.filters.tooltip_filtertype", listed);
            List filterQueue = this.readFilterQueueFromNBT(filterStack, this.getItemTransportMode(filterStack));
            if (filterQueue.size() > 0) {
                MowLibMessageUtils.messagePlayerChat((Player)player, (ChatFormatting)ChatFormatting.LIGHT_PURPLE, (String)"pedestals.filters.tooltip_filterlist");
                MowLibMessageUtils.messagePlayerChatText((Player)player, (ChatFormatting)ChatFormatting.GRAY, (String)("" + this.getDurabilityTarget(filterStack)));
            }
        } else {
            MowLibMessageUtils.messagePlayerChat((Player)player, (ChatFormatting)ChatFormatting.DARK_RED, (String)"pedestals.baseItem");
        }
    }

    public void setFilterType(Player player, ItemStack heldItem) {
        this.setFilterTypeCustom(player, heldItem, ".filter_type_below", ".filter_type_above", ChatFormatting.BLACK, ChatFormatting.WHITE, ".filter_type_changed");
    }

    public Component filterTypeTooltip(IItemMode.ItemTransferMode mode, boolean filterType) {
        MutableComponent filterList = Component.m_237115_((String)"pedestals.filter_type");
        MutableComponent white = Component.m_237115_((String)"pedestals.filter_type_above");
        MutableComponent black = Component.m_237115_((String)"pedestals.filter_type_below");
        filterList.m_7220_((Component)(filterType ? black : white));
        filterList.m_130940_(ChatFormatting.WHITE);
        return filterList;
    }
}

