/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Filters;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.Filters.IItemMode;
import com.mowmaster.mowlib.Items.Filters.IPedestalFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibFluidUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.pedestals.Items.Filters.BaseFilter;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilterBlocksByClickExact
extends BaseFilter {
    public FilterBlocksByClickExact(Item.Properties p_41383_) {
        super(p_41383_, IPedestalFilter.FilterDirection.NEUTRAL);
    }

    public boolean canModeUseInventoryAsFilter(IItemMode.ItemTransferMode mode) {
        return false;
    }

    public boolean canSetFilterType(IItemMode.ItemTransferMode mode) {
        return true;
    }

    public boolean canSetFilterMode(IItemMode.ItemTransferMode mode) {
        return true;
    }

    public boolean showFilterDirection() {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        ItemStack itemInMainhand = p_41433_.m_21205_();
        ItemStack itemInOffhand = p_41433_.m_21206_();
        HitResult result = p_41433_.m_19907_(5.0, 0.0f, false);
        if (!p_41432_.m_5776_()) {
            if (itemInOffhand.m_41720_() instanceof IPedestalFilter && !(itemInMainhand.m_41720_() instanceof IPedestalFilter)) {
                if (result.m_6662_().equals((Object)HitResult.Type.MISS)) {
                    if (p_41433_.m_6047_()) {
                        this.setFilterMode(p_41433_, itemInOffhand, InteractionHand.OFF_HAND);
                    } else {
                        this.setFilterType(p_41433_, itemInOffhand);
                    }
                } else if (result.m_6662_().equals((Object)HitResult.Type.BLOCK) && p_41433_.m_6047_()) {
                    UseOnContext context = new UseOnContext(p_41433_, p_41434_, (BlockHitResult)result);
                    BlockHitResult res = new BlockHitResult(context.m_43720_(), context.m_8125_(), context.m_8083_(), false);
                    BlockPos posBlock = res.m_82425_();
                    ItemStack clickedBlock = p_41432_.m_8055_(posBlock).getCloneItemStack((HitResult)res, (BlockGetter)p_41432_, posBlock, p_41433_);
                    List currentQueue = this.readFilterQueueFromNBT(itemInOffhand, this.getItemTransportMode(itemInOffhand));
                    int currentQueueSize = currentQueue.size();
                    if (!clickedBlock.m_41619_()) {
                        List<ItemStack> adjustedQueue = this.addNonMatchRemoveMatching(currentQueue, clickedBlock);
                        MowLibMessageUtils.messagePopup((Player)p_41433_, (ChatFormatting)this.getItemTransportMode(itemInOffhand).getModeColorFormat(), (String)(currentQueueSize < adjustedQueue.size() ? "pedestals.filter_changed_added" : "pedestals.filter_changed_removed"));
                        this.writeFilterQueueToNBT(itemInOffhand, adjustedQueue, this.getItemTransportMode(itemInOffhand));
                    }
                }
            } else if (itemInOffhand.m_41720_() instanceof IPedestalFilter && itemInMainhand.m_41720_() instanceof IPedestalFilter) {
                MowLibMessageUtils.messagePopup((Player)p_41433_, (ChatFormatting)ChatFormatting.RED, (String)"mowlib.filter.message_twohanded");
            }
        }
        return InteractionResultHolder.m_19100_((Object)p_41433_.m_21120_(p_41434_));
    }

    private List<ItemStack> addNonMatchRemoveMatching(List<ItemStack> list, ItemStack stackToCheck) {
        boolean canAdd = true;
        for (int i = 0; i < list.size(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)list.get(i), (ItemStack)stackToCheck)) continue;
            list.remove(i);
            canAdd = false;
            break;
        }
        if (canAdd) {
            list.add(stackToCheck);
        }
        return list;
    }

    public boolean canAcceptItems(ItemStack filter, ItemStack incomingStack) {
        boolean filterBool = super.canAcceptItems(filter, incomingStack);
        List stackCurrent = this.readFilterQueueFromNBT(filter, IItemMode.ItemTransferMode.ITEMS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> this.doItemsMatch((ItemStack)itemStack, incomingStack)).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }

    public boolean canAcceptFluids(ItemStack filter, FluidStack incomingFluidStack) {
        boolean filterBool = super.canAcceptFluids(filter, incomingFluidStack);
        List stackCurrent = this.readFilterQueueFromNBT(filter, IItemMode.ItemTransferMode.FLUIDS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> !MowLibFluidUtils.getFluidStackFromItemStack((ItemStack)itemStack).isEmpty()).filter(itemStack -> MowLibFluidUtils.getFluidStackFromItemStack((ItemStack)itemStack).equals((Object)incomingFluidStack)).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }

    public boolean canAcceptDust(ItemStack filter, DustMagic incomingDust) {
        boolean filterBool = super.canAcceptDust(filter, incomingDust);
        List stackCurrent = this.readFilterQueueFromNBT(filter, IItemMode.ItemTransferMode.DUST);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> !DustMagic.getDustMagicInItemStack((ItemStack)itemStack).isEmpty()).filter(itemStack -> DustMagic.getDustMagicInItemStack((ItemStack)itemStack).isDustEqual(incomingDust)).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }
}

