/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Blocks.Pedestal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlock;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.ISelectableArea;
import com.mowmaster.pedestals.Items.ISelectablePoints;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Items.WorkCards.WorkCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BasePedestalBlockEntityRenderer
implements BlockEntityRenderer<BasePedestalBlockEntity> {
    public BasePedestalBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BasePedestalBlockEntity p_112307_, float p_112308_, PoseStack p_112309_, MultiBufferSource p_112310_, int p_112311_, int p_112312_) {
        if (!p_112307_.m_58901_()) {
            Item item;
            Item aabb;
            TextureAtlasSprite whiteTextureSprite;
            int range;
            Direction facing = (Direction)p_112307_.m_58900_().m_61143_((Property)BasePedestalBlock.FACING);
            List<ItemStack> listed = p_112307_.getItemStacks();
            ItemStack stack = p_112307_.getItemInPedestalFirst();
            ItemStack toolStack = p_112307_.getToolStack();
            ItemStack coin = p_112307_.getCoinOnPedestal();
            ItemStack workCard = p_112307_.getWorkCardInPedestal();
            List<BlockPos> linkedLocations = p_112307_.getLinkedLocations();
            BlockPos pos = p_112307_.getPos();
            Level world = p_112307_.m_58904_();
            List<String> hudMessages = p_112307_.getHudLog();
            int renderAugmentType = p_112307_.getRendererType();
            if (p_112307_.getRenderRange()) {
                range = p_112307_.getLinkingRange();
                whiteTextureSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("pedestals", "util/pedestal_render"));
                aabb = new AABB((double)(pos.m_123341_() - range + 1), (double)(pos.m_123342_() - range), (double)(pos.m_123343_() - range + 1), (double)(pos.m_123341_() + range), (double)(pos.m_123342_() + range), (double)(pos.m_123343_() + range));
                p_112309_.m_85836_();
                this.renderBoundingBox(pos, (AABB)aabb, p_112309_, p_112310_.m_6299_(RenderType.m_110504_()), p_112307_, 1.0f, 0.2f, 0.2f, 1.0f);
                this.renderFaces(whiteTextureSprite, pos, (AABB)aabb, p_112309_, p_112310_.m_6299_(Sheets.m_110792_()), p_112307_, 1.0f, 0.2f, 0.2f, 0.5f);
                p_112309_.m_85849_();
                if (linkedLocations.size() > 0) {
                    ArrayList<BlockPos> resetList = new ArrayList<BlockPos>();
                    p_112309_.m_85836_();
                    item = linkedLocations.iterator();
                    while (item.hasNext()) {
                        AABB aabbCoin;
                        BlockPos posPoints = item.next();
                        if (resetList.contains(posPoints) || (aabbCoin = new AABB(posPoints)) == new AABB(BlockPos.f_121853_)) continue;
                        TextureAtlasSprite upgradeTextureSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("pedestals", "util/pedestal_render_" + (linkedLocations.indexOf(posPoints) + 1)));
                        this.renderBoundingBox(pos, aabbCoin, p_112309_, p_112310_.m_6299_(RenderType.m_110504_()), p_112307_, 0.0f, 0.0f, 1.0f, 1.0f);
                        this.renderFaces(upgradeTextureSprite, pos, aabbCoin, p_112309_, p_112310_.m_6299_(Sheets.m_110792_()), p_112307_, 0.0f, 0.0f, 1.0f, 0.5f);
                        resetList.add(posPoints);
                    }
                    p_112309_.m_85849_();
                }
            } else {
                linkedLocations.clear();
            }
            if (p_112307_.getRenderRangeUpgrade() && !coin.m_41619_()) {
                range = 0;
                aabb = coin.m_41720_();
                if (aabb instanceof ItemUpgradeBase) {
                    ItemUpgradeBase upgrade = (ItemUpgradeBase)aabb;
                    range = upgrade.getUpgradeWorkRange(coin);
                }
                if (range > 0) {
                    Item aabbCoin;
                    WorkCardBase cardBase;
                    whiteTextureSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("pedestals", "util/pedestal_render"));
                    aabb = new AABB((double)(pos.m_123341_() - range), (double)(pos.m_123342_() - range), (double)(pos.m_123343_() - range), (double)(pos.m_123341_() + range + 1), (double)(pos.m_123342_() + range), (double)(pos.m_123343_() + range + 1));
                    p_112309_.m_85836_();
                    this.renderBoundingBox(pos, (AABB)aabb, p_112309_, p_112310_.m_6299_(RenderType.m_110504_()), p_112307_, 0.2f, 0.2f, 1.0f, 1.0f);
                    this.renderFaces(whiteTextureSprite, pos, (AABB)aabb, p_112309_, p_112310_.m_6299_(Sheets.m_110792_()), p_112307_, 0.2f, 0.2f, 1.0f, 0.5f);
                    p_112309_.m_85849_();
                    if (workCard.m_41720_() instanceof ISelectableArea && (item = workCard.m_41720_()) instanceof WorkCardBase && (cardBase = (WorkCardBase)item).hasTwoPointsSelected(workCard)) {
                        p_112309_.m_85836_();
                        aabbCoin = cardBase.getAABBonUpgrade(workCard);
                        if (aabbCoin != new AABB(BlockPos.f_121853_)) {
                            Boolean inSelectedInRange = cardBase.selectedAreaWithinRange(p_112307_);
                            TextureAtlasSprite upgradeTextureSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("pedestals", "util/upgrade_render"));
                            this.renderBoundingBox(pos, (AABB)aabbCoin, p_112309_, p_112310_.m_6299_(RenderType.m_110504_()), p_112307_, inSelectedInRange != false ? 0.0f : 1.0f, inSelectedInRange != false ? 1.0f : 0.0f, 0.0f, 1.0f);
                            this.renderFaces(upgradeTextureSprite, pos, (AABB)aabbCoin, p_112309_, p_112310_.m_6299_(Sheets.m_110792_()), p_112307_, inSelectedInRange != false ? 0.0f : 1.0f, inSelectedInRange != false ? 1.0f : 0.0f, 0.0f, 0.5f);
                        }
                        p_112309_.m_85849_();
                    }
                    if (workCard.m_41720_() instanceof ISelectablePoints && (aabbCoin = workCard.m_41720_()) instanceof WorkCardBase && !(cardBase = (WorkCardBase)aabbCoin).hasTwoPointsSelected(workCard)) {
                        p_112309_.m_85836_();
                        List<BlockPos> locations = WorkCardBase.readBlockPosListFromNBT(workCard);
                        if (locations.size() > 0) {
                            for (BlockPos posPoints : locations) {
                                AABB aabbCoin2 = new AABB(posPoints);
                                if (aabbCoin2 == new AABB(BlockPos.f_121853_)) continue;
                                Boolean inSelectedInRange = cardBase.selectedPointWithinRange(p_112307_, posPoints);
                                TextureAtlasSprite upgradeTextureSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("pedestals", "util/upgrade_render"));
                                this.renderBoundingBox(pos, aabbCoin2, p_112309_, p_112310_.m_6299_(RenderType.m_110504_()), p_112307_, inSelectedInRange != false ? 0.0f : 1.0f, inSelectedInRange != false ? 1.0f : 0.0f, 0.0f, 1.0f);
                                this.renderFaces(upgradeTextureSprite, pos, aabbCoin2, p_112309_, p_112310_.m_6299_(Sheets.m_110792_()), p_112307_, inSelectedInRange != false ? 0.0f : 1.0f, inSelectedInRange != false ? 1.0f : 0.0f, 0.0f, 0.5f);
                            }
                        }
                        p_112309_.m_85849_();
                    }
                }
            }
            if (renderAugmentType != 6) {
                if (facing == Direction.UP) {
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
                if (facing == Direction.DOWN) {
                    p_112309_.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                    p_112309_.m_85837_(0.0, -1.0, 0.0);
                    p_112309_.m_85837_(-1.0, 0.0, 0.0);
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
                if (facing == Direction.NORTH) {
                    p_112309_.m_85845_(Vector3f.f_122223_.m_122240_(270.0f));
                    p_112309_.m_85837_(0.0, -1.0, 0.0);
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
                if (facing == Direction.EAST) {
                    p_112309_.m_85845_(Vector3f.f_122227_.m_122240_(270.0f));
                    p_112309_.m_85837_(-1.0, 0.0, 0.0);
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
                if (facing == Direction.SOUTH) {
                    p_112309_.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                    p_112309_.m_85837_(0.0, 0.0, -1.0);
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
                if (facing == Direction.WEST) {
                    p_112309_.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                    p_112309_.m_85837_(0.0, -1.0, 0.0);
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
            }
        }
    }

    public static void renderTile(Level worldIn, PoseStack p_112309_, MultiBufferSource p_112310_, ItemStack item, ItemStack coin, int p_112311_, int p_112312_, int renderAugmentType) {
        switch (renderAugmentType) {
            case 0: {
                BasePedestalBlockEntityRenderer.renderItemRotating(worldIn, p_112309_, p_112310_, item, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.3125f, 0.0f, 0.0f, 0.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.3125f, 0.475f, 0.5f, 90.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.6875f, 180.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.6875f, 0.475f, 0.5f, 270.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                break;
            }
            case 1: {
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.3125f, 0.0f, 0.0f, 0.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.3125f, 0.475f, 0.5f, 90.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.6875f, 180.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.6875f, 0.475f, 0.5f, 270.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                break;
            }
            case 2: {
                BasePedestalBlockEntityRenderer.renderItemRotating(worldIn, p_112309_, p_112310_, item, p_112311_, p_112312_);
                break;
            }
            case 3: {
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.3125f, 0.0f, 0.0f, 0.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.3125f, 0.475f, 0.5f, 90.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.6875f, 180.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.6875f, 0.475f, 0.5f, 270.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                break;
            }
            case 4: {
                BasePedestalBlockEntityRenderer.renderItemRotating(worldIn, p_112309_, p_112310_, item, p_112311_, p_112312_);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                BasePedestalBlockEntityRenderer.renderItemRotating(worldIn, p_112309_, p_112310_, item, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.3125f, 0.0f, 0.0f, 0.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.3125f, 0.475f, 0.5f, 90.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.6875f, 180.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.6875f, 0.475f, 0.5f, 270.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                break;
            }
            default: {
                BasePedestalBlockEntityRenderer.renderItemRotating(worldIn, p_112309_, p_112310_, item, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.3125f, 0.0f, 0.0f, 0.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.3125f, 0.475f, 0.5f, 90.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.6875f, 180.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.6875f, 0.475f, 0.5f, 270.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
            }
        }
    }

    public static void renderItemRotating(Level worldIn, PoseStack p_112309_, MultiBufferSource p_112310_, ItemStack itemStack, int p_112311_, int p_112312_) {
        if (!itemStack.m_41619_()) {
            p_112309_.m_85836_();
            p_112309_.m_85837_(0.5, 1.0, 0.5);
            p_112309_.m_85841_(0.75f, 0.75f, 0.75f);
            long time = System.currentTimeMillis();
            float angle = time / 25L % 360L;
            p_112309_.m_85845_(Vector3f.f_122225_.m_122240_(angle));
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel baked = renderer.m_174264_(itemStack, worldIn, null, 0);
            renderer.m_115143_(itemStack, ItemTransforms.TransformType.GROUND, true, p_112309_, p_112310_, p_112311_, p_112312_, baked);
            p_112309_.m_85849_();
        }
    }

    public static void renderTileItems(Level worldIn, PoseStack p_112309_, MultiBufferSource p_112310_, List<ItemStack> item, ItemStack coin, ItemStack toolStack, int p_112311_, int p_112312_, int renderAugmentType, List<String> messages) {
        switch (renderAugmentType) {
            case 0: {
                BasePedestalBlockEntityRenderer.renderItemsRotating(worldIn, p_112309_, p_112310_, item, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.3125f, 0.0f, 0.0f, 0.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.3125f, 0.475f, 0.5f, 90.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.6875f, 180.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.6875f, 0.475f, 0.5f, 270.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderTool(worldIn, toolStack, p_112309_, p_112310_, p_112311_, p_112312_);
                if (messages.size() > 0) {
                    BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, -0.75f, 2.25f, 0.5f, 180, 0);
                }
                if (messages.size() <= 0) break;
                BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, 1.5f, 2.25f, 0.5f, 180, 180);
                break;
            }
            case 1: {
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.3125f, 0.0f, 0.0f, 0.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.3125f, 0.475f, 0.5f, 90.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.6875f, 180.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.6875f, 0.475f, 0.5f, 270.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderTool(worldIn, toolStack, p_112309_, p_112310_, p_112311_, p_112312_);
                if (messages.size() > 0) {
                    BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, -0.75f, 2.25f, 0.5f, 180, 0);
                }
                if (messages.size() <= 0) break;
                BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, 1.5f, 2.25f, 0.5f, 180, 180);
                break;
            }
            case 2: {
                BasePedestalBlockEntityRenderer.renderItemsRotating(worldIn, p_112309_, p_112310_, item, p_112311_, p_112312_);
                if (messages.size() > 0) {
                    BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, -0.75f, 2.25f, 0.5f, 180, 0);
                }
                if (messages.size() <= 0) break;
                BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, 1.5f, 2.25f, 0.5f, 180, 180);
                break;
            }
            case 3: {
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.3125f, 0.0f, 0.0f, 0.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.3125f, 0.475f, 0.5f, 90.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.6875f, 180.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.6875f, 0.475f, 0.5f, 270.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderTool(worldIn, toolStack, p_112309_, p_112310_, p_112311_, p_112312_);
                if (messages.size() > 0) {
                    BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, -0.75f, 2.25f, 0.5f, 180, 0);
                }
                if (messages.size() <= 0) break;
                BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, 1.5f, 2.25f, 0.5f, 180, 180);
                break;
            }
            case 4: {
                BasePedestalBlockEntityRenderer.renderItemsRotating(worldIn, p_112309_, p_112310_, item, p_112311_, p_112312_);
                if (messages.size() > 0) {
                    BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, -0.75f, 2.25f, 0.5f, 180, 0);
                }
                if (messages.size() <= 0) break;
                BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, 1.5f, 2.25f, 0.5f, 180, 180);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                BasePedestalBlockEntityRenderer.renderItemsRotating(worldIn, p_112309_, p_112310_, item, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.3125f, 0.0f, 0.0f, 0.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.3125f, 0.475f, 0.5f, 90.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.6875f, 180.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.6875f, 0.475f, 0.5f, 270.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderTool(worldIn, toolStack, p_112309_, p_112310_, p_112311_, p_112312_);
                if (messages.size() > 0) {
                    BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, -0.75f, 2.25f, 0.5f, 180, 0);
                }
                if (messages.size() <= 0) break;
                BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, 1.5f, 2.25f, 0.5f, 180, 180);
                break;
            }
            default: {
                BasePedestalBlockEntityRenderer.renderItemsRotating(worldIn, p_112309_, p_112310_, item, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.3125f, 0.0f, 0.0f, 0.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.3125f, 0.475f, 0.5f, 90.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.5f, 0.475f, 0.6875f, 180.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, p_112309_, p_112310_, 0.6875f, 0.475f, 0.5f, 270.0f, 0.0f, 1.0f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderTool(worldIn, toolStack, p_112309_, p_112310_, p_112311_, p_112312_);
                if (messages.size() > 0) {
                    BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, -0.75f, 2.25f, 0.5f, 180, 0);
                }
                if (messages.size() <= 0) break;
                BasePedestalBlockEntityRenderer.renderPedestalsHUD(p_112309_, p_112310_, messages, 1.5f, 2.25f, 0.5f, 180, 180);
            }
        }
    }

    public static void renderItemsRotating(Level worldIn, PoseStack posStack, MultiBufferSource buffers, List<ItemStack> listed, int light, int overlay) {
        int stacks = listed.size();
        if (stacks > 1) {
            posStack.m_85836_();
            int items = stacks;
            float[] angles = new float[stacks];
            float anglePer = 360.0f / (float)items;
            float totalAngle = 0.0f;
            for (int i = 0; i < angles.length; ++i) {
                angles[i] = totalAngle += anglePer;
            }
            double time = worldIn.m_46467_();
            float sized = 1.25f;
            float sizedd = 0.25f;
            if (stacks <= 4) {
                sized = 0.25f;
                sizedd = 0.05f;
            }
            if (stacks <= 8 && stacks > 4) {
                sized = 0.5f;
                sizedd = 0.1f;
            }
            if (stacks <= 12 && stacks > 8) {
                sized = 0.75f;
                sizedd = 0.15f;
            }
            if (stacks <= 16 && stacks > 12) {
                sized = 1.0f;
                sizedd = 0.2f;
            }
            for (int i = 0; i < stacks; ++i) {
                posStack.m_85836_();
                posStack.m_85837_(0.5, 0.75, 0.5);
                posStack.m_85845_(Vector3f.f_122225_.m_122240_(angles[i] + (float)time));
                posStack.m_85837_((double)sized, 0.0, (double)sizedd);
                posStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                posStack.m_85837_(0.0, 0.075 * Math.sin((time + (double)(i * 10)) / 5.0), 0.0);
                ItemStack stack = listed.get(i);
                Minecraft mc = Minecraft.m_91087_();
                if (!stack.m_41619_()) {
                    mc.m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, light, overlay, posStack, buffers, 0);
                }
                posStack.m_85849_();
            }
            posStack.m_85849_();
        } else if (stacks == 1) {
            posStack.m_85836_();
            posStack.m_85837_(0.5, 1.0, 0.5);
            posStack.m_85841_(0.75f, 0.75f, 0.75f);
            long time = System.currentTimeMillis();
            float angle = time / 25L % 360L;
            posStack.m_85845_(Vector3f.f_122225_.m_122240_(angle));
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel baked = renderer.m_174264_(listed.get(0), worldIn, null, 0);
            renderer.m_115143_(listed.get(0), ItemTransforms.TransformType.GROUND, true, posStack, buffers, light, overlay, baked);
            posStack.m_85849_();
        }
    }

    public static void renderCoin(Level worldIn, ItemStack itemCoin, PoseStack p_112309_, MultiBufferSource p_112310_, float x, float y, float z, float angle, float xr, float yr, float zr, int p_112311_, int p_112312_) {
        if (!itemCoin.m_41619_()) {
            p_112309_.m_85836_();
            p_112309_.m_85837_((double)x, (double)y, (double)z);
            p_112309_.m_85841_(0.1875f, 0.1875f, 0.1875f);
            p_112309_.m_85845_(Vector3f.f_122225_.m_122240_(angle));
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel baked = renderer.m_174264_(itemCoin, worldIn, null, 0);
            renderer.m_115143_(itemCoin, ItemTransforms.TransformType.FIXED, true, p_112309_, p_112310_, p_112311_, p_112312_, baked);
            p_112309_.m_85849_();
        }
    }

    public static void renderTool(Level worldIn, ItemStack itemTool, PoseStack p_112309_, MultiBufferSource p_112310_, int p_112311_, int p_112312_) {
        if (!itemTool.m_41619_()) {
            p_112309_.m_85836_();
            p_112309_.m_85837_(0.5, 0.75, 0.5);
            p_112309_.m_85841_(0.5f, 0.5f, 0.5f);
            p_112309_.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            p_112309_.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel baked = renderer.m_174264_(itemTool, worldIn, null, 0);
            renderer.m_115143_(itemTool, ItemTransforms.TransformType.FIXED, true, p_112309_, p_112310_, p_112311_, p_112312_, baked);
            p_112309_.m_85849_();
        }
    }

    public void renderBoundingBox(BlockPos pos, AABB aabb, PoseStack matrixStack, VertexConsumer buffer, BasePedestalBlockEntity blockEntity, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        Matrix3f matrix3f = matrixStack.m_85850_().m_85864_();
        float minX = (float)(aabb.f_82288_ - (double)pos.m_123341_());
        float minY = (float)(aabb.f_82289_ - (double)pos.m_123342_());
        float minZ = (float)(aabb.f_82290_ - (double)pos.m_123343_());
        float maxX = (float)(aabb.f_82291_ - (double)pos.m_123341_());
        float maxY = (float)(aabb.f_82292_ - (double)pos.m_123342_());
        float maxZ = (float)(aabb.f_82293_ - (double)pos.m_123343_());
        buffer.m_85982_(matrix4f, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
    }

    public void renderFaces(TextureAtlasSprite sprite, BlockPos pos, AABB aabb, PoseStack matrixStack, VertexConsumer buffer, BasePedestalBlockEntity blockEntity, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        float minX = (float)(aabb.f_82288_ - (double)pos.m_123341_());
        float minY = (float)(aabb.f_82289_ - (double)pos.m_123342_());
        float minZ = (float)(aabb.f_82290_ - (double)pos.m_123343_());
        float maxX = (float)(aabb.f_82291_ - (double)pos.m_123341_());
        float maxY = (float)(aabb.f_82292_ - (double)pos.m_123342_());
        float maxZ = (float)(aabb.f_82293_ - (double)pos.m_123343_());
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        int uvBrightness = 240;
        buffer.m_85982_(matrix4f, minX - 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX - 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX - 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX - 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX + 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX + 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX + 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX + 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX + 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX + 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX + 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX + 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX - 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX - 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX - 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX - 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, minY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, minY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, maxX, maxY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_85982_(matrix4f, minX, maxY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void renderPedestalsHUD(PoseStack matrixStack, MultiBufferSource buffer, List<String> messages, float x, float y, float z, int angleX, int angleY) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, (double)z);
        float f3 = 0.025f;
        matrixStack.m_85841_(f3, f3, f3);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_((float)angleX));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)angleY));
        Font fontrenderer = Minecraft.m_91087_().f_91062_;
        int lines = 11;
        int currenty = 7;
        int height = 10;
        int logsize = messages.size();
        int i = 0;
        for (String s : messages) {
            if (i >= logsize - lines && currenty + height <= 124) {
                String prefix = "";
                fontrenderer.m_92811_(fontrenderer.m_92834_(prefix + s, 115), 7.0f, (float)currenty, 0xFFFFFF, false, matrixStack.m_85850_().m_85861_(), buffer, false, 0, 0xF000F0);
                currenty += height;
            }
            ++i;
        }
        matrixStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(BasePedestalBlockEntity p_112306_) {
        return p_112306_.getRenderRange() || p_112306_.getRenderRangeUpgrade();
    }
}

