/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.client.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import noobanidus.mods.lootr.block.entities.LootrShulkerBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;

public class LootrShulkerBlockRenderer
implements BlockEntityRenderer<LootrShulkerBlockEntity> {
    public static final Material MATERIAL = new Material(TextureAtlas.f_118259_, new ResourceLocation("lootr", "shulker"));
    public static final Material MATERIAL2 = new Material(TextureAtlas.f_118259_, new ResourceLocation("lootr", "shulker_opened"));
    private UUID playerId;
    private final ShulkerModel<?> model;

    public LootrShulkerBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new ShulkerModel(context.m_173582_(ModelLayers.f_171180_));
    }

    protected Material getMaterial(LootrShulkerBlockEntity tile) {
        if (ConfigManager.isVanillaTextures()) {
            return Sheets.f_110741_;
        }
        if (this.playerId == null) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return MATERIAL;
            }
            this.playerId = mc.f_91074_.m_20148_();
        }
        if (tile.getOpeners().contains(this.playerId)) {
            return MATERIAL2;
        }
        return MATERIAL;
    }

    public void render(LootrShulkerBlockEntity pBlockEntity, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay) {
        BlockState blockstate;
        Direction direction = Direction.UP;
        if (pBlockEntity.m_58898_() && (blockstate = pBlockEntity.m_58904_().m_8055_(pBlockEntity.m_58899_())).m_60734_() instanceof ShulkerBoxBlock) {
            direction = (Direction)blockstate.m_61143_((Property)ShulkerBoxBlock.f_56183_);
        }
        Material material = this.getMaterial(pBlockEntity);
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.5, 0.5, 0.5);
        float f = 0.9995f;
        pMatrixStack.m_85841_(0.9995f, 0.9995f, 0.9995f);
        pMatrixStack.m_85845_(direction.m_122406_());
        pMatrixStack.m_85841_(1.0f, -1.0f, -1.0f);
        pMatrixStack.m_85837_(0.0, -1.0, 0.0);
        ModelPart modelpart = this.model.m_103742_();
        modelpart.m_104227_(0.0f, 24.0f - pBlockEntity.getProgress(pPartialTicks) * 0.5f * 16.0f, 0.0f);
        modelpart.f_104204_ = 270.0f * pBlockEntity.getProgress(pPartialTicks) * ((float)Math.PI / 180);
        VertexConsumer vertexconsumer = material.m_119194_(pBuffer, RenderType::m_110458_);
        this.model.m_7695_(pMatrixStack, vertexconsumer, pCombinedLight, pCombinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        pMatrixStack.m_85849_();
    }
}

