/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.lootbeams.LootBeams;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class Configuration {
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec.BooleanValue ALL_ITEMS;
    public static ForgeConfigSpec.BooleanValue ONLY_EQUIPMENT;
    public static ForgeConfigSpec.BooleanValue ONLY_RARE;
    public static ForgeConfigSpec.ConfigValue<List<String>> WHITELIST;
    public static ForgeConfigSpec.ConfigValue<List<String>> BLACKLIST;
    public static ForgeConfigSpec.ConfigValue<List<String>> COLOR_OVERRIDES;
    public static ForgeConfigSpec.BooleanValue RENDER_NAME_COLOR;
    public static ForgeConfigSpec.BooleanValue RENDER_RARITY_COLOR;
    public static ForgeConfigSpec.DoubleValue BEAM_RADIUS;
    public static ForgeConfigSpec.DoubleValue BEAM_HEIGHT;
    public static ForgeConfigSpec.DoubleValue BEAM_Y_OFFSET;
    public static ForgeConfigSpec.DoubleValue BEAM_ALPHA;
    public static ForgeConfigSpec.DoubleValue RENDER_DISTANCE;
    public static ForgeConfigSpec.BooleanValue BORDERS;
    public static ForgeConfigSpec.BooleanValue RENDER_NAMETAGS;
    public static ForgeConfigSpec.BooleanValue RENDER_NAMETAGS_ONLOOK;
    public static ForgeConfigSpec.BooleanValue RENDER_STACKCOUNT;
    public static ForgeConfigSpec.DoubleValue NAMETAG_LOOK_SENSITIVITY;
    public static ForgeConfigSpec.DoubleValue NAMETAG_TEXT_ALPHA;
    public static ForgeConfigSpec.DoubleValue NAMETAG_BACKGROUND_ALPHA;
    public static ForgeConfigSpec.DoubleValue NAMETAG_SCALE;
    public static ForgeConfigSpec.DoubleValue NAMETAG_Y_OFFSET;
    public static ForgeConfigSpec.BooleanValue DMCLOOT_COMPAT_RARITY;
    public static ForgeConfigSpec.ConfigValue<List<String>> CUSTOM_RARITIES;
    public static ForgeConfigSpec.BooleanValue WHITE_RARITIES;

    public static Color getColorFromItemOverrides(Item i) {
        List overrides = (List)COLOR_OVERRIDES.get();
        if (overrides.size() > 0) {
            for (String unparsed : overrides.stream().filter(s -> !s.isEmpty()).collect(Collectors.toList())) {
                String[] configValue = unparsed.split("=");
                if (configValue.length != 2) continue;
                String nameIn = configValue[0];
                ResourceLocation registry = ResourceLocation.m_135820_((String)nameIn.replace("#", ""));
                Color colorIn = null;
                try {
                    colorIn = Color.decode(configValue[1]);
                }
                catch (Exception e) {
                    LootBeams.LOGGER.error(String.format("Color overrides error! \"%s\" is not a valid hex color for \"%s\"", configValue[1], nameIn));
                    return null;
                }
                if (!nameIn.contains(":") && ForgeRegistries.ITEMS.getKey((Object)i).m_135827_().equals(nameIn)) {
                    return colorIn;
                }
                if (registry == null) continue;
                if (nameIn.startsWith("#") && ForgeRegistries.ITEMS.tags().getTag(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)registry)).contains((Object)i)) {
                    return colorIn;
                }
                Item registryItem = (Item)ForgeRegistries.ITEMS.getValue(registry);
                if (registryItem == null || registryItem.m_5456_() != i) continue;
                return colorIn;
            }
        }
        return null;
    }

    static {
        ForgeConfigSpec.Builder clientBuilder = new ForgeConfigSpec.Builder();
        clientBuilder.comment("Beam Config").push("Loot Beams");
        RENDER_NAME_COLOR = clientBuilder.comment("If beams should be colored the same as the Items name (excludes name colors from rarity). This has priority over render_rarity_color.").define("render_name_color", true);
        RENDER_RARITY_COLOR = clientBuilder.comment("If beams should be colored the same as the Items rarity.").define("render_rarity_color", true);
        BEAM_RADIUS = clientBuilder.comment("The radius of the Loot Beam.").defineInRange("beam_radius", 1.0, 0.0, 5.0);
        BEAM_HEIGHT = clientBuilder.comment("The height of the Loot Beam.").defineInRange("beam_height", 1.0, 0.0, 10.0);
        BEAM_Y_OFFSET = clientBuilder.comment("The Y-offset of the loot beam.").defineInRange("beam_y_offset", 0.0, -30.0, 30.0);
        BEAM_ALPHA = clientBuilder.comment("Transparency of the Loot Beam.").defineInRange("beam_alpha", 0.85, 0.0, 1.0);
        RENDER_DISTANCE = clientBuilder.comment("How close the player has to be to see the beam. (note: ItemEntities stop rendering at 24 blocks, so that is the limit for beams)").defineInRange("render_distance", 24.0, 0.0, 24.0);
        COLOR_OVERRIDES = clientBuilder.comment("Overrides an item's beam color with hex color. Must follow the specific format: (registryname=hexcolor) Or (#tagname=hexcolor). Example: \"minecraft:stone=0xFFFFFF\". This also accepts modids.").define("color_overrides", new ArrayList());
        clientBuilder.comment("Item Config").push("Items");
        ALL_ITEMS = clientBuilder.comment("If all Items Loot Beams should be rendered. Has priority over only_equipment and only_rare.").define("all_items", true);
        ONLY_RARE = clientBuilder.comment("If Loot Beams should only be rendered on items with rarity.").define("only_rare", false);
        ONLY_EQUIPMENT = clientBuilder.comment("If Loot Beams should only be rendered on equipment. (Equipment includes: Swords, Tools, Armor, Shields, Bows, Crossbows, Tridents, Arrows, and Fishing Rods)").define("only_equipment", false);
        WHITELIST = clientBuilder.comment("Registry names of items that Loot Beams should render on. Example: \"minecraft:stone\", \"minecraft:iron_ingot\", You can also specify modids for a whole mod's items.").define("whitelist", new ArrayList());
        BLACKLIST = clientBuilder.comment("Registry names of items that Loot Beams should NOT render on. This has priority over everything. You can also specify modids for a whole mod's items.").define("blacklist", new ArrayList());
        clientBuilder.pop();
        clientBuilder.comment("Item nametags").push("Nametags");
        BORDERS = clientBuilder.comment("Render nametags as bordered. Set to false for flat nametag with background.").define("borders", true);
        RENDER_NAMETAGS = clientBuilder.comment("If Item nametags should be rendered.").define("render_nametags", true);
        RENDER_NAMETAGS_ONLOOK = clientBuilder.comment("If Item nametags should be rendered when looking at items.").define("render_nametags_onlook", true);
        RENDER_STACKCOUNT = clientBuilder.comment("If the count of item's should also be shown in the nametag.").define("render_stackcount", true);
        NAMETAG_LOOK_SENSITIVITY = clientBuilder.comment("How close the player has to look at the item to render the nametag.").defineInRange("nametag_look_sensitivity", 0.018, 0.0, 5.0);
        NAMETAG_TEXT_ALPHA = clientBuilder.comment("Transparency of the nametag text.").defineInRange("nametag_text_alpha", 1.0, 0.0, 1.0);
        NAMETAG_BACKGROUND_ALPHA = clientBuilder.comment("Transparency of the nametag background/border.").defineInRange("nametag_background_alpha", 0.5, 0.0, 1.0);
        NAMETAG_SCALE = clientBuilder.comment("Scale of the nametag.").defineInRange("nametag_scale", 1.0, -10.0, 10.0);
        NAMETAG_Y_OFFSET = clientBuilder.comment("The Y-offset of the nametag.").defineInRange("nametag_y_offset", 0.75, -30.0, 30.0);
        DMCLOOT_COMPAT_RARITY = clientBuilder.comment("If a smaller tag should be rendered under with DMCLoot rarities.").define("dmcloot_compat_rarity", true);
        CUSTOM_RARITIES = clientBuilder.comment("Define what the smaller tag should render on. Example: \"Exotic\", \"Ancient\". The string supplied has to be the tooltip line below the name. This is really only used for modpacks.").define("custom_rarities", new ArrayList());
        WHITE_RARITIES = clientBuilder.comment("If rarities should ignore color and render as white (This is really only used for modpacks)").define("white_rarities", false);
        clientBuilder.pop();
        clientBuilder.pop();
        CLIENT_CONFIG = clientBuilder.build();
    }
}

