/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.lootbeams.Configuration;
import com.lootbeams.LootBeamRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lootbeams", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientSetup {
    public static void init(FMLClientSetupEvent e) {
        MinecraftForge.EVENT_BUS.addListener(ClientSetup::onRenderNameplate);
    }

    public static void onRenderNameplate(RenderNameTagEvent event) {
        if (event.getEntity() instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)event.getEntity();
            if (Minecraft.m_91087_().f_91074_.m_20280_((Entity)itemEntity) > (Double)Configuration.RENDER_DISTANCE.get() * (Double)Configuration.RENDER_DISTANCE.get()) {
                return;
            }
            boolean shouldRender = false;
            if (((Boolean)Configuration.ALL_ITEMS.get()).booleanValue()) {
                shouldRender = true;
            } else {
                if (((Boolean)Configuration.ONLY_EQUIPMENT.get()).booleanValue()) {
                    List<Class> equipmentClasses = Arrays.asList(SwordItem.class, TieredItem.class, ArmorItem.class, ShieldItem.class, BowItem.class, CrossbowItem.class, TridentItem.class, ArrowItem.class, FishingRodItem.class);
                    for (Class item : equipmentClasses) {
                        if (!item.isAssignableFrom(itemEntity.m_32055_().m_41720_().getClass())) continue;
                        shouldRender = true;
                        break;
                    }
                }
                if (((Boolean)Configuration.ONLY_RARE.get()).booleanValue()) {
                    boolean bl = shouldRender = itemEntity.m_32055_().m_41791_() != Rarity.COMMON;
                }
                if (ClientSetup.isItemInRegistryList((List)Configuration.WHITELIST.get(), itemEntity.m_32055_().m_41720_())) {
                    shouldRender = true;
                }
            }
            if (ClientSetup.isItemInRegistryList((List)Configuration.BLACKLIST.get(), itemEntity.m_32055_().m_41720_())) {
                shouldRender = false;
            }
            if (shouldRender) {
                LootBeamRenderer.renderLootBeam(event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick(), itemEntity.f_19853_.m_46467_(), itemEntity);
            }
        }
    }

    private static boolean isItemInRegistryList(List<String> registryNames, Item item) {
        if (registryNames.size() > 0) {
            for (String id : registryNames.stream().filter(s -> !s.isEmpty()).collect(Collectors.toList())) {
                if (!id.contains(":") && ForgeRegistries.ITEMS.getKey((Object)item).m_135827_().equals(id)) {
                    return true;
                }
                ResourceLocation itemResource = ResourceLocation.m_135820_((String)id);
                if (itemResource == null || ((Item)ForgeRegistries.ITEMS.getValue(itemResource)).m_5456_() != item.m_5456_()) continue;
                return true;
            }
        }
        return false;
    }
}

