/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.BoolExpr;
import ca.teamdman.sfml.ast.ComparisonOperator;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Quantity;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.SetOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public record ResourceComparer<STACK, ITEM, CAP>(ComparisonOperator op, Quantity num, ResourceIdentifier<STACK, ITEM, CAP> res) implements ASTNode
{
    public BoolExpr toBooleanExpression(SetOperator setOp, LabelAccess labelAccess) {
        return new BoolExpr(context -> {
            ResourceType type = this.res.getResourceType();
            if (type == null) {
                return false;
            }
            Stream<CAP> handlers = type.getCapabilities((ProgramContext)context, labelAccess);
            long overallCount = 0L;
            ArrayList<Boolean> satisfiedSet = new ArrayList<Boolean>();
            for (Object cap : handlers::iterator) {
                long invCount = 0L;
                for (Object stack : type.collect(cap, labelAccess)::iterator) {
                    if (!this.res.test(stack)) continue;
                    invCount += type.getCount(stack);
                    overallCount += type.getCount(stack);
                }
                satisfiedSet.add(this.op.test(invCount, this.num.value()));
            }
            boolean isOverallSatisfied = this.op.test(overallCount, this.num.value());
            return setOp.test(isOverallSatisfied, (List<Boolean>)satisfiedSet);
        });
    }
}

