/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.program.LimitedOutputSlot;
import ca.teamdman.sfm.common.program.LimitedOutputSlotObjectPool;
import ca.teamdman.sfm.common.program.OutputResourceTracker;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import ca.teamdman.sfml.ast.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public final class OutputStatement
implements Statement {
    private static final LimitedOutputSlotObjectPool SLOT_POOL = new LimitedOutputSlotObjectPool();
    private final LabelAccess LABEL_ACCESS;
    private final ResourceLimits RESOURCE_LIMITS;
    private final boolean EACH;
    private int lastInputCapacity = 32;
    private int lastOutputCapacity = 32;

    public OutputStatement(LabelAccess labelAccess, ResourceLimits resourceLimits, boolean each) {
        this.LABEL_ACCESS = labelAccess;
        this.RESOURCE_LIMITS = resourceLimits;
        this.EACH = each;
    }

    public static <STACK, ITEM, CAP> void moveTo(LimitedInputSlot<STACK, ITEM, CAP> source, LimitedOutputSlot<STACK, ITEM, CAP> destination) {
        if (!source.type.equals(destination.type)) {
            return;
        }
        STACK potential = source.peekExtractPotential();
        if (!destination.tracker.test(potential)) {
            return;
        }
        STACK remainder = destination.insert(potential, true);
        long toMove = source.type.getCount(potential) - source.type.getCount(remainder);
        if (toMove == 0L) {
            return;
        }
        long remainingObligation = source.tracker.getRemainingRetentionObligation();
        remainingObligation = Long.min(toMove -= source.tracker.getExistingRetentionObligation(source.slot), remainingObligation);
        source.tracker.trackRetentionObligation(source.slot, remainingObligation);
        if ((toMove -= remainingObligation) == 0L) {
            source.setDone();
            return;
        }
        toMove = Math.min(toMove, destination.tracker.getMaxTransferable());
        toMove = Math.min(toMove, source.tracker.getMaxTransferable());
        if ((toMove = Math.min(toMove, source.type.getMaxStackSize(potential))) <= 0L) {
            return;
        }
        STACK extracted = source.extract(toMove);
        remainder = destination.insert(extracted, false);
        long moved = source.type.getCount(extracted) - source.type.getCount(remainder);
        source.tracker.trackTransfer(moved);
        destination.tracker.trackTransfer(moved);
        if (!destination.type.isEmpty(remainder)) {
            SFM.LOGGER.error("Failed to move all promised items, took {} but had {} left over after insertion.", extracted, remainder);
        }
    }

    public static void releaseSlots(List<LimitedOutputSlot> slots) {
        SLOT_POOL.release(slots);
    }

    public static void releaseSlot(LimitedOutputSlot<?, ?, ?> slot) {
        SLOT_POOL.release(slot);
    }

    @Override
    public void tick(ProgramContext context) {
        ArrayList<LimitedInputSlot> inputSlots = new ArrayList<LimitedInputSlot>(this.lastInputCapacity + 27);
        for (InputStatement inputStatement : context.getInputs()) {
            inputStatement.gatherSlots(context, inputSlots::add);
        }
        if (inputSlots.isEmpty()) {
            return;
        }
        this.lastInputCapacity = inputSlots.size();
        ArrayList<LimitedOutputSlot> outputSlots = new ArrayList<LimitedOutputSlot>(this.lastOutputCapacity + 27);
        this.gatherSlots(context, outputSlots::add);
        this.lastOutputCapacity = outputSlots.size();
        Iterator inIt = inputSlots.iterator();
        while (inIt.hasNext()) {
            LimitedInputSlot in = (LimitedInputSlot)inIt.next();
            if (in.isDone()) {
                inIt.remove();
                InputStatement.releaseSlot(in);
                continue;
            }
            Iterator outIt = outputSlots.iterator();
            while (outIt.hasNext()) {
                LimitedOutputSlot out = (LimitedOutputSlot)outIt.next();
                if (out.isDone()) {
                    outIt.remove();
                    OutputStatement.releaseSlot(out);
                    continue;
                }
                OutputStatement.moveTo(in, out);
                if (!in.isDone()) continue;
                break;
            }
            if (!outputSlots.isEmpty()) continue;
            break;
        }
        OutputStatement.releaseSlots(outputSlots);
        InputStatement.releaseSlots(inputSlots);
    }

    public void gatherSlots(ProgramContext context, Consumer<LimitedOutputSlot<?, ?, ?>> acceptor) {
        Stream<ResourceType> types = this.RESOURCE_LIMITS.resourceLimits().stream().map(ResourceLimit::resourceId).map(x -> x.getResourceType()).distinct();
        if (!this.EACH) {
            List<OutputResourceTracker<?, ?, ?>> outputTracker = this.RESOURCE_LIMITS.createOutputTrackers();
            for (ResourceType type : types::iterator) {
                for (Object cap : type.getCapabilities(context, this.LABEL_ACCESS)::iterator) {
                    this.gatherSlots(type, cap, outputTracker, acceptor);
                }
            }
        } else {
            for (ResourceType type : types::iterator) {
                for (Object cap : type.getCapabilities(context, this.LABEL_ACCESS)::iterator) {
                    List<OutputResourceTracker<?, ?, ?>> outputTracker = this.RESOURCE_LIMITS.createOutputTrackers();
                    this.gatherSlots(type, cap, outputTracker, acceptor);
                }
            }
        }
    }

    private <STACK, ITEM, CAP> void gatherSlots(ResourceType<STACK, ITEM, CAP> type, CAP capability, List<OutputResourceTracker<?, ?, ?>> trackers, Consumer<LimitedOutputSlot<?, ?, ?>> acceptor) {
        for (int slot = 0; slot < type.getSlots(capability); ++slot) {
            if (!this.LABEL_ACCESS.slots().contains(slot)) continue;
            for (OutputResourceTracker<?, ?, ?> tracker : trackers) {
                if (!tracker.matchesCapabilityType(capability)) continue;
                acceptor.accept(SLOT_POOL.acquire(capability, slot, tracker));
            }
        }
    }
}

