/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Side;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Direction;

public record DirectionQualifier(EnumSet<Direction> directions) implements ASTNode
{
    public DirectionQualifier(Stream<Side> sides) {
        this(DirectionQualifier.convert(sides));
    }

    private static EnumSet<Direction> convert(Stream<Side> sides) {
        Set dirs = sides.map(DirectionQualifier::lookup).collect(Collectors.toSet());
        if (dirs.isEmpty()) {
            return EnumSet.noneOf(Direction.class);
        }
        return EnumSet.copyOf(dirs);
    }

    private static Direction lookup(Side side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Side.TOP -> Direction.UP;
            case Side.BOTTOM -> Direction.DOWN;
            case Side.NORTH -> Direction.NORTH;
            case Side.SOUTH -> Direction.SOUTH;
            case Side.EAST -> Direction.EAST;
            case Side.WEST -> Direction.WEST;
        };
    }

    public Stream<Direction> stream() {
        if (this.directions.isEmpty()) {
            return Stream.builder().add(null).build();
        }
        return this.directions.stream();
    }
}

