/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.SFMLBaseVisitor;
import ca.teamdman.sfml.SFMLParser;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Block;
import ca.teamdman.sfml.ast.BoolExpr;
import ca.teamdman.sfml.ast.ComparisonOperator;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Interval;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.NumberRange;
import ca.teamdman.sfml.ast.NumberRangeSet;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.Quantity;
import ca.teamdman.sfml.ast.RedstoneTrigger;
import ca.teamdman.sfml.ast.ResourceComparer;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import ca.teamdman.sfml.ast.SetOperator;
import ca.teamdman.sfml.ast.Side;
import ca.teamdman.sfml.ast.Statement;
import ca.teamdman.sfml.ast.StringHolder;
import ca.teamdman.sfml.ast.TimerTrigger;
import ca.teamdman.sfml.ast.Trigger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;

public class ASTBuilder
extends SFMLBaseVisitor<ASTNode> {
    private final Set<Label> USED_LABELS = new HashSet<Label>();
    private final Set<ResourceIdentifier<?, ?, ?>> USED_RESOURCES = new HashSet();

    @Override
    public StringHolder visitName(@Nullable SFMLParser.NameContext ctx) {
        if (ctx == null) {
            return new StringHolder("");
        }
        return this.visitString(ctx.string());
    }

    @Override
    public ASTNode visitResource(SFMLParser.ResourceContext ctx) {
        String str = ctx.children.stream().map(ParseTree::getText).collect(Collectors.joining()).replaceAll("::", ":*:").replaceAll(":$", ":*").replaceAll("\\*", ".*");
        ResourceIdentifier rtn = ResourceIdentifier.fromString(str);
        this.USED_RESOURCES.add(rtn);
        rtn.assertValid();
        return rtn;
    }

    @Override
    public ResourceIdentifier<?, ?, ?> visitStringResource(SFMLParser.StringResourceContext ctx) {
        ResourceIdentifier rtn = ResourceIdentifier.fromString(this.visitString(ctx.string()).value());
        this.USED_RESOURCES.add(rtn);
        rtn.assertValid();
        return rtn;
    }

    @Override
    public StringHolder visitString(SFMLParser.StringContext ctx) {
        String content = ctx.getText();
        return new StringHolder(content.substring(1, content.length() - 1));
    }

    @Override
    public Label visitRawLabel(SFMLParser.RawLabelContext ctx) {
        Label label = new Label(ctx.getText());
        this.USED_LABELS.add(label);
        return label;
    }

    @Override
    public Label visitStringLabel(SFMLParser.StringLabelContext ctx) {
        Label label = new Label(this.visitString(ctx.string()).value());
        this.USED_LABELS.add(label);
        return label;
    }

    @Override
    public Program visitProgram(SFMLParser.ProgramContext ctx) {
        StringHolder name = this.visitName(ctx.name());
        List<Trigger> triggers = ctx.trigger().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Trigger.class::cast).collect(Collectors.toList());
        Set<String> labels = this.USED_LABELS.stream().map(Label::name).collect(Collectors.toSet());
        return new Program(name.value(), triggers, labels, this.USED_RESOURCES);
    }

    @Override
    public ASTNode visitTimerTrigger(SFMLParser.TimerTriggerContext ctx) {
        Interval time = (Interval)this.visit((ParseTree)ctx.interval());
        if (time.getSeconds() < 1) {
            throw new IllegalArgumentException("Minimum trigger interval is 1 second.");
        }
        Block block = this.visitBlock(ctx.block());
        return new TimerTrigger(time, block);
    }

    @Override
    public ASTNode visitBooleanRedstone(SFMLParser.BooleanRedstoneContext ctx) {
        ComparisonOperator comp = ComparisonOperator.GREATER_OR_EQUAL;
        Quantity num = new Quantity(0L);
        if (ctx.comparisonOp() != null && ctx.number() != null) {
            comp = this.visitComparisonOp(ctx.comparisonOp());
            num = this.visitNumber(ctx.number());
        }
        ComparisonOperator finalComp = comp;
        assert (num.value() <= Integer.MAX_VALUE);
        int finalNum = (int)num.value();
        return new BoolExpr(programContext -> finalComp.test(Long.valueOf(programContext.getManager().m_58904_().m_46755_(programContext.getManager().m_58899_())), Long.valueOf(finalNum)));
    }

    @Override
    public ASTNode visitPulseTrigger(SFMLParser.PulseTriggerContext ctx) {
        Block block = this.visitBlock(ctx.block());
        return new RedstoneTrigger(block);
    }

    @Override
    public Quantity visitNumber(SFMLParser.NumberContext ctx) {
        return new Quantity(Long.parseLong(ctx.getText()));
    }

    @Override
    public Interval visitTicks(SFMLParser.TicksContext ctx) {
        Quantity num = this.visitNumber(ctx.number());
        assert (num.value() <= Integer.MAX_VALUE);
        return Interval.fromTicks((int)num.value());
    }

    @Override
    public Interval visitSeconds(SFMLParser.SecondsContext ctx) {
        Quantity num = this.visitNumber(ctx.number());
        assert (num.value() <= Integer.MAX_VALUE);
        return Interval.fromSeconds((int)num.value());
    }

    @Override
    public InputStatement visitInputStatementStatement(SFMLParser.InputStatementStatementContext ctx) {
        return (InputStatement)this.visit((ParseTree)ctx.inputstatement());
    }

    @Override
    public OutputStatement visitOutputStatementStatement(SFMLParser.OutputStatementStatementContext ctx) {
        return (OutputStatement)this.visit((ParseTree)ctx.outputstatement());
    }

    @Override
    public InputStatement visitInputstatement(SFMLParser.InputstatementContext ctx) {
        LabelAccess labelAccess = this.visitLabelaccess(ctx.labelaccess());
        ResourceLimits matchers = this.visitInputmatchers(ctx.inputmatchers());
        boolean each = ctx.EACH() != null;
        return new InputStatement(labelAccess, matchers, each);
    }

    @Override
    public OutputStatement visitOutputstatement(SFMLParser.OutputstatementContext ctx) {
        LabelAccess labelAccess = this.visitLabelaccess(ctx.labelaccess());
        ResourceLimits matchers = this.visitOutputmatchers(ctx.outputmatchers());
        boolean each = ctx.EACH() != null;
        return new OutputStatement(labelAccess, matchers, each);
    }

    @Override
    public LabelAccess visitLabelaccess(SFMLParser.LabelaccessContext ctx) {
        return new LabelAccess(ctx.label().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Label.class::cast).collect(Collectors.toList()), this.visitSidequalifier(ctx.sidequalifier()), this.visitSlotqualifier(ctx.slotqualifier()));
    }

    @Override
    public IfStatement visitIfstatement(SFMLParser.IfstatementContext ctx) {
        List<BoolExpr> expressions = ctx.boolexpr().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(BoolExpr.class::cast).collect(Collectors.toList());
        List<Block> blocks = ctx.block().stream().map(this::visitBlock).collect(Collectors.toList());
        return new IfStatement(expressions, blocks);
    }

    @Override
    public IfStatement visitIfStatementStatement(SFMLParser.IfStatementStatementContext ctx) {
        return this.visitIfstatement(ctx.ifstatement());
    }

    @Override
    public BoolExpr visitBooleanTrue(SFMLParser.BooleanTrueContext ctx) {
        return new BoolExpr(__ -> true);
    }

    @Override
    public BoolExpr visitBooleanHas(SFMLParser.BooleanHasContext ctx) {
        SetOperator setOp = this.visitSetOp(ctx.setOp());
        LabelAccess labelAccess = this.visitLabelaccess(ctx.labelaccess());
        Object comparison = this.visitResourcecomparison(ctx.resourcecomparison());
        return ((ResourceComparer)comparison).toBooleanExpression(setOp, labelAccess);
    }

    @Override
    public SetOperator visitSetOp(@Nullable SFMLParser.SetOpContext ctx) {
        if (ctx == null) {
            return SetOperator.OVERALL;
        }
        return SetOperator.from(ctx.getText());
    }

    @Override
    public ResourceComparer<?, ?, ?> visitResourcecomparison(SFMLParser.ResourcecomparisonContext ctx) {
        ComparisonOperator op = this.visitComparisonOp(ctx.comparisonOp());
        Quantity num = this.visitNumber(ctx.number());
        ResourceIdentifier item = (ResourceIdentifier)this.visit((ParseTree)ctx.resourceid());
        return new ResourceComparer(op, num, item);
    }

    @Override
    public ComparisonOperator visitComparisonOp(SFMLParser.ComparisonOpContext ctx) {
        return ComparisonOperator.from(ctx.getText());
    }

    @Override
    public BoolExpr visitBooleanConjunction(SFMLParser.BooleanConjunctionContext ctx) {
        BoolExpr left = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(0));
        BoolExpr right = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(1));
        return new BoolExpr(left.and(right));
    }

    @Override
    public BoolExpr visitBooleanDisjunction(SFMLParser.BooleanDisjunctionContext ctx) {
        BoolExpr left = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(0));
        BoolExpr right = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(1));
        return new BoolExpr(left.or(right));
    }

    @Override
    public BoolExpr visitBooleanFalse(SFMLParser.BooleanFalseContext ctx) {
        return new BoolExpr(__ -> false);
    }

    @Override
    public BoolExpr visitBooleanParen(SFMLParser.BooleanParenContext ctx) {
        return (BoolExpr)this.visit((ParseTree)ctx.boolexpr());
    }

    @Override
    public BoolExpr visitBooleanNegation(SFMLParser.BooleanNegationContext ctx) {
        BoolExpr x = (BoolExpr)this.visit((ParseTree)ctx.boolexpr());
        return new BoolExpr(x.negate());
    }

    @Override
    public Limit visitQuantityRetentionLimit(SFMLParser.QuantityRetentionLimitContext ctx) {
        Quantity quantity = this.visitQuantity(ctx.quantity());
        Quantity retain = this.visitRetention(ctx.retention());
        return new Limit(quantity.value(), retain.value());
    }

    @Override
    public ResourceLimits visitInputmatchers(@Nullable SFMLParser.InputmatchersContext ctx) {
        if (ctx == null) {
            return new ResourceLimits(List.of(new ResourceLimit(new Limit(Long.MAX_VALUE, 0L), ResourceIdentifier.MATCH_ALL)));
        }
        return ((ResourceLimits)this.visit((ParseTree)ctx.movement())).withDefaults(Long.MAX_VALUE, 0L);
    }

    @Override
    public ResourceLimits visitOutputmatchers(@Nullable SFMLParser.OutputmatchersContext ctx) {
        if (ctx == null) {
            return new ResourceLimits(List.of(new ResourceLimit(new Limit(Long.MAX_VALUE, Long.MAX_VALUE), ResourceIdentifier.MATCH_ALL)));
        }
        return ((ResourceLimits)this.visit((ParseTree)ctx.movement())).withDefaults(Long.MAX_VALUE, Long.MAX_VALUE);
    }

    @Override
    public ASTNode visitResourceLimitMovement(SFMLParser.ResourceLimitMovementContext ctx) {
        return new ResourceLimits(ctx.resourcelimit().stream().map(resourcelimitContext -> this.visitResourcelimit((SFMLParser.ResourcelimitContext)((Object)resourcelimitContext))).collect(Collectors.toList()));
    }

    @Override
    public ResourceLimits visitLimitMovement(SFMLParser.LimitMovementContext ctx) {
        return new ResourceLimits(List.of(new ResourceLimit((Limit)this.visit((ParseTree)ctx.limit()), ResourceIdentifier.MATCH_ALL)));
    }

    @Override
    public ResourceLimit<?, ?, ?> visitResourcelimit(SFMLParser.ResourcelimitContext ctx) {
        ResourceIdentifier res = (ResourceIdentifier)this.visit((ParseTree)ctx.resourceid());
        if (ctx.limit() == null) {
            return new ResourceLimit(res);
        }
        Limit limit = (Limit)this.visit((ParseTree)ctx.limit());
        return new ResourceLimit(limit, res);
    }

    @Override
    public NumberRangeSet visitSlotqualifier(@Nullable SFMLParser.SlotqualifierContext ctx) {
        return this.visitRangeset(ctx == null ? null : ctx.rangeset());
    }

    @Override
    public NumberRangeSet visitRangeset(@Nullable SFMLParser.RangesetContext ctx) {
        if (ctx == null) {
            return new NumberRangeSet(new NumberRange[]{new NumberRange(Long.MIN_VALUE, Long.MAX_VALUE)});
        }
        return new NumberRangeSet((NumberRange[])ctx.range().stream().map(this::visitRange).toArray(NumberRange[]::new));
    }

    @Override
    public NumberRange visitRange(SFMLParser.RangeContext ctx) {
        PrimitiveIterator.OfLong iter = ctx.number().stream().map(this::visitNumber).mapToLong(Quantity::value).iterator();
        Long start = iter.next();
        if (iter.hasNext()) {
            Long end = iter.next();
            return new NumberRange(start, end);
        }
        return new NumberRange(start, start);
    }

    @Override
    public Limit visitRetentionLimit(SFMLParser.RetentionLimitContext ctx) {
        Quantity retain = this.visitRetention(ctx.retention());
        return new Limit(-1L, retain.value());
    }

    @Override
    public Limit visitQuantityLimit(SFMLParser.QuantityLimitContext ctx) {
        Quantity quantity = this.visitQuantity(ctx.quantity());
        return new Limit(quantity.value(), -1L);
    }

    @Override
    public Quantity visitRetention(@Nullable SFMLParser.RetentionContext ctx) {
        if (ctx == null) {
            return new Quantity(-1L);
        }
        return this.visitNumber(ctx.number());
    }

    @Override
    public Quantity visitQuantity(@Nullable SFMLParser.QuantityContext ctx) {
        if (ctx == null) {
            return new Quantity(Long.MAX_VALUE);
        }
        return this.visitNumber(ctx.number());
    }

    @Override
    public DirectionQualifier visitSidequalifier(@Nullable SFMLParser.SidequalifierContext ctx) {
        if (ctx == null) {
            return new DirectionQualifier(Stream.empty());
        }
        Stream<Side> sides = ctx.side().stream().map(this::visitSide);
        return new DirectionQualifier(sides);
    }

    @Override
    public Side visitSide(SFMLParser.SideContext ctx) {
        return Side.valueOf(ctx.getText().toUpperCase(Locale.ROOT));
    }

    @Override
    public Block visitBlock(@Nullable SFMLParser.BlockContext ctx) {
        if (ctx == null) {
            return new Block(Collections.emptyList());
        }
        List<Statement> statements = ctx.statement().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Statement.class::cast).collect(Collectors.toList());
        return new Block(statements);
    }
}

