/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.contents.TranslatableContents;

public class SFMUtil {
    public static <T> Stream<T> getRecursiveStream(RecursiveBuilder<T> operator, T first) {
        Stream.Builder builder = Stream.builder();
        HashSet debounce = new HashSet();
        ArrayDeque toVisit = new ArrayDeque();
        toVisit.add(first);
        debounce.add(first);
        while (toVisit.size() > 0) {
            Object current = toVisit.pop();
            operator.accept(current, next -> {
                if (!debounce.contains(next)) {
                    debounce.add(next);
                    toVisit.add(next);
                }
            }, builder::add);
        }
        return builder.build();
    }

    public static CompoundTag serializeTranslation(TranslatableContents contents) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("key", contents.m_237508_());
        ListTag args = new ListTag();
        for (Object arg : contents.m_237523_()) {
            args.add((Object)StringTag.m_129297_((String)arg.toString()));
        }
        tag.m_128365_("args", (Tag)args);
        return tag;
    }

    public static TranslatableContents deserializeTranslation(CompoundTag tag) {
        String key = tag.m_128461_("key");
        Object[] args = tag.m_128437_("args", 8).stream().map(StringTag.class::cast).map(StringTag::m_7916_).toArray();
        return new TranslatableContents(key, args);
    }

    public static interface RecursiveBuilder<T> {
        public void accept(T var1, Consumer<T> var2, Consumer<T> var3);
    }
}

