/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.program.LabelHolder;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class ResourceType<STACK, ITEM, CAP> {
    private static final Map<String, Predicate<String>> patternCache = new Object2ObjectOpenHashMap();
    private final Map<ITEM, ResourceLocation> registryKeyCache = new Object2ObjectOpenHashMap();
    public final Capability<CAP> CAPABILITY;

    public ResourceType(Capability<CAP> CAPABILITY) {
        this.CAPABILITY = CAPABILITY;
    }

    private static Predicate<String> buildPredicate(String possiblePattern) {
        return ResourceType.isRegexPattern(possiblePattern) ? Pattern.compile(possiblePattern).asMatchPredicate() : possiblePattern::equals;
    }

    private static boolean isRegexPattern(String pattern) {
        String specialChars = ".?*+^$[](){}|\\";
        for (int i = 0; i < pattern.length(); ++i) {
            if (specialChars.indexOf(pattern.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    public abstract long getCount(STACK var1);

    public abstract STACK getStackInSlot(CAP var1, int var2);

    public abstract STACK extract(CAP var1, int var2, long var3, boolean var5);

    public abstract int getSlots(CAP var1);

    public abstract long getMaxStackSize(STACK var1);

    public abstract long getMaxStackSize(CAP var1, int var2);

    public abstract STACK insert(CAP var1, int var2, STACK var3, boolean var4);

    public abstract boolean isEmpty(STACK var1);

    public abstract STACK getEmptyStack();

    public abstract boolean matchesStackType(Object var1);

    public boolean test(ResourceIdentifier<STACK, ITEM, CAP> id, Object other) {
        Predicate<String> namePredicate;
        if (!this.matchesStackType(other)) {
            return false;
        }
        Object stack = other;
        if (this.isEmpty(stack)) {
            return false;
        }
        ResourceLocation stackId = this.getRegistryKey(stack);
        Predicate<String> namespacePredicate = patternCache.get(id.resourceNamespace);
        if (namespacePredicate == null) {
            namespacePredicate = ResourceType.buildPredicate(id.resourceNamespace);
            patternCache.put(id.resourceNamespace, namespacePredicate);
        }
        if ((namePredicate = patternCache.get(id.resourceName)) == null) {
            namePredicate = ResourceType.buildPredicate(id.resourceName);
            patternCache.put(id.resourceName, namePredicate);
        }
        return namespacePredicate.test(stackId.m_135827_()) && namePredicate.test(stackId.m_135815_());
    }

    public abstract boolean matchesCapabilityType(Object var1);

    public Stream<CAP> getCapabilities(ProgramContext programContext, LabelAccess labelAccess) {
        Optional<ItemStack> disk = programContext.getManager().getDisk();
        if (disk.isEmpty()) {
            return Stream.empty();
        }
        LabelHolder labels = LabelHolder.from(disk.get());
        CableNetwork network = programContext.getNetwork();
        return labels.getPositions(labelAccess).map(network::getCapabilityProvider).filter(Optional::isPresent).map(Optional::get).flatMap(prov -> labelAccess.directions().stream().map(direction -> prov.getCapability(this.CAPABILITY, direction))).map(x -> x.orElse(null)).filter(x -> x != null);
    }

    public Stream<STACK> collect(CAP cap, LabelAccess labelAccess) {
        Stream.Builder<STACK> rtn = Stream.builder();
        for (int slot = 0; slot < this.getSlots(cap); ++slot) {
            STACK stack;
            if (!labelAccess.slots().contains(slot) || this.isEmpty(stack = this.getStackInSlot(cap, slot))) continue;
            rtn.add(stack);
        }
        return rtn.build();
    }

    public boolean registryKeyExists(ResourceLocation location) {
        return this.getRegistry().containsKey(location);
    }

    public ResourceLocation getRegistryKey(STACK stack) {
        ITEM item = this.getItem(stack);
        ResourceLocation found = this.registryKeyCache.get(item);
        if (found != null) {
            return found;
        }
        found = this.getRegistry().getKey(item);
        assert (found != null);
        this.registryKeyCache.put(item, found);
        return found;
    }

    public abstract IForgeRegistry<ITEM> getRegistry();

    public abstract ITEM getItem(STACK var1);

    static {
        String[] matchAny = new String[]{".", "[a-z0-9/._-]"};
        String[] suffixes = new String[]{"+", "*"};
        for (String s : matchAny) {
            for (String suffix : suffixes) {
                patternCache.put(s + suffix, s1 -> true);
                patternCache.put("^" + s + suffix, s1 -> true);
                patternCache.put("^" + s + suffix + "$", s1 -> true);
                patternCache.put(s + suffix + "$", s1 -> true);
            }
        }
    }
}

