/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.resourcetype.ResourceType;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.registries.IForgeRegistry;

public class PigmentResourceType
extends ResourceType<PigmentStack, Pigment, IPigmentHandler> {
    public static final Capability<IPigmentHandler> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPigmentHandler>(){});

    public PigmentResourceType() {
        super(CAP);
    }

    @Override
    public long getCount(PigmentStack stack) {
        return stack.getAmount();
    }

    @Override
    public PigmentStack getStackInSlot(IPigmentHandler handler, int slot) {
        return (PigmentStack)handler.getChemicalInTank(slot);
    }

    @Override
    public PigmentStack extract(IPigmentHandler handler, int slot, long amount, boolean simulate) {
        return (PigmentStack)handler.extractChemical(slot, amount, simulate ? Action.SIMULATE : Action.EXECUTE);
    }

    @Override
    public int getSlots(IPigmentHandler handler) {
        return handler.getTanks();
    }

    @Override
    public long getMaxStackSize(PigmentStack stack) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getMaxStackSize(IPigmentHandler handler, int slot) {
        return handler.getTankCapacity(slot);
    }

    @Override
    public PigmentStack insert(IPigmentHandler handler, int slot, PigmentStack stack, boolean simulate) {
        return (PigmentStack)handler.insertChemical(slot, (ChemicalStack)stack, simulate ? Action.SIMULATE : Action.EXECUTE);
    }

    @Override
    public boolean isEmpty(PigmentStack stack) {
        return stack.isEmpty();
    }

    @Override
    public PigmentStack getEmptyStack() {
        return PigmentStack.EMPTY;
    }

    @Override
    public boolean matchesStackType(Object o) {
        return o instanceof PigmentStack;
    }

    @Override
    public boolean matchesCapabilityType(Object o) {
        return o instanceof IPigmentHandler;
    }

    @Override
    public IForgeRegistry<Pigment> getRegistry() {
        return MekanismAPI.pigmentRegistry();
    }

    @Override
    public Pigment getItem(PigmentStack stack) {
        return (Pigment)stack.getType();
    }
}

