/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.net.ClientboundManagerGuiPacket;
import ca.teamdman.sfm.common.net.ServerboundDiskItemSetProgramPacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunClearPacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunPrunePacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUpdatePacket;
import ca.teamdman.sfm.common.net.ServerboundManagerFixPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerProgramPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerResetPacket;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class SFMPackets {
    public static final String MANAGER_CHANNEL_VERSION = "1";
    public static final String LABEL_GUN_ITEM_CHANNEL_VERSION = "1";
    public static final String DISK_ITEM_CHANNEL_VERSION = "1";
    public static final SimpleChannel MANAGER_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("sfm", "manager"), "1"::toString, "1"::equals, "1"::equals);
    public static final SimpleChannel LABEL_GUN_ITEM_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("sfm", "labelgun"), "1"::toString, "1"::equals, "1"::equals);
    public static final SimpleChannel DISK_ITEM_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("sfm", "disk"), "1"::toString, "1"::equals, "1"::equals);

    public static void register() {
        MANAGER_CHANNEL.registerMessage(0, ServerboundManagerProgramPacket.class, ServerboundManagerProgramPacket::encode, ServerboundManagerProgramPacket::decode, ServerboundManagerProgramPacket::handle);
        MANAGER_CHANNEL.registerMessage(1, ServerboundManagerResetPacket.class, ServerboundManagerResetPacket::encode, ServerboundManagerResetPacket::decode, ServerboundManagerResetPacket::handle);
        MANAGER_CHANNEL.registerMessage(2, ServerboundManagerFixPacket.class, ServerboundManagerFixPacket::encode, ServerboundManagerFixPacket::decode, ServerboundManagerFixPacket::handle);
        MANAGER_CHANNEL.registerMessage(3, ClientboundManagerGuiPacket.class, ClientboundManagerGuiPacket::encode, ClientboundManagerGuiPacket::decode, ClientboundManagerGuiPacket::handle);
        LABEL_GUN_ITEM_CHANNEL.registerMessage(0, ServerboundLabelGunUpdatePacket.class, ServerboundLabelGunUpdatePacket::encode, ServerboundLabelGunUpdatePacket::decode, ServerboundLabelGunUpdatePacket::handle);
        LABEL_GUN_ITEM_CHANNEL.registerMessage(1, ServerboundLabelGunPrunePacket.class, ServerboundLabelGunPrunePacket::encode, ServerboundLabelGunPrunePacket::decode, ServerboundLabelGunPrunePacket::handle);
        LABEL_GUN_ITEM_CHANNEL.registerMessage(2, ServerboundLabelGunClearPacket.class, ServerboundLabelGunClearPacket::encode, ServerboundLabelGunClearPacket::decode, ServerboundLabelGunClearPacket::handle);
        DISK_ITEM_CHANNEL.registerMessage(0, ServerboundDiskItemSetProgramPacket.class, ServerboundDiskItemSetProgramPacket::encode, ServerboundDiskItemSetProgramPacket::decode, ServerboundDiskItemSetProgramPacket::handle);
    }

    public static <MENU extends AbstractContainerMenu, BE extends BlockEntity> void handleServerboundContainerPacket(@Nullable Supplier<NetworkEvent.Context> ctxSupplier, Class<MENU> menuClass, Class<BE> blockEntityClass, BlockPos pos, int containerId, BiConsumer<MENU, BE> callback) {
        if (ctxSupplier == null) {
            return;
        }
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx == null) {
            return;
        }
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            if (sender.m_5833_()) {
                return;
            }
            AbstractContainerMenu menu = sender.f_36096_;
            if (!menuClass.isInstance(menu)) {
                return;
            }
            if (menu.f_38840_ != containerId) {
                return;
            }
            ServerLevel level = sender.m_9236_();
            if (level == null) {
                return;
            }
            if (!level.m_46749_(pos)) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!blockEntityClass.isInstance(blockEntity)) {
                return;
            }
            callback.accept(menu, blockEntity);
        });
    }
}

