/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.LimitedOutputSlot;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ResourceLimit;
import java.util.function.Predicate;

public class OutputResourceTracker<STACK, ITEM, CAP>
implements Predicate<Object> {
    protected final ResourceLimit<STACK, ITEM, CAP> LIMIT;
    protected long transferred = 0L;
    private long retentionObligationProgress = 0L;

    public OutputResourceTracker(ResourceLimit<STACK, ITEM, CAP> resourceLimit) {
        this.LIMIT = resourceLimit;
    }

    public boolean isDone() {
        return this.transferred >= this.LIMIT.limit().quantity() || this.retentionObligationProgress >= this.LIMIT.limit().retention();
    }

    public void visit(LimitedOutputSlot<STACK, ITEM, CAP> slot) {
        STACK stack = slot.getStackInSlot();
        if (this.test(stack)) {
            this.retentionObligationProgress += slot.type.getCount(stack);
        }
    }

    public void trackTransfer(long amount) {
        this.transferred += amount;
        this.retentionObligationProgress += amount;
    }

    public long getMaxTransferable() {
        long remainingRetentionRoom = this.LIMIT.limit().retention() - this.retentionObligationProgress;
        long unusedQuantity = this.LIMIT.limit().quantity() - this.transferred;
        return Math.min(unusedQuantity, remainingRetentionRoom);
    }

    public boolean matchesCapabilityType(Object capability) {
        ResourceType<STACK, ITEM, CAP> resourceType = this.LIMIT.resourceId().getResourceType();
        return resourceType != null && resourceType.matchesCapabilityType(capability);
    }

    @Override
    public boolean test(Object stack) {
        return this.LIMIT.test(stack);
    }
}

