/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ResourceLimit;
import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import java.util.function.Predicate;

public class InputResourceTracker<STACK, ITEM, CAP>
implements Predicate<Object> {
    protected final ResourceLimit<STACK, ITEM, CAP> LIMIT;
    private final Int2LongArrayMap RETENTION_OBLIGATIONS = new Int2LongArrayMap();
    protected long transferred = 0L;
    private int retentionObligationProgress = 0;

    public InputResourceTracker(ResourceLimit<STACK, ITEM, CAP> limit) {
        this.LIMIT = limit;
    }

    public boolean isDone() {
        return this.transferred >= this.LIMIT.limit().quantity();
    }

    public long getExistingRetentionObligation(int slot) {
        return this.RETENTION_OBLIGATIONS.getOrDefault(slot, 0L);
    }

    public long getRemainingRetentionObligation() {
        return this.LIMIT.limit().retention() - (long)this.retentionObligationProgress;
    }

    public void trackRetentionObligation(int slot, long promise) {
        this.retentionObligationProgress = (int)((long)this.retentionObligationProgress + promise);
        this.RETENTION_OBLIGATIONS.merge(slot, promise, Long::sum);
    }

    public ResourceLimit<STACK, ITEM, CAP> getLimit() {
        return this.LIMIT;
    }

    public long getMaxTransferable() {
        return this.LIMIT.limit().quantity() - this.transferred;
    }

    public void trackTransfer(long amount) {
        this.transferred += amount;
    }

    @Override
    public boolean test(Object stack) {
        return this.LIMIT.test(stack);
    }

    public boolean matchesCapabilityType(Object capability) {
        ResourceType<STACK, ITEM, CAP> resourceType = this.LIMIT.resourceId().getResourceType();
        return resourceType != null && resourceType.matchesCapabilityType(capability);
    }
}

