/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.storage;

import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.storage.BeltStorage;
import com.mrbysco.forcecraft.storage.PackStorage;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.server.ServerLifecycleHooks;

public class StorageManager {
    private static final BeltWSD blankBelts = new BeltWSD();
    private static final PackWSD blankPacks = new PackWSD();
    protected static BeltWSD cachedBelts;
    protected static PackWSD cachedPacks;

    public static boolean isServer() {
        return Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER;
    }

    public static BeltWSD getBelts() {
        if (StorageManager.isServer()) {
            if (cachedBelts == null) {
                cachedBelts = (BeltWSD)ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(BeltWSD::load, BeltWSD::new, "forcecraft_belts");
            }
            return cachedBelts;
        }
        return blankBelts;
    }

    public static PackWSD getPacks() {
        if (StorageManager.isServer()) {
            if (cachedPacks == null) {
                cachedPacks = (PackWSD)ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(PackWSD::load, PackWSD::new, "forcecraft_packs");
            }
            return cachedPacks;
        }
        return blankPacks;
    }

    public static BeltStorage getOrCreateBelt(ItemStack stack) {
        UUID uuid;
        BeltWSD data = StorageManager.getBelts();
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("uuid")) {
            uuid = UUID.randomUUID();
            tag.m_128362_("uuid", uuid);
        } else {
            uuid = tag.m_128342_("uuid");
        }
        return data.getOrCreate(uuid);
    }

    public static Optional<BeltStorage> getBelt(ItemStack stack) {
        UUID uuid;
        BeltWSD data;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("uuid") && (data = StorageManager.getBelts()).contains(uuid = stack.m_41783_().m_128342_("uuid"))) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public static Optional<BeltStorage> getBelt(UUID uuid) {
        BeltWSD data = StorageManager.getBelts();
        if (data.contains(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public static PackStorage getOrCreatePack(ItemStack stack) {
        UUID uuid;
        PackWSD data = StorageManager.getPacks();
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("uuid")) {
            uuid = UUID.randomUUID();
            tag.m_128362_("uuid", uuid);
        } else {
            uuid = tag.m_128342_("uuid");
        }
        return data.getOrCreate(uuid);
    }

    public static Optional<PackStorage> getPack(ItemStack stack) {
        UUID uuid;
        PackWSD data;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("uuid") && (data = StorageManager.getPacks()).contains(uuid = stack.m_41783_().m_128342_("uuid"))) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public static Optional<PackStorage> getPack(UUID uuid) {
        PackWSD data = StorageManager.getPacks();
        if (data.contains(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public static Optional<UUID> getUUID(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("uuid")) {
            return Optional.of(stack.m_41783_().m_128342_("uuid"));
        }
        return Optional.empty();
    }

    public static LazyOptional<IItemHandler> getCapability(ItemStack stack) {
        if (StorageManager.isServer() && stack.m_41784_().m_128441_("uuid")) {
            if (stack.m_41720_() instanceof ForceBeltItem) {
                UUID uuid = stack.m_41783_().m_128342_("uuid");
                return StorageManager.getBelt(uuid).map(BeltStorage::getOptional).orElse(LazyOptional.empty());
            }
            if (stack.m_41720_() instanceof ForcePackItem) {
                UUID uuid = stack.m_41783_().m_128342_("uuid");
                return StorageManager.getPack(uuid).map(PackStorage::getOptional).orElse(LazyOptional.empty());
            }
        }
        return LazyOptional.empty();
    }

    protected static class BeltWSD
    extends SavedData {
        public static final String NAME = "forcecraft_belts";
        protected final HashMap<UUID, BeltStorage> BELTS = new HashMap();

        protected BeltWSD() {
        }

        public HashMap<UUID, BeltStorage> get() {
            return this.BELTS;
        }

        public boolean contains(UUID uuid) {
            return this.BELTS.containsKey(uuid);
        }

        public BeltStorage get(UUID uuid) {
            return this.BELTS.get(uuid);
        }

        public BeltStorage getOrCreate(UUID uuid) {
            return this.BELTS.computeIfAbsent(uuid, id -> {
                this.m_77762_();
                return new BeltStorage(uuid);
            });
        }

        public static BeltWSD load(CompoundTag nbt) {
            BeltWSD data = new BeltWSD();
            if (nbt.m_128441_("belts")) {
                ListTag list = nbt.m_128437_("belts", 10);
                list.forEach(invNBT -> data.BELTS.put(((CompoundTag)invNBT).m_128342_("uuid"), new BeltStorage((CompoundTag)invNBT)));
            }
            return data;
        }

        @Nonnull
        public CompoundTag m_7176_(CompoundTag compound) {
            ListTag belts = new ListTag();
            this.BELTS.forEach((uuid, data) -> belts.add((Object)data.toNBT()));
            compound.m_128365_("belts", (Tag)belts);
            return compound;
        }
    }

    public static class PackWSD
    extends SavedData {
        public static final String NAME = "forcecraft_packs";
        protected final HashMap<UUID, PackStorage> PACKS = new HashMap();

        public HashMap<UUID, PackStorage> get() {
            return this.PACKS;
        }

        public boolean contains(UUID uuid) {
            return this.PACKS.containsKey(uuid);
        }

        public PackStorage get(UUID uuid) {
            return this.PACKS.get(uuid);
        }

        public PackStorage getOrCreate(UUID uuid) {
            return this.PACKS.computeIfAbsent(uuid, id -> {
                this.m_77762_();
                return new PackStorage(uuid);
            });
        }

        public static PackWSD load(CompoundTag nbt) {
            PackWSD data = new PackWSD();
            if (nbt.m_128441_("packs")) {
                ListTag list = nbt.m_128437_("packs", 10);
                list.forEach(invNBT -> data.PACKS.put(((CompoundTag)invNBT).m_128342_("uuid"), new PackStorage((CompoundTag)invNBT)));
            }
            return data;
        }

        @Nonnull
        public CompoundTag m_7176_(CompoundTag compound) {
            ListTag packs = new ListTag();
            this.PACKS.forEach((uuid, data) -> packs.add((Object)data.toNBT()));
            compound.m_128365_("packs", (Tag)packs);
            return compound;
        }
    }
}

