/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.networking.message;

import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.menu.ForceBeltMenu;
import com.mrbysco.forcecraft.storage.BeltStorage;
import com.mrbysco.forcecraft.storage.StorageManager;
import com.mrbysco.forcecraft.util.FindingUtil;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class OpenBeltMessage {
    public void encode(FriendlyByteBuf buf) {
    }

    public static OpenBeltMessage decode(FriendlyByteBuf packetBuffer) {
        return new OpenBeltMessage();
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ItemStack beltStack;
            Predicate<ItemStack> stackPredicate;
            ServerPlayer player;
            if (ctx.getDirection().getReceptionSide().isServer() && ctx.getSender() != null && FindingUtil.hasSingleStackInHotbar((Player)(player = ctx.getSender()), stackPredicate = stack -> stack.m_41720_() instanceof ForceBeltItem) && !(beltStack = FindingUtil.findInstanceStack((Player)player, stackPredicate)).m_41619_()) {
                Optional<BeltStorage> data = StorageManager.getBelt(beltStack);
                data.ifPresent(belt -> NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, pInv, pEntity) -> new ForceBeltMenu(id, pInv, belt.getInventory()), (Component)(beltStack.m_41788_() ? ((MutableComponent)beltStack.m_41786_()).m_130940_(ChatFormatting.BLACK) : Component.m_237115_((String)"forcecraft.container.belt")))));
            }
        });
        ctx.setPacketHandled(true);
    }
}

